/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.psm;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.debugger.api.SourcePath;
import org.netbeans.modules.bpel.debugger.api.psm.ProcessStaticModel;
import org.netbeans.modules.bpel.debugger.spi.ProcessStaticModelProvider;
import org.netbeans.modules.bpel.debugger.ui.util.Log;
import org.netbeans.modules.bpel.debugger.ui.util.EditorUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.loaders.DataObject;

/**
 *
 * @author Alexander Zgursky
 */
public class ProcessStaticModelProviderImpl
        implements ProcessStaticModelProvider
{
    private final ContextProvider myContextProvider;
    private final Map<QName, ProcessStaticModel> myModels =
            new HashMap<QName, ProcessStaticModel>();
    
    /** Creates a new instance of ProcessStaticModelProviderImpl */
    public ProcessStaticModelProviderImpl(ContextProvider contextProvider) {
        myContextProvider = contextProvider;
    }

    public ProcessStaticModel getModel(QName processQName) {
        ProcessStaticModel psm = myModels.get(processQName);
        if (psm == null) {
            SourcePath sourcePath = (SourcePath)myContextProvider.
                    lookupFirst(null, SourcePath.class);
            
            String url = sourcePath.getSourcePath(processQName);
            if (url == null) {
                Log.out("Could not find source file for process: " + processQName);
                return null;
            }
            DataObject dataObject = EditorUtil.getDataObject(url);
            if (dataObject == null) {
                Log.out("DataObject is null: " + url);
                return null;
            }

            BpelModel bpelModel = EditorUtil.getBpelModel(dataObject);
            if (bpelModel == null) {
                Log.out("BpelModel is null: " + url);
                return null;
            }
            
            psm = ProcessStaticModelImpl.build(processQName, bpelModel);
            if (psm == null) {
                Log.out("Couldn't build Process Static Model from BPEL Model" + url);
                return null;
            }
            
            myModels.put(processQName, psm);
        }
        
        return psm;
    }
}
