/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.xam;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URI;
import java.nio.channels.FileChannel;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.text.syntax.XMLKit;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Exit;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.PatternedCorrelationContainer;
import org.netbeans.modules.bpel.model.api.ReThrow;
import org.netbeans.modules.bpel.model.impl.BpelModelImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;


public class Util {
    
    static final String DATA = "data";
   
    static final String PROCESS = "process.bpel";
    
    static final String WORKDIR = System.getProperty("xtest.workdir");
    
    static final String MY_DATA = WORKDIR + File.separator + "data";
    
    
    public static Document loadDocument() throws Exception {
        return loadDocument( 
                new FileInputStream( MY_DATA + File.separator +PROCESS ) );     
    }
    
    public static BpelModelImpl loadModel() throws Exception {
        Document doc = loadDocument();
        BpelModelImpl model = new BpelModelImpl( doc , null );
        model.sync();
        return model;
    }
    
    public static BpelModelImpl loadModel( String string ) throws Exception {
        Document doc = loadDocument( string );
        BpelModelImpl model = new BpelModelImpl( doc ,  null);
        model.sync();
        return model;
    }
    
    
    public static Document getResourceAsDocument(String path) throws Exception {
        InputStream in = Util.class.getResourceAsStream(path);
        return loadDocument(in);
    }
    
    public static Document loadDocument(InputStream in) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuffer sbuf = new StringBuffer();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                sbuf.append(line);
                sbuf.append(System.getProperty("line.separator"));
            }
        } finally {
            reader.close();
        }
        return loadDocument( sbuf.toString() );
    }
    
    public static Document loadDocument( String string ) throws Exception {
        Document document = new BaseDocument(
                XMLKit.class, false);
        document.insertString(0, string ,null);
        return document;
    }
    

    
    public static void dumpToStream(Document doc, OutputStream out) throws Exception{
        PrintWriter w = new PrintWriter(out);
        w.print(doc.getText(0, doc.getLength()));
        w.close();
        out.close();
    }
    
    public static void dumpToFile(Document doc, File f) throws Exception {
        OutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        PrintWriter w = new PrintWriter(out);
        w.print(doc.getText(0, doc.getLength()));
        w.close();
        out.close();
    }

    
    public static Document loadDocument(File f) throws Exception {
        InputStream in = new BufferedInputStream(new FileInputStream(f));
        return loadDocument(in);
    }
    
    public static URI getResourceURI(String path) throws RuntimeException {
        try {
            return Util.class.getResource(path).toURI();
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
    
    static void createData(){
        URI uri = getResourceURI( DATA );
        File file = new File( uri );
        File[] files = file.listFiles();
        
        File my_Data = new File( MY_DATA );
        if ( my_Data.exists() && !my_Data.isDirectory() ) {
            my_Data.delete();
        }
        if ( !my_Data.exists() ) {
            my_Data.mkdir();
        }
         
        for (File fil : files) {
            try {              
                FileChannel srcChannel = new FileInputStream( fil ).getChannel();
                            
                FileChannel dstChannel = 
                    new FileOutputStream( my_Data.getAbsolutePath() +
                            File.separator +fil.getName() ).getChannel();
                            
                dstChannel.transferFrom(srcChannel, 0, srcChannel.size());
                           
                srcChannel.close();
                dstChannel.close();
            } catch (IOException e) {
            }
        }
    }
    
    public static void debug(String str) {
        try {
            BufferedWriter writer = new BufferedWriter( new FileWriter( LOG, true) );
            writer.write( str + "\n");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {         
        }
    }
    
    public static org.w3c.dom.Document flush( BpelModelImpl model ) {
        return flush( model, null);
    }
    
    public static org.w3c.dom.Document flush( BpelModelImpl model , 
            StringBuilder content ) 
    {
        //model.getAccess().flush();
        
        Exception exception = null;
        try {
            String str = model.getBaseDocument().
            getText( 0, model.getBaseDocument().getLength() );
            if ( content!= null ) {
                content.append( str );
            }
            DocumentBuilder builder =
                DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse( new InputSource( new StringReader( str )) );
        }
        catch (ParserConfigurationException e) {
            exception = e;
        }
        catch (BadLocationException e) {
            assert false;
        }
        catch (SAXException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        if ( exception != null ) {
            AssertionError error = new AssertionError( );
            error.initCause( exception );
            throw error;
        }
        return null;
    } 
    
    public static String getTagName( BpelEntity entity ){       
        if ( entity instanceof PatternedCorrelation ){
            return "correlation";
        }
        else if ( entity instanceof PatternedCorrelationContainer ) {
            return "correlations";
        }
        else if ( entity instanceof Exit ){
            return "exit";
        }
        else if ( entity instanceof ReThrow ){
            return "rethrow";
        }
        /*else if ( entity instanceof VariableContainer ){
            return "variables";
        }
        else if ( entity instanceof CorrelationSetContainer ){
            return "correlationSets";
        }*/     
        String name = entity.getClass().getSimpleName();
        int index = name.indexOf("ContainerImpl");
        /* here we handle some set of entitis that have "s" on the end
         * of his tag name and they implements interface with Container
         * word at the end.
         */ 
        if ( index!= -1 ) {
            name = name.substring( 0 , index );
            char ch = name.charAt(0);
            return Character.toLowerCase( ch ) +name.substring( 1 )+"s";
        }
        index = name.indexOf("Impl");
        name = name.substring( 0 , index );
        char ch = name.charAt(0);
        return Character.toLowerCase( ch ) +name.substring( 1 );
    }
    
    private static  String LOG = WORKDIR +File.separator+"bpeltests.log";
}
