/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.api.resources;


/**
 * This is class for mark its pacakge.
 * We can access to files in this package via pointer to this class.
 * If package chages his name it will automatically reflected in usages
 * ( via refactoring ).
 * @author ads
 *
 */
public final class ResourcePackageMarker {
    
    private ResourcePackageMarker() {
    }
    
    public static final String WS_BPEL_SCHEMA       = "wsbpel_2_0.xsd";   // NOI18N
    
    public static final String WS_BPEL_1_1_SCHEMA   = "bpel4ws_1_1.xsd";  // NOI18N
    
    public static final String XSD_SCEMA            = "xml.xsd";          // NOI18N
    /**
     *
     * fix for IZ94241:
     * class.getPackage() returns null with antClassloader
     * workaround is to use class name and extract package name from it.
     *
     * @returns package name for this class
     **/
    public static String getPackage(){
        String result = ResourcePackageMarker.class.getName();
        int last = result.lastIndexOf(".");
        return result.substring(0, last).replace('.','/');
    }
}
