/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */
package org.netbeans.modules.cnd.syntaxerr.highlighter;

import org.netbeans.modules.cnd.syntaxerr.provider.ErrorInfo;
import org.openide.text.Annotation;

/**
 * A common base class for both error and warning annotations
 * @author Vladimir Kvashin
 */
/* package-local */
class AnnotationImpl extends Annotation {

    private String type;
    private String message;
    
    public AnnotationImpl(ErrorInfo info) {
        this.message = info.getMessage();
        this.type = getType(info.getSeverity());
    }
    
    private String getType(ErrorInfo.Severity severity) {
        switch( severity ) {
        case ERROR:
            return "org-netbeans-modules-cnd-syntaxerr-error"; // NOI18N
        case WARNING:
            return "org-netbeans-modules-cnd-syntaxerr-warning"; // NOI18N
        default:
            throw new IllegalArgumentException("Unexpected ErrorInfo.Severity: " + severity); // NOI18N
        }
    }
    
    public String getAnnotationType() {
        return type;
    }
    
    public String getShortDescription() {
        return message;
    }
}
