/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.cnd.repository.testbench;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.impl.SoftRefHybridRepository;
//import org.netbeans.modules.cnd.repository.impl.SoftRefRepository;

/**
 *
 * @author Sergey Grinev
 */
public final class TestBench {
    
    public int outerPasses = 10;
    public int innerPasses = 20;
    public double loadLimit = 0.05;
    public double loadFrequency = 0.001;
    public double memoryWasteFrequency = 0.001;
    public long maxAmount = 10000;
    public int timeout = 100;
    public int memoryToWaste = 1024; //Kb
    public boolean verbose = true;
    
    public void test() {
        start();
        String st;
        int i = 0;
        
        
        rand.setSeed(loop);
        long time = System.currentTimeMillis();
        
        // Saving
        while((st = next()) != null) {
            
            //System.out.println("debugPut:" + i);
            for (int j = 0; j < innerPasses; j++) {
                StringKey key = new StringKey(st, i++);
                repository.put(key,new StringContainer(st));
            }

            // Loading
            if (rand.nextDouble() <= loadFrequency )
                doLoad();
            if (memoryToWaste > 0 && rand.nextDouble() <= memoryWasteFrequency) {
                wastedMemory.add( new byte[memoryToWaste*1024] );
                if (verbose) System.out.println("Wasted " + memoryToWaste + " Kb."); //NOI18N
            }
            if (rand.nextDouble() <= 0.001)
                Stats.report();
        }
        
        Stats.report();
        System.err.println("This took " + (System.currentTimeMillis() - time) + " ms"); // NOI18N
        finish();
    }
    
    // Service methods and variables
    private int loop = 1;
    private Repository repository;
    private DataProvider dataProvider;
    private List wastedMemory = new ArrayList();
    private long amount = 0;
    private static String STRING = "RandomStringConstantForSomeUnknownReasonUsedAsOurTestData"; //57b //NOI18N
    private static Random rand = new Random();
    
    private String next() {
        if (++amount > maxAmount )
            return null;
        if (dataProvider == null )
            return STRING;
        return
            dataProvider.get(); 
    }
    
    private void doLoad() {
        if (timeout > 0) {
            try {
                Thread.sleep(timeout);
            } catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        
        // Loading
        long startLoadFrom = Math.round( amount * (1.0 - loadLimit) * rand.nextDouble() );
        long loadAsManyAs = Math.round( (double)amount * loadLimit ) - 1;
        for (long j = startLoadFrom; j < startLoadFrom + loadAsManyAs; j++) {
            repository.get(new StringKey(STRING , (int)j));
        }
    }
    
    void start() {
        if (verbose) System.out.println("** Start loop " + loop++); //NOI18N
    }
    void finish() {
        if (verbose) System.out.println("** Finish **"); //NOI18N
    }
    private static Repository getRepository() {
//        return new SoftRefRepository();
        return new SoftRefHybridRepository();
    }
    
    public static void main(String[] args) {
//        String provider = null;
        TestBench tb = new TestBench();
        for (int i = 0; i < args.length; i++) {
            try {
                if (args[i].equalsIgnoreCase("-p")) if (++i<args.length) //NOI18N
                    tb.outerPasses = new Integer(args[i]); else break;
                else if (args[i].equalsIgnoreCase("-i")) if (++i<args.length) //NOI18N
                    tb.innerPasses = new Integer(args[i]); else break;
                else if (args[i].equalsIgnoreCase("-l")) if (++i<args.length) //NOI18N
                    tb.loadLimit = new Double(args[i]); else break;
                else if (args[i].equalsIgnoreCase("-t")) if (++i<args.length) //NOI18N
                    tb.timeout = new Integer(args[i]); else break;
                else if (args[i].equalsIgnoreCase("-m")) if (++i<args.length) //NOI18N
                    tb.memoryToWaste = new Integer(args[i]); else break;
                else if (args[i].equalsIgnoreCase("-x")) if (++i<args.length) //NOI18N
                    tb.maxAmount = new Integer(args[i]); else break;
                else if (args[i].equalsIgnoreCase("-lf")) if (++i<args.length) //NOI18N
                    tb.loadFrequency = new Double(args[i]); else break;
                else if (args[i].equalsIgnoreCase("-mf")) if (++i<args.length) //NOI18N
                    tb.memoryWasteFrequency = new Double(args[i]); else break;
                else if (args[i].equalsIgnoreCase("-j")) if (++i<args.length) //NOI18N
                    System.out.println("Memory limit is " + args[i] + "M."); else break; //NOI18N
                //else if (args[i].equalsIgnoreCase("-f")) if (++i<args.length) //NOI18N
                //    provider = args[i]; else break;
                else if (args[i].equalsIgnoreCase("-q"))  //NOI18N
                    tb.verbose = false;
                else
                    System.out.println("Unknown Parameter: " + args[i] + ". Ignored."); //NOI18N
            } catch (NumberFormatException ex) {
                System.out.println("Invalid Parameter: " + args[i] + ". Expected numeric after " + args[i-1] + "."); //NOI18N
                ex.printStackTrace();
                return;
            }
        }
        System.out.println(
                "[o: " + tb.outerPasses + //NOI18N
                ", i: " + tb.innerPasses + //NOI18N
                ", x: " + tb.maxAmount + //NOI18N
                ", l: " + tb.loadLimit + //NOI18N
                ", lf: " + tb.loadFrequency + //NOI18N
                ", t: " + tb.timeout + //NOI18N
                ", mf: " + tb.memoryWasteFrequency + //NOI18N
                ", m: " + tb.memoryToWaste + "]" //NOI18N
                );
        
        for (int n = 0; n < tb.outerPasses; n++) {
//            if (provider != null)
//                tb.setDataProvider(new DataProvider(provider));
            tb.setRepository(getRepository());
            tb.test();
        }
    }
    
    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }
    
    public void setRepository(Repository repository) {
        this.repository = repository;
    }
    
    public boolean hasDataProvider() {
        return null != dataProvider;
    }
}
