<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

  <xsl:output method="html" indent="yes"/>

  <!-- template rule matching source root element -->
  <xsl:template match="/">
    <html> <head> 
    <title>Java AVK for the Enterprise Report Tool </title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <LINK href="./appVerification.css" rel="stylesheet" type="text/css"> 
    </LINK>
    </meta>
    </head>

    <xsl:apply-templates select="static-verification"/>
    </html>
  </xsl:template>

  <xsl:template match="static-verification">
     <body bgcolor="#FFFFFF" background="./Lt_BluePaperTexture.gif">
     <form method="post" action="">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
           <tr bgcolor="7171A5">
             <td width="100%"> 
                <div class="page-title-text" align="left">Java AVK for the Enterprise - Static Archive Test Summary </div>
             </td>
           </tr>
        </table>
     <br>

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
        <td> 
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
            <td width="45%"> 
              <div class="table-header-text" align="left">Static Archive Results Summary </div>
            </td>
	    <td WIDTH="55%"/>
	  </tr>
	  <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
	 </tr>
	  <tr>
            <td width="24%"> 
              <div class="table-normal-text" align="left">Failures: </div>
            </td>
            <td width="76%">
              <div class="table-normal-text" align="left">
		<xsl:value-of select="./failure-count/failure-number"/>
 </div>

            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>

          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Warnings: </div>
	    </td>
            <td width="76%" valign="bottom"> 
             <div class="table-normal-text" align="left">
		<xsl:value-of select="./failure-count/warning-number"/>
	      </div>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>

       </table>
	</td>
	</tr>
	</table>
     </br>

     <xsl:choose>
     <xsl:when test="count(application) != 0">
     <br>
      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
        <td> 
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
            <td width="45%"> 
              <div class="table-header-text" align="left">Application Module </div>
            </td>
	    <td WIDTH="55%"/>
	  </tr>
	  <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
	 </tr>
	  <tr>
            <td width="24%"> 
              <div class="table-normal-text" align="left">Failures: </div>
            </td>
            <td width="76%">
	     <xsl:choose>
	     <xsl:when test="count(application/failed) != 0">
              <div class="table-failed-text" align="left"><a href="appFailuresDetail.html">click to see failed items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Failures </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>

	  <xsl:choose>
	  <xsl:when test="count(application/not-applicable) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Not-applicable: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(application/not-applicable) != 0">
              <div class="table-failed-text" align="left"><a href="appNADetail.html">click to see not-applicable items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No not-applicable items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	  </xsl:when>
	  </xsl:choose>
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Warnings: </div>
	    </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(application/warning) != 0">
              <div class="table-failed-text" align="left"><a href="appWarningDetail.html">click to see Warnings </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Warnings </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>

	 <xsl:choose>
	 <xsl:when test="count(application/passed) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Passed: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(application/passed) != 0">
              <div class="table-failed-text" align="left"><a href="appPassedDetail.html">click to see Passed items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Passed items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
	 </xsl:when>
	 </xsl:choose>
       </table>
	</td>
	</tr>
	</table>

     </br>
    </xsl:when>
    </xsl:choose>
     <xsl:choose>
     <xsl:when test="count(ejb) != 0">
     <br>

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
        <td> 
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
            <td width="45%"> 
              <div class="table-header-text" align="left">EJB Module </div>
            </td>
	    <td WIDTH="55%"/>
	  </tr>
	  <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
	 </tr>
	  <tr>
            <td width="24%"> 
              <div class="table-normal-text" align="left">Failures: </div>
            </td>
            <td width="76%">
	     <xsl:choose>
	     <xsl:when test="count(ejb/failed) != 0">
              <div class="table-failed-text" align="left"><a href="ejbFailureDetail.html">Failed </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Failures </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>

	  <xsl:choose>
	  <xsl:when test="count(ejb/not-applicable) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Not-applicable: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(ejb/not-applicable) != 0">
              <div class="table-failed-text" align="left"><a href="ejbNADetail.html">click to see not-applicable items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No not-applicable items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	 </xsl:when>
	 </xsl:choose>

          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Warnings: </div>
	    </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(ejb/warning) != 0">
              <div class="table-failed-text" align="left"><a href="ejbWarningDetail.html">click to see Warnings </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Warnings </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	 <xsl:choose>
	 <xsl:when test="count(ejb/passed) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Passed: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(ejb/passed) != 0">
              <div class="table-failed-text" align="left"><a href="ejbPassedDetail.html">click to see Passed items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Passed items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
	  </xsl:when>
	 </xsl:choose>

       </table>
	</td>
	</tr>
	</table>

     </br>
     </xsl:when>
     </xsl:choose>
     <xsl:choose>
     <xsl:when test="count(web) != 0">
     <br>

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
        <td> 
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
            <td width="45%"> 
              <div class="table-header-text" align="left">Web Module </div>
            </td>
	    <td WIDTH="55%"/>
	  </tr>
	  <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
	 </tr>
	  <tr>
            <td width="24%"> 
              <div class="table-normal-text" align="left">Failures: </div>
            </td>
            <td width="76%">
	     <xsl:choose>
	     <xsl:when test="count(web/failed) != 0">
              <div class="table-failed-text" align="left"><a href="webFailureDetail.html">Failed </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Failures </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>

	  <xsl:choose>
	  <xsl:when test="count(web/not-applicable) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Not-applicable: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(web/not-applicable) != 0">
              <div class="table-failed-text" align="left"><a href="webNADetail.html">click to see not-applicable items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No not-applicable items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	 </xsl:when>
	 </xsl:choose>

          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Warnings: </div>
	    </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(web/warning) != 0">
              <div class="table-failed-text" align="left"><a href="webWarningDetail.html">click to see Warnings </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Warnings </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	  <xsl:choose>
	  <xsl:when test="count(web/passed) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Passed: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(web/passed) != 0">
              <div class="table-failed-text" align="left"><a href="webPassedDetail.html">click to see Passed items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Passed items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
	 </xsl:when>
	 </xsl:choose>
       </table>
	</td>
	</tr>
	</table>

     </br>
     </xsl:when>
     </xsl:choose>
     <xsl:choose>
     <xsl:when test="count(connector) != 0">
     <br>

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
        <td> 
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
            <td width="45%"> 
              <div class="table-header-text" align="left">Connector Module </div>
            </td>
	    <td WIDTH="55%"/>
	  </tr>
	  <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
	 </tr>
	  <tr>
            <td width="24%"> 
              <div class="table-normal-text" align="left">Failures: </div>
            </td>
            <td width="76%">
	     <xsl:choose>
	     <xsl:when test="count(connector/failed) != 0">
              <div class="table-failed-text" align="left"><a href="conFailureDetail.html">Failed </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Failures </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>

	 <xsl:choose>
	 <xsl:when test="count(connector/not-applicable) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Not-applicable: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(connector/not-applicable) != 0">
              <div class="table-failed-text" align="left"><a href="conNADetail.html">click to see not-applicable items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No not-applicable items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	 </xsl:when>
	 </xsl:choose>
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Warnings: </div>
	    </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(connector/warning) != 0">
              <div class="table-failed-text" align="left"><a href="conWarningDetail.html">click to see Warnings </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Warnings </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	  <xsl:choose>
	  <xsl:when test="count(connector/passed) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Passed: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(connector/passed) != 0">
              <div class="table-failed-text" align="left"><a href="conPassedDetail.html">click to see Passed items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Passed items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
	 </xsl:when>
	</xsl:choose>
       </table>
	</td>
	</tr>
	</table>
     </br>
    </xsl:when>
    </xsl:choose>
    <xsl:choose>
     <xsl:when test="count(appclient) != 0">
     <br>

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
        <td> 
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
            <td width="45%"> 
              <div class="table-header-text" align="left">Appclient Module </div>
            </td>
	    <td WIDTH="55%"/>
	  </tr>
	  <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
	 </tr>
	  <tr>
            <td width="24%"> 
              <div class="table-normal-text" align="left">Failures: </div>
            </td>
            <td width="76%">
	     <xsl:choose>
	     <xsl:when test="count(appclient/failed) != 0">
              <div class="table-failed-text" align="left"><a href="acFailureDetail.html">Failed </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Failures </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>

	 <xsl:choose>
	 <xsl:when test="count(appclient/not-applicable) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Not-applicable: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(appclient/not-applicable) != 0">
              <div class="table-failed-text" align="left"><a href="acNADetail.html">click to see not-applicable items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No not-applicable items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
         </xsl:when>
         </xsl:choose>

          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Warnings: </div>
	    </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(appclient/warning) != 0">
              <div class="table-failed-text" align="left"><a href="acWarningDetail.html">click to see Warnings </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Warnings </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	  <xsl:choose>
	  <xsl:when test="count(appclient/passed) != 0">
          <tr> 
            <td width="24%" valign="top"> 
              <div class="table-normal-text">Passed: </div>
            </td>
            <td width="76%" valign="bottom"> 
	     <xsl:choose>
	     <xsl:when test="count(appclient/passed) != 0">
              <div class="table-failed-text" align="left"><a href="acPassedDetail.html">click to see Passed items </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Passed items </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
	 </xsl:when>
	 </xsl:choose>
       </table>
	</td>
	</tr>
	</table>

     </br>
     </xsl:when>
     </xsl:choose>

     <br>

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
        <td> 
      <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
            <td width="45%"> 
              <div class="table-header-text" align="left">Execution Errors </div>
            </td>
	    <td WIDTH="55%"/>
	  </tr>
	  <tr height="1">
            <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
	 </tr>
	  <tr>
            <td width="24%"> 
              <div class="table-normal-text" align="left">Errors: </div>
            </td>
            <td width="76%">
	     <xsl:choose>
	     <xsl:when test="count(error/error-name) != 0">
              <div class="table-failed-text" align="left"><a href="errFailureDetail.html">Failed </a></div>
	     </xsl:when>
	     <xsl:otherwise>
              <div class="table-normal-text" align="left">No Errors </div>
	     </xsl:otherwise>
	    </xsl:choose>
            </td>
          </tr>
	</table>
	</td>
	</tr>
	</table>
        </br> 
     </form>
     </body>
  </xsl:template>

<xsl:template/>
</xsl:stylesheet>