/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.netbeans.microedition.databinding;

import org.netbeans.microedition.databinding.core.BindDescriptor;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import org.netbeans.microedition.databinding.core.DataBindingELContext;
import org.netbeans.microedition.databinding.el.StringReader;
import org.netbeans.microedition.databinding.el.parser.ELParser;
import org.netbeans.microedition.databinding.el.parser.ParseException;

/**
 * @author David Kaspar
 * @author Martin Brehovsky
 */
public final class DataBinder {

    private static Hashtable rootDataSets = new Hashtable ();
    private static Vector binds = new Vector (); // TODO predelat na hashset

    private DataBinder () {
    }

    public static void bind (String elPointer, DataBindingProvider binder, Object consumer, Object feature) {
        BindDescriptor desc = new BindDescriptor (elPointer, binder, consumer, feature);
        boolean found = false;
        // TODO predelat na equals a hashset
        for (int a = 0; a < binds.size (); a ++) {
            BindDescriptor inner = (BindDescriptor) binds.elementAt (a);            
            if (inner.equalsBindTarget (desc)) {
                binds.setElementAt (desc, a);
                found = true;
                break;
            }
        }
        if (! found)
            binds.addElement (desc);
        desc.notifyBind ();
        desc.updateFromDataSourceToCustomer ();
    }

    public static void unbind (Object consumer, Object feature) {
        BindDescriptor desc = new BindDescriptor (null, null, consumer, feature);
        for (int a = 0; a < binds.size (); a ++) {
            BindDescriptor inner = (BindDescriptor) binds.elementAt (a);
            if (inner.equalsBindTarget (desc)) {
                inner.notifyUnbind ();
                binds.removeElementAt (a);
                return;
            }
        }
    }

    public static void registerDataSet (DataSet dataSet, String variable) {
        if (dataSet == null)
            throw new IllegalArgumentException ("null dataset");
        if (variable == null)
            throw new IllegalArgumentException ("null variable");
        if (rootDataSets.contains (variable))
            throw new IllegalArgumentException ("variable already registered");
        rootDataSets.put (variable, dataSet);
        fireDataSetChanged (null, variable);
    }

    public static void unregisterDataSet (String variable) {
        if (variable == null)
            throw new IllegalArgumentException ("null variable");
        if (rootDataSets.remove (variable) == null)
            throw new IllegalArgumentException ("variable not registered");
        fireDataSetChanged (null, variable);
    }

    public static DataSet getRegisteredDataSet (String variable) {
        return (DataSet) rootDataSets.get (variable);
    }

    public static void updateConsumer (String elPointer, DataBindingProvider binder, Object consumer, Object feature) {
        new BindDescriptor (elPointer, binder, consumer, feature).updateFromDataSourceToCustomer ();
    }

    public static void updateDataSet (String elPointer, DataBindingProvider binder, Object consumer, Object feature) {
        new BindDescriptor (elPointer, binder, consumer, feature).updateFromCustomerToDataSource ();
    }

    public static Object readValue(String elPointer) {
        ELParser parser = new ELParser (new StringReader (elPointer), DataBindingELContext.CONTEXT, false);
        try {
            return parser.Expression ();
        } catch (ParseException e) {
            e.printStackTrace (); // TODO
            return null;
        }
    }
    
    public static void writeValue(String elPointer, Object value) {
        ELParser parser = new ELParser (new StringReader (elPointer), DataBindingELContext.CONTEXT, true);
        try {
            parser.Expression();
            Object pointerProperty = parser.getLastPointerProperty();
            if (pointerProperty instanceof String) {
                ((DataSet) parser.getLastPointerBase()).setValue ((String)pointerProperty, value);
            } if (pointerProperty instanceof Integer) {
                ((IndexableDataSet) parser.getLastPointerBase()).setRow (((Integer) pointerProperty).intValue(), value);
            } if (pointerProperty instanceof Long) {
                ((IndexableDataSet) parser.getLastPointerBase()).setRow ((int) ((Long) pointerProperty).longValue(), value);
            } // else TODO throw databiding exception
        } catch (ParseException e) {
            e.printStackTrace (); // TODO
        } catch (DataBindingException e) {
            e.printStackTrace (); // TODO
        }
    }
    
    // TODO - maybe the index could be a part of elPointer
    public static void insertRow (String elPointer, int index, Object value) {
        throw new IllegalStateException ("Not implemented yet!"); // TODO
    }
    
    // TODO - maybe the index could be a part of elPointer
    public static void deleteRow (String elPointer, int index) {
        throw new IllegalStateException ("Not implemented yet!"); // TODO
    }
    
    public static void fireDataSetChanged (DataSet dataSet, Object dataItemName) {
        // TODO - force using Integer only for array indexing
        if( dataItemName instanceof Long )
            throw new IllegalArgumentException( "Long indexing is forbidden." ); 
       
        Enumeration e = binds.elements ();
        while (e.hasMoreElements ()) {
            BindDescriptor desc = (BindDescriptor) e.nextElement ();
            if (desc.containsDataSetItem (dataSet, dataItemName))
                desc.updateFromDataSourceToCustomer ();
        }
    }

} 