<%--
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
 --%>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@page contentType="text/html"%>
<%@ taglib uri="/WEB-INF/waftags.tld" prefix="waf" %>

<sql:setDataSource dataSource="jdbc/CatalogDB"/>

<%-- Need to set the category id  --%>
 <c:choose>
  <c:when test="${param.CATEGORY_ID  != null}">
   <c:set var="theCategory" value="${param.CATEGORY_ID}" scope="session"/>
   <c:set var="categoryId" value="${param.CATEGORY_ID}" scope="session"/>
  </c:when>
  <c:otherwise>
   <c:set var="theCategory" value="${categoryId}" scope="session"/>
  </c:otherwise>
 </c:choose>


<sql:query var="packages"> 
 select distinct package.packageid, package.name as pname,category.name  as cname, category.catid from  package, category  where package.catid=?  and category.catid = ? and package.locale = ?
 <sql:param>${theCategory}</sql:param>
 <sql:param>${theCategory}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>

<sql:query var="categories"> 
 select catid,name,description from category where locale = ? order by name
 <sql:param>en_US</sql:param>
</sql:query>

<table  cellspacing="12" cellpadding="12" border="0">

 <tr>
    <td  align="left" nowrap="nowrap" bgcolor="#ffffff">
       <strong class="navigationTitle">Adventure Categories</strong>
    </td>
   </tr>
   <tr>
    <td nowrap="nowrap">

         <c:forEach var="category" begin="0" items="${categories.rows}">
          <c:url value="/adventures.screen" var="viewCategoryURL">
          <c:param name="CATEGORY_ID" value="${fn:trim(category.catid)}"/>
         </c:url>

          <p class="navigation">
            <c:choose>
             <c:when test="${param.CATEGORY_ID == fn:trim(category.catid)}">
                <image src="images/Arrow_small.gif" width="10" height="14" alt="Selected Arrow Image">
             </c:when>
             <c:otherwise>
               <image src="images/Arrow_spacer.gif" alt="">
             </c:otherwise>
            </c:choose>
           <a href="${viewCategoryURL}">${category.name}</a>
          </p>
          <c:choose>
           <%-- List the Sub Category Stuff here --%>
           <c:when test="${fn:trim(category.catid) == theCategory}">
            <c:forEach var="package" begin="0" items="${packages.rows}">
            <p class="sub_navigation">
             <c:url value="/adventure.screen" var="viewPackageURL">
              <c:param name="PACKAGE_ID" value="${fn:trim(package.packageid)}"/>
             </c:url>
             &nbsp;&nbsp;&nbsp;
            <c:choose>
             <%-- Identify a selected Adventure Package --%>
             <c:when test="${param.PACKAGE_ID == fn:trim(package.packageid)}">
                <image src="images/Arrow_small.gif" alt="Selected Arrow Image">
             </c:when>
             <c:otherwise>
               <image src="images/Arrow_spacer.gif" alt="">
             </c:otherwise>
            </c:choose>
            <a href="${viewPackageURL}">${package.pname}</a>
             </p>
            </c:forEach>
           </c:when>
           <%-- Done Listing the Sub Category Stuff here --%>
          </c:choose>
       </c:forEach>
       </td>
     </tr>
   </table>


