<%-- 
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
 --%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib uri="/WEB-INF/waftags.tld" prefix="waf" %>
<%@ taglib prefix="abtags" tagdir="/WEB-INF/tags" %> 
<%@page contentType="text/html"%>

<table>
  <tr>
   <td>
    <label for="head_count_id">Number of People:<label>
   </td>
   <td>
     <waf:select size="1" name="head_count" id="head_count_id">
      <waf:selected>${cart.headCount}</waf:selected>
      <c:forEach varStatus="status" begin="1" end="9">
       <waf:option>${status.index}</waf:option>
      </c:forEach>
     </waf:select>
    </td>
  </tr>
  <tr>
   <td>
    Start Date:
   </td>
   <td>
      <waf:date prefix="start" calendar="${cart.departureDate}"/>
    </td>
  </tr>
  <tr>
    <td>
       <label for="number_of_days">Number of Days</label>:
    </td>
    <td>
     <waf:select name="adventure_days" id="number_of_days">
      <waf:selected>${cart.adventureDays}</waf:selected>
     <c:forEach varStatus="status" begin="3" end="31">
       <waf:option>${status.index}</waf:option>
     </c:forEach>
     </waf:select>
    </td>
  </tr>
  <tr>
    <td>
       <label for="lodging_room_count">Number of Lodging Rooms:</label>
    </td>
    <td>
     <waf:select name="lodging_room_count" id="lodging_room_count">
     <waf:selected>${cart.lodgingRoomCount}</waf:selected>
     <c:forEach varStatus="status" begin="1" end="5">
       <waf:option>${status.index}</waf:option>
     </c:forEach>
     </waf:select>
    </td>
  </tr>
  <tr>
   <td align="right" colspan="3">
    <input type="SUBMIT" value="Set Package Options" name="Set Package Options"/>
  </td>
  </tr>
</table>



