<%-- 
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
 --%>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<fmt:setLocale value="en_US" />

<h1> Departure - Available Flights</h1>
<br><br>

<table border="0">
 <form method="POST" action="cart.do">
  <input type="HIDDEN" name="target_action" value="purchase_transportation" >
  <input type="HIDDEN" name="tab" value="${param.tab}">
 <c:forEach var="item" varStatus="status"  begin="0" items="${departure_result}">
  <tr>
    <td>
     <c:url var="imageURL" value="images/${item.imageURI}"/>
     <image src="${imageURL}" alt="${item.name} Image">
    </td>
   <td>
             <b>${item.carrier}:</b> ${item.name}<br>
             <b>Departure Time :</b> ${item.departureTime}<br>
             <b>Arrival Time :</b> ${item.arrivalTime}<br>
             <b>Travel Class :</b> ${item.travelClass}<br>
             <b>Price : </b><fmt:formatNumber value="${item.price}" type="currency" /><br>
    </td>
    <td>
       <label id="select_flight_${item.id}">Select Flight ${item.id}</label>
      <input type="checkbox" name="departure_flight" value="${item.id}" id="select_flight_${item.id}"
      <%--  Check the first flight --%>
     <c:choose>
     <c:when test="${status.first == true}">
      checked="true"
     </c:when>
    </c:choose>
      />&nbsp;</td>
  </tr>
</c:forEach>
</table>
<hr noshade="true"><br>
<h1> Return - Available Flights</h1>
<br><br>
<table border="0">
 <c:forEach var="item" varStatus="status" begin="0" items="${return_result}">
  <tr>
    <td>
     <c:url var="imageURL" value="images/${item.imageURI}"/>
     <image src="${imageURL}" alt="${item.name} Image">
    </td>
  <td>
             <b>${item.carrier}</b> ${item.name}<br>
             <b>Departure Time :</b> ${item.departureTime}<br>
             <b>Arrival Time :</b> ${item.arrivalTime}<br>
             <b>Travel Class :</b> ${item.travelClass}<br>
             <b>Price : </b><fmt:formatNumber value="${item.price}" type="currency" /><br>
   </td>
  <td>
       <label id="select_return_flight_${item.id}">Select Flight ${item.id}</label>
      <input type="checkbox" name="return_flight" value="${item.id}" id="select_return_flight_${item.id}"
      <%--  Check the first flight --%>
     <c:choose>
     <c:when test="${status.first == true}">
      checked="true"
     </c:when>
    </c:choose>
   />&nbsp;</td>
  </tr>
</c:forEach>
 <tr>
  <td colspan="3">
    &nbsp;
  </td>
 </tr>
 <tr>
  <td colspan="3" align="right">
    <input type="SUBMIT" value="Purchase Selected Flights" name="Purchase Selected Flights">
    </form>
  </td>
  <td colspan="3" align="right">
    <form action="cart.do" method="POST">
     <input type="SUBMIT" value="Cancel Flight Purchase" name="cancelButton">
    </form>
  </td>
 </tr>
</table>
