<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

  <xsl:output method="html" indent="yes"/>

  <!-- template rule matching source root element -->
  <xsl:template match="/">
    <html> <head> 
    <title>Java AVK for the Enterprise Report Tool </title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <LINK href="./appVerification.css" rel="stylesheet" type="text/css"> 
    </LINK>
    </meta>
    </head>

    <xsl:apply-templates select="app-verification"/>
    </html>
  </xsl:template>

  <xsl:template match="app-verification">
     <body bgcolor="#FFFFFF" background="./Lt_BluePaperTexture.gif">
     <form method="post" action="">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
           <tr bgcolor="7171A5">
             <td width="100%"> 
                <div class="page-title-text" align="left">Java AVK for the Enterprise - Web Exception Detail </div>
             </td>
           </tr>
        </table>

        <xsl:apply-templates select="web-component"/>

     </form>
     </body>
  </xsl:template>



  <xsl:template match="web-component">

    <xsl:variable name="context" select="normalize-space(context)"/>
    <a Name="{$context}"> </a>
    <xsl:for-each select="web-entity">
    <xsl:if test="count(exception) !=0">

     <table border="0" cellspacing="0" cellpadding="0" width="100%">
      <tr height="1">
      <td class="line-row" colspan="2" alt="" width="1" height="1" border="0"/>
     </tr>
     <tr>
     <td width="35%" valign="top">
        <div class="table-title-text">Context Name: </div>
    </td>
    <td width="65%">
        <div class="table-normal-text"><xsl:value-of select="../context"/></div>
      </td>
     </tr>
    </table>

   <table border="0" cellspacing="0" cellpadding="1" width="100%">
    <tr> 
    <td> 

      <table class="back-table" border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr>
        <td>

    <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
    <xsl:for-each select="exception">
          <tr class="header-row">
            <td WIDTH="100%">
              <div class="table-header-text" align="left"/>
            </td>
          </tr>
          <tr height="1">
            <td class="line-row" colspan="1"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
         </tr>
          <tr>
            <td colspan="1" valign="top">
              <div class="table-bold-text" align="left">Exception Trace: </div>
            </td>
         </tr>
          <tr>
            <td width="100%" valign="bottom">
              <div class="table-normal-text" align="left"><xsl:value-of select=" exception-trace"/></div>
            </td>
          </tr>
          <tr>
            <td valign="top">
              <div class="table-bold-text">Exception Name: </div>
            </td>
          </tr>
          <tr>
            <td width="100%" valign="bottom">
              <div class="table-normal-text" align="left"><xsl:value-of select=" exception-name"/></div>
            </td>
          </tr>
   </xsl:for-each>
   </table>
   </td>
   </tr>
   </table>

   </td>
   </tr>
   </table>

  </xsl:if>

  </xsl:for-each>

  </xsl:template>

</xsl:stylesheet>