/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.DomText;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoSubGraph;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.JGoXMLSaveRestore;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public abstract class JGoObject
implements Serializable,
JGoXMLSaveRestore {
    public static final int NoSpot = -1;
    public static final int NoHandle = -1;
    public static final int Center = 0;
    public static final int TopLeft = 1;
    public static final int TopCenter = 2;
    public static final int TopMiddle = 2;
    public static final int Top = 2;
    public static final int TopRight = 3;
    public static final int RightCenter = 4;
    public static final int CenterRight = 4;
    public static final int SideRight = 4;
    public static final int Right = 4;
    public static final int BottomRight = 5;
    public static final int BottomCenter = 6;
    public static final int BottomMiddle = 6;
    public static final int Bottom = 6;
    public static final int BottomLeft = 7;
    public static final int LeftCenter = 8;
    public static final int CenterLeft = 8;
    public static final int SideLeft = 8;
    public static final int Left = 8;
    public static final int NumReservedHandles = 100;
    public static final int RepaintAll = 0;
    public static final int ChangedGeometry = 1;
    public static final int ChangedVisible = 2;
    public static final int ChangedSelectable = 3;
    public static final int ChangedDraggable = 4;
    public static final int ChangedResizable = 5;
    public static final int Changed4ResizeHandles = 6;
    public static final int ChangedGrabChildSelection = 9;
    public static final int ChangedZOrder = 10;
    public static final int ChangedPen = 11;
    public static final int ChangedBrush = 12;
    public static final int ChangedDragsNode = 13;
    public static final int ChangedUpdatePartner = 14;
    public static final int ChangedAutoRescale = 15;
    public static final int ChangedInitializing = 40;
    public static final int LastChangedHint = 65535;
    static final int flagVisible = 2;
    static final int flagSelectable = 4;
    static final int flagDraggable = 8;
    static final int flagResizable = 16;
    static final int flag4ResizeHandles = 32;
    static final int flagSuspendUpdates = 64;
    static final int flagSuspendChildUpdates = 128;
    static final int flagBoundingRectInvalid = 256;
    static final int flagGrabChildSelection = 512;
    static final int flagDragsNode = 1024;
    static final int flagSkipsUndoManager = 2048;
    static final int flagObject4 = 4096;
    static final int flagObject3 = 8192;
    static final int flagObject2 = 16384;
    static final int flagObject1 = 32768;
    static final int flagObject5 = 65536;
    static final int flagObject6 = 131072;
    static final int flagObject7 = 262144;
    static final int flagObject8 = 524288;
    static final int flagInitializing = 0x100000;
    static final int flagSkipsBoundingRectChanged = 0x200000;
    static final int flagAutoRescale = 0x400000;
    static final int flagUpdatePartner = 0x800000;
    private JGoArea myParentArea = null;
    private JGoLayer myLayer = null;
    private transient JGoView myView = null;
    private Rectangle myBoundingRect = new Rectangle(0, 0, 0, 0);
    private int myInternalFlags = 0;
    private int myExternalFlags = 0;

    public JGoObject() {
        this.init();
    }

    public JGoObject(Rectangle rect) {
        this.init();
        this.myBoundingRect.x = rect.x;
        this.myBoundingRect.y = rect.y;
        this.myBoundingRect.width = rect.width;
        this.myBoundingRect.height = rect.height;
    }

    public JGoObject(Point location, Dimension size) {
        this.init();
        this.myBoundingRect.x = location.x;
        this.myBoundingRect.y = location.y;
        this.myBoundingRect.width = size.width;
        this.myBoundingRect.height = size.height;
    }

    private final void init() {
        this.setInternalFlags(4195358);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoObject newobj = (JGoObject)env.get(this);
        if (newobj != null) {
            return null;
        }
        try {
            Class<?> thisclass = this.getClass();
            newobj = (JGoObject)thisclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (newobj != null) {
            env.put(this, newobj);
            newobj.myParentArea = null;
            newobj.myLayer = null;
            newobj.myView = null;
            newobj.myBoundingRect.x = this.myBoundingRect.x;
            newobj.myBoundingRect.y = this.myBoundingRect.y;
            newobj.myBoundingRect.width = this.myBoundingRect.width;
            newobj.myBoundingRect.height = this.myBoundingRect.height;
            newobj.myInternalFlags = this.myInternalFlags;
            newobj.myExternalFlags = this.myExternalFlags;
        }
        return newobj;
    }

    public void copyObjectDelayed(JGoCopyEnvironment env, JGoObject newobj) {
    }

    public Rectangle getBoundingRect() {
        if (this.isBoundingRectInvalid() && !this.isSkipsBoundingRectChanged()) {
            this.setBoundingRectInvalid(false);
            this.setSkipsBoundingRectChanged(true);
            Rectangle r = this.computeBoundingRect();
            if (r != null) {
                this.setBoundingRect(r);
            }
            this.setSkipsBoundingRectChanged(false);
        }
        return this.myBoundingRect;
    }

    public void setBoundingRect(int left, int top, int width, int height) {
        if (width >= 0 && height >= 0 && (this.myBoundingRect.x != left || this.myBoundingRect.y != top || this.myBoundingRect.width != width || this.myBoundingRect.height != height)) {
            JGoDocument doc;
            Rectangle prevRect = new Rectangle(this.myBoundingRect.x, this.myBoundingRect.y, this.myBoundingRect.width, this.myBoundingRect.height);
            this.myBoundingRect.x = left;
            this.myBoundingRect.y = top;
            this.myBoundingRect.width = width;
            this.myBoundingRect.height = height;
            this.update(1, 0, prevRect);
            if (!this.isSkipsBoundingRectChanged()) {
                this.setSkipsBoundingRectChanged(true);
                this.geometryChange(prevRect);
                if (this.isBoundingRectInvalid()) {
                    this.setBoundingRectInvalid(false);
                    Rectangle r = this.computeBoundingRect();
                    if (r != null) {
                        this.setBoundingRect(r);
                    }
                }
            }
            this.setSkipsBoundingRectChanged(false);
            JGoArea group = this.getParent();
            if (group != null && !group.isSkipsBoundingRectChanged()) {
                group.setSkipsBoundingRectChanged(true);
                group.geometryChangeChild(this, prevRect);
                if (group.isBoundingRectInvalid()) {
                    group.setBoundingRectInvalid(false);
                    Rectangle r = group.computeBoundingRect();
                    if (r != null) {
                        group.setBoundingRect(r);
                    }
                }
                group.setSkipsBoundingRectChanged(false);
            }
            if ((doc = this.getDocument()) != null) {
                doc.updateDocumentSize(this);
            }
        }
    }

    public final void setBoundingRect(Point loc, Dimension size) {
        this.setBoundingRect(loc.x, loc.y, size.width, size.height);
    }

    public final void setBoundingRect(Rectangle rect) {
        this.setBoundingRect(rect.x, rect.y, rect.width, rect.height);
    }

    protected final boolean setBoundingRectForce(int left, int top, int width, int height) {
        if (this.myBoundingRect.x == left && this.myBoundingRect.y == top && this.myBoundingRect.width == width && this.myBoundingRect.height == height) {
            return false;
        }
        this.setBoundingRect(left, top, width, height);
        return true;
    }

    public final boolean setBoundingRectForce(Rectangle rect) {
        return this.setBoundingRectForce(rect.x, rect.y, rect.width, rect.height);
    }

    protected Rectangle computeBoundingRect() {
        return this.myBoundingRect;
    }

    public final Dimension getSize() {
        return this.getSize(null);
    }

    public final Dimension getSize(Dimension result) {
        if (result == null) {
            result = new Dimension();
        }
        result.width = this.getWidth();
        result.height = this.getHeight();
        return result;
    }

    public final void setSize(Dimension size) {
        this.setBoundingRect(this.getLeft(), this.getTop(), size.width, size.height);
    }

    public final void setSize(int width, int height) {
        this.setBoundingRect(this.getLeft(), this.getTop(), width, height);
    }

    public final int getWidth() {
        return this.getBoundingRect().width;
    }

    public final void setWidth(int w) {
        this.setBoundingRect(this.getLeft(), this.getTop(), w, this.getHeight());
    }

    public final int getHeight() {
        return this.getBoundingRect().height;
    }

    public final void setHeight(int h) {
        this.setBoundingRect(this.getLeft(), this.getTop(), this.getWidth(), h);
    }

    public final int getLeft() {
        return this.getBoundingRect().x;
    }

    public final void setLeft(int l) {
        this.setBoundingRect(l, this.getTop(), this.getWidth(), this.getHeight());
    }

    public final int getTop() {
        return this.getBoundingRect().y;
    }

    public final void setTop(int t) {
        this.setBoundingRect(this.getLeft(), t, this.getWidth(), this.getHeight());
    }

    public final Point getTopLeft() {
        return this.getTopLeft(null);
    }

    public final Point getTopLeft(Point result) {
        if (result == null) {
            result = new Point(0, 0);
        }
        result.x = this.getLeft();
        result.y = this.getTop();
        return result;
    }

    public final void setTopLeft(Point p) {
        this.setBoundingRect(p.x, p.y, this.getWidth(), this.getHeight());
    }

    public final void setTopLeft(int x, int y) {
        this.setBoundingRect(x, y, this.getWidth(), this.getHeight());
    }

    public Point getLocation(Point result) {
        return this.getTopLeft(result);
    }

    public final Point getLocation() {
        return this.getLocation(null);
    }

    public void setLocation(int x, int y) {
        this.setTopLeft(x, y);
    }

    public final void setLocation(Point loc) {
        this.setLocation(loc.x, loc.y);
    }

    public void setSizeKeepingLocation(int width, int height) {
        this.setSize(width, height);
    }

    public final void setLocationOffset(int x, int y, int dx, int dy) {
        this.setLocation(x + dx, y + dy);
    }

    public final void setLocationOffset(Point location, Point offset) {
        this.setLocation(location.x + offset.x, location.y + offset.y);
    }

    public static int spotOpposite(int nSpot) {
        switch (nSpot) {
            default: {
                return nSpot;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: 
        }
        return 4;
    }

    public Point getRectangleSpotLocation(Rectangle r, int spot, Point result) {
        Point p = result;
        if (p == null) {
            p = new Point(r.x, r.y);
        } else {
            p.x = r.x;
            p.y = r.y;
        }
        switch (spot) {
            case 0: {
                p.x += r.width / 2;
                p.y += r.height / 2;
                break;
            }
            default: {
                break;
            }
            case 2: {
                p.x += r.width / 2;
                break;
            }
            case 3: {
                p.x += r.width;
                break;
            }
            case 4: {
                p.x += r.width;
                p.y += r.height / 2;
                break;
            }
            case 5: {
                p.x += r.width;
                p.y += r.height;
                break;
            }
            case 6: {
                p.x += r.width / 2;
                p.y += r.height;
                break;
            }
            case 7: {
                p.y += r.height;
                break;
            }
            case 8: {
                p.y += r.height / 2;
            }
        }
        return p;
    }

    public Rectangle setRectangleSpotLocation(Rectangle rect, int spot, int x, int y, Rectangle result) {
        Rectangle r = result;
        if (r == null) {
            r = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        } else {
            r.width = rect.width;
            r.height = rect.height;
        }
        switch (spot) {
            case 0: {
                r.x = x - r.width / 2;
                r.y = y - r.height / 2;
                break;
            }
            default: {
                r.x = x;
                r.y = y;
                break;
            }
            case 2: {
                r.x = x - r.width / 2;
                r.y = y;
                break;
            }
            case 3: {
                r.x = x - r.width;
                r.y = y;
                break;
            }
            case 4: {
                r.x = x - r.width;
                r.y = y - r.height / 2;
                break;
            }
            case 5: {
                r.x = x - r.width;
                r.y = y - r.height;
                break;
            }
            case 6: {
                r.x = x - r.width / 2;
                r.y = y - r.height;
                break;
            }
            case 7: {
                r.x = x;
                r.y = y - r.height;
                break;
            }
            case 8: {
                r.x = x;
                r.y = y - r.height / 2;
            }
        }
        return r;
    }

    public Point getSpotLocation(int nSpot, Point result) {
        Rectangle rect = this.getBoundingRect();
        return this.getRectangleSpotLocation(rect, nSpot, result);
    }

    public final Point getSpotLocation(int nSpot) {
        return this.getSpotLocation(nSpot, null);
    }

    public void setSpotLocation(int nSpot, int x, int y) {
        Rectangle rect = this.getBoundingRect();
        this.setBoundingRect(this.setRectangleSpotLocation(rect, nSpot, x, y, null));
    }

    public final void setSpotLocation(int nSpot, Point pnt) {
        this.setSpotLocation(nSpot, pnt.x, pnt.y);
    }

    public final void setSpotLocation(int nSpot, JGoObject obj, int otherSpot) {
        Point loc = obj.getSpotLocation(otherSpot);
        this.setSpotLocation(nSpot, loc.x, loc.y);
    }

    public final void setSpotLocationOffset(int nSpot, int x, int y, int dx, int dy) {
        this.setSpotLocation(nSpot, x + dx, y + dy);
    }

    public final void update() {
        this.update(0, 0, null);
    }

    public void update(int hint, int prevInt, Object prevVal) {
        JGoDocument doc;
        if (this.isSuspendUpdates()) {
            return;
        }
        if (this.isBoundingRectInvalid()) {
            this.getBoundingRect();
        }
        if ((doc = this.getDocument()) != null) {
            doc.fireUpdate(203, hint, this, prevInt, prevVal);
        } else {
            JGoView view = this.getView();
            if (view != null) {
                view.fireUpdate(3, hint, this);
                if (hint == 1) {
                    Rectangle repaintRect = view.getTempRectangle();
                    Rectangle b = (Rectangle)prevVal;
                    repaintRect.x = b.x;
                    repaintRect.y = b.y;
                    repaintRect.width = b.width;
                    repaintRect.height = b.height;
                    this.expandRectByPenWidth(repaintRect);
                    view.convertDocToView(repaintRect);
                    --repaintRect.x;
                    --repaintRect.y;
                    repaintRect.width += 2;
                    repaintRect.height += 2;
                    view.updateView(repaintRect);
                }
            }
        }
        if (this.isUpdatePartner()) {
            JGoObject partner = this.getPartner();
            if (partner == null) {
                partner = this.getParent();
            }
            if (partner != null) {
                partner.partnerUpdate(this, hint, prevInt, prevVal);
            }
        }
    }

    public void foredate(int hint) {
        if (this.isSuspendUpdates()) {
            return;
        }
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.fireForedate(203, hint, this);
        }
    }

    public void paint(Graphics2D g, JGoView view) {
        Rectangle rect = this.getBoundingRect();
        JGoDrawable.drawRect(g, JGoPen.black, null, rect.x, rect.y, rect.width, rect.height);
        JGoDrawable.drawLine(g, JGoPen.black, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
        JGoDrawable.drawLine(g, JGoPen.black, rect.x, rect.y + rect.height, rect.x + rect.width, rect.y);
    }

    public boolean isPointInObj(Point pnt) {
        return this.getBoundingRect().contains(pnt.x, pnt.y);
    }

    public void expandRectByPenWidth(Rectangle rect) {
    }

    public boolean getNearestIntersectionPoint(int px, int py, int cx, int cy, Point result) {
        Rectangle r = this.getBoundingRect();
        return JGoRectangle.getNearestIntersectionPoint(r.x, r.y, r.width, r.height, px, py, cx, cy, result);
    }

    public JGoObject pick(Point p, boolean selectableOnly) {
        if (!this.isVisible()) {
            return null;
        }
        if (!this.isPointInObj(p)) {
            return null;
        }
        if (!selectableOnly) {
            return this;
        }
        if (this.isSelectable()) {
            return this;
        }
        for (JGoArea obj = this.getParent(); obj != null; obj = obj.getParent()) {
            if (!obj.isSelectable()) continue;
            return obj;
        }
        return null;
    }

    public boolean doMouseClick(int modifiers, Point dc, Point vc, JGoView view) {
        return false;
    }

    public boolean doMouseDblClick(int modifiers, Point dc, Point vc, JGoView view) {
        return false;
    }

    public boolean doUncapturedMouseMove(int flags, Point dc, Point vc, JGoView view) {
        return false;
    }

    public String getToolTipText() {
        return null;
    }

    protected void ownerChange(JGoObjectCollection oldOwner, JGoObjectCollection newOwner, JGoObject mainObject) {
    }

    protected void gainedSelection(JGoSelection selection) {
        if (!this.isResizable()) {
            selection.createBoundingHandle(this);
            return;
        }
        Rectangle rect = this.getBoundingRect();
        int x1 = rect.x;
        int x2 = rect.x + rect.width / 2;
        int x3 = rect.x + rect.width;
        int y1 = rect.y;
        int y2 = rect.y + rect.height / 2;
        int y3 = rect.y + rect.height;
        selection.createResizeHandle(this, x1, y1, 1, true);
        selection.createResizeHandle(this, x3, y1, 3, true);
        selection.createResizeHandle(this, x1, y3, 7, true);
        selection.createResizeHandle(this, x3, y3, 5, true);
        if (!this.is4ResizeHandles()) {
            selection.createResizeHandle(this, x2, y1, 2, true);
            selection.createResizeHandle(this, x3, y2, 4, true);
            selection.createResizeHandle(this, x2, y3, 6, true);
            selection.createResizeHandle(this, x1, y2, 8, true);
        }
    }

    protected void lostSelection(JGoSelection selection) {
        selection.deleteHandles(this);
    }

    public JGoObject redirectSelection() {
        return this;
    }

    public JGoObject getDraggingObject() {
        if (this.isDragsNode()) {
            for (JGoArea obj = this.getParent(); obj != null; obj = obj.getParent()) {
                if (!obj.isDragsNode()) {
                    return obj;
                }
                if (obj.getParent() != null) continue;
                return obj;
            }
        }
        return this;
    }

    public void handleMove(JGoView view, int modifiers, int event, int spotNumber, int origX, int origY, int newX, int newY) {
        Point pnt = this.computeMove(origX, origY, newX, newY, null);
        this.setSpotLocation(spotNumber, pnt.x, pnt.y);
    }

    public Point computeMove(int origX, int origY, int newX, int newY, Point result) {
        if (result == null) {
            result = new Point(0, 0);
        }
        result.x = newX;
        result.y = newY;
        return result;
    }

    protected Rectangle handleResize(Graphics2D g, JGoView view, Rectangle origRect, Point newPoint, int whichHandle, int event, int minWidth, int minHeight) {
        Rectangle newRect = this.computeResize(origRect, newPoint, whichHandle, minWidth, minHeight);
        if (event == 3) {
            this.setBoundingRect(newRect);
        }
        return newRect;
    }

    protected Rectangle computeResize(Rectangle origRect, Point newPoint, int whichHandle, int minWidth, int minHeight) {
        Rectangle newRect = new Rectangle(origRect.x, origRect.y, origRect.width, origRect.height);
        switch (whichHandle) {
            case 1: {
                newRect.x = Math.min(newPoint.x, origRect.x + origRect.width - minWidth);
                newRect.y = Math.min(newPoint.y, origRect.y + origRect.height - minHeight);
                newRect.width += origRect.x - newRect.x;
                newRect.height += origRect.y - newRect.y;
                break;
            }
            case 2: {
                newRect.y = Math.min(newPoint.y, origRect.y + origRect.height - minHeight);
                newRect.height += origRect.y - newRect.y;
                break;
            }
            case 8: {
                newRect.x = Math.min(newPoint.x, origRect.x + origRect.width - minWidth);
                newRect.width += origRect.x - newRect.x;
                break;
            }
            case 3: {
                newRect.y = Math.min(newPoint.y, origRect.y + origRect.height - minHeight);
                newRect.width = Math.max(newPoint.x - origRect.x, minWidth);
                newRect.height += origRect.y - newRect.y;
                break;
            }
            case 7: {
                newRect.x = Math.min(newPoint.x, origRect.x + origRect.width - minWidth);
                newRect.width += origRect.x - newRect.x;
                newRect.height = Math.max(newPoint.y - origRect.y, minHeight);
                break;
            }
            case 4: {
                newRect.width = Math.max(newPoint.x - origRect.x, minWidth);
                break;
            }
            case 6: {
                newRect.height = Math.max(newPoint.y - origRect.y, minHeight);
                break;
            }
            case 5: {
                newRect.width = Math.max(newPoint.x - origRect.x, minWidth);
                newRect.height = Math.max(newPoint.y - origRect.y, minHeight);
            }
        }
        return newRect;
    }

    protected void geometryChange(Rectangle prevRect) {
    }

    protected boolean geometryChangeChild(JGoObject child, Rectangle prevRect) {
        return false;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoObj = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoObject", jGoElementGroup);
            jGoObj.setAttribute("obj_flags", Integer.toString(this.myInternalFlags));
            jGoObj.setAttribute("user_flags", Integer.toString(this.myExternalFlags));
            jGoObj.setAttribute("objx", Integer.toString(this.myBoundingRect.x));
            jGoObj.setAttribute("objy", Integer.toString(this.myBoundingRect.y));
            jGoObj.setAttribute("objwidth", Integer.toString(this.myBoundingRect.width));
            jGoObj.setAttribute("objheight", Integer.toString(this.myBoundingRect.height));
            svgDoc.registerObject(this, jGoObj);
        }
        if (svgDoc.SVGOutputEnabled() && this.getToolTipText() != null) {
            DomElement titleElement = svgDoc.createElement("title");
            titleElement.setAttribute("content", "structured text");
            jGoElementGroup.appendChild(titleElement);
            DomText tooltipTextElement = svgDoc.createText(this.getToolTipText());
            titleElement.appendChild(tooltipTextElement);
        }
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String user_flags;
            String obj_flags = jGoChildElement.getAttribute("obj_flags");
            if (obj_flags.length() > 0) {
                this.myInternalFlags = Integer.parseInt(obj_flags);
                if (this instanceof JGoArea && (this.myInternalFlags & 0x200) != 0) {
                    this.myInternalFlags &= 0xFFFFFDFF;
                    if ((this.myInternalFlags & 4) != 0) {
                        this.myInternalFlags |= 0x8000;
                    }
                    this.myInternalFlags |= 4;
                }
            }
            this.myExternalFlags = (user_flags = jGoChildElement.getAttribute("user_flags")).length() > 0 ? Integer.parseInt(user_flags) : this.myInternalFlags;
            String x = jGoChildElement.getAttribute("objx");
            String y = jGoChildElement.getAttribute("objy");
            String width = jGoChildElement.getAttribute("objwidth");
            String height = jGoChildElement.getAttribute("objheight");
            if (x.length() > 0 && y.length() > 0 && width.length() > 0 && height.length() > 0) {
                this.myBoundingRect.x = Integer.parseInt(x);
            }
            this.myBoundingRect.y = Integer.parseInt(y);
            this.myBoundingRect.width = Integer.parseInt(width);
            this.myBoundingRect.height = Integer.parseInt(height);
            String sID = jGoChildElement.getAttribute("id");
            if (sID.length() > 0) {
                svgDoc.registerTag(sID, this);
            }
        }
        return svgElement.getNextSibling();
    }

    public void SVGWriteAttributes(DomElement svgElement) {
    }

    public void SVGReadAttributes(DomElement svgElement) {
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
    }

    public JGoArea getParent() {
        return this.myParentArea;
    }

    protected void setParent(JGoArea parent) {
        this.myParentArea = parent;
    }

    public final boolean isTopLevel() {
        return this.getParent() == null;
    }

    public JGoObject getTopLevelObject() {
        JGoObject obj = this;
        while (!obj.isTopLevel()) {
            obj = obj.getParent();
        }
        return obj;
    }

    public JGoObject getParentNode() {
        JGoObject obj = this;
        while (obj.getParent() != null && !(obj.getParent() instanceof JGoSubGraph)) {
            obj = obj.getParent();
        }
        return obj;
    }

    public JGoNode getParentJGoNode() {
        JGoObject obj = this;
        while (obj.getParent() != null) {
            if (!((obj = obj.getParent()) instanceof JGoNode)) continue;
            return (JGoNode)obj;
        }
        return null;
    }

    public boolean isChildOf(JGoObject obj) {
        if (obj instanceof JGoArea) {
            for (JGoArea p = this.getParent(); p != null; p = p.getParent()) {
                if (p != obj) continue;
                return true;
            }
        }
        return false;
    }

    public static JGoObject findCommonParent(JGoObject a, JGoObject b) {
        if (a == b) {
            return a;
        }
        if (a == null) {
            return null;
        }
        if (a.getParent() == b) {
            return b;
        }
        if (b == null) {
            return null;
        }
        if (b.getParent() == a) {
            return a;
        }
        if (b.getParent() == null) {
            for (JGoObject p = a; p != null; p = p.getParent()) {
                if (p != b) continue;
                return b;
            }
        } else if (a.getParent() == null) {
            for (JGoObject q = b; q != null; q = q.getParent()) {
                if (q != a) continue;
                return a;
            }
        } else {
            for (JGoObject p = a; p != null; p = p.getParent()) {
                for (JGoObject q = b; q != null; q = q.getParent()) {
                    if (q != p) continue;
                    return q;
                }
            }
        }
        return null;
    }

    public JGoDocument getDocument() {
        if (this.myLayer == null) {
            return null;
        }
        return this.myLayer.getDocument();
    }

    public JGoLayer getLayer() {
        return this.myLayer;
    }

    void setLayer(JGoLayer layer, int mode, Object nextobj, JGoObject mainObject) {
        JGoDocument oldDoc = this.getDocument();
        if (layer != null) {
            this.myLayer = layer;
            JGoDocument newDoc = this.getDocument();
            if (oldDoc != newDoc) {
                this.ownerChange(oldDoc, newDoc, mainObject);
                if (mode >= 0) {
                    newDoc.fireUpdate(202, 0, this, mode, nextobj);
                }
            }
        } else {
            if (oldDoc != null) {
                this.ownerChange(oldDoc, null, mainObject);
                if (mode >= 0) {
                    oldDoc.fireUpdate(204, 0, this, mode, nextobj);
                }
            }
            this.myLayer = null;
        }
    }

    public JGoView getView() {
        return this.myView;
    }

    void setView(JGoView view, JGoObject mainObject) {
        JGoView oldView = this.myView;
        if (view != null) {
            this.myView = view;
            if (oldView != this.myView) {
                this.ownerChange(oldView, this.myView, mainObject);
                view.fireUpdate(2, 0, this);
            }
        } else {
            if (oldView != null) {
                this.ownerChange(oldView, null, mainObject);
                oldView.fireUpdate(4, 0, this);
            }
            this.myView = null;
        }
    }

    public void showSelectionHandles(JGoSelection selection) {
        this.lostSelection(selection);
        this.gainedSelection(selection);
    }

    public void hideSelectionHandles(JGoSelection selection) {
        this.lostSelection(selection);
    }

    public JGoObject getPartner() {
        return null;
    }

    public void setPartner(JGoObject obj) {
    }

    public void setUpdatePartner(boolean bFlag) {
        boolean oldUpdatePartner;
        boolean bl = oldUpdatePartner = (this.myInternalFlags & 0x800000) != 0;
        if (oldUpdatePartner != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x800000) : (this.myInternalFlags &= 0xFF7FFFFF);
            this.update(14, oldUpdatePartner ? 1 : 0, null);
        }
    }

    public boolean isUpdatePartner() {
        return (this.myInternalFlags & 0x800000) != 0;
    }

    protected void partnerUpdate(JGoObject partner, int hint, int prevInt, Object prevVal) {
    }

    void setCurrentListPosition(JGoListPosition pos) {
    }

    JGoListPosition getCurrentListPosition() {
        return null;
    }

    public void copyOldValueForUndo(JGoDocumentChangedEdit e) {
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 1: {
                Rectangle b = this.getBoundingRect();
                e.setNewValue(new Rectangle(b.x, b.y, b.width, b.height));
                return;
            }
            case 2: {
                e.setNewValueBoolean(this.isVisible());
                return;
            }
            case 3: {
                e.setNewValueBoolean(this.isSelectable());
                return;
            }
            case 4: {
                e.setNewValueBoolean(this.isDraggable());
                return;
            }
            case 5: {
                e.setNewValueBoolean(this.isResizable());
                return;
            }
            case 6: {
                e.setNewValueBoolean(this.is4ResizeHandles());
                return;
            }
            case 10: {
                JGoObjectCollection coll = this.getParent();
                if (coll == null) {
                    coll = this.getLayer();
                }
                if (coll != null) {
                    JGoListPosition pos = coll.findObject(this);
                    JGoListPosition nextobjpos = coll.getNextObjectPos(pos);
                    JGoObject nextobj = coll.getObjectAtPos(nextobjpos);
                    if (nextobj != null) {
                        e.setNewValueInt(1);
                        e.setNewValue(nextobj);
                    } else {
                        e.setNewValueInt(0);
                        e.setNewValue(coll);
                    }
                }
                return;
            }
            case 13: {
                e.setNewValueBoolean(this.isDragsNode());
                return;
            }
            case 14: {
                e.setNewValueBoolean(this.isUpdatePartner());
                return;
            }
            case 15: {
                e.setNewValueBoolean(this.isAutoRescale());
                return;
            }
            case 40: {
                e.setNewValueBoolean(this.isInitializing());
                return;
            }
            case 0: {
                return;
            }
        }
        throw new IllegalArgumentException("unknown CHANGED sub-hint: " + Integer.toString(e.getFlags()));
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 1: {
                Rectangle b = (Rectangle)e.getValue(undo);
                this.myBoundingRect.x = b.x;
                this.myBoundingRect.y = b.y;
                this.myBoundingRect.width = b.width;
                this.myBoundingRect.height = b.height;
                this.update();
                return;
            }
            case 2: {
                this.setVisible(e.getValueBoolean(undo));
                return;
            }
            case 3: {
                this.setSelectable(e.getValueBoolean(undo));
                return;
            }
            case 4: {
                this.setDraggable(e.getValueBoolean(undo));
                return;
            }
            case 5: {
                this.setResizable(e.getValueBoolean(undo));
                return;
            }
            case 6: {
                this.set4ResizeHandles(e.getValueBoolean(undo));
                return;
            }
            case 10: {
                int hasnext = e.getValueInt(undo);
                if (hasnext == 1) {
                    JGoObject nextobj = (JGoObject)e.getValue(undo);
                    if (nextobj != null) {
                        JGoObjectCollection coll = nextobj.getParent();
                        if (coll == null) {
                            coll = nextobj.getLayer();
                        }
                        if (coll != null) {
                            JGoListPosition nextpos = coll.findObject(nextobj);
                            if (nextpos == null) {
                                coll.addObjectAtTail(this);
                            } else {
                                coll.insertObjectBefore(nextpos, this);
                            }
                        }
                    }
                } else {
                    JGoObjectCollection coll = (JGoObjectCollection)e.getValue(undo);
                    coll.addObjectAtTail(this);
                }
                return;
            }
            case 13: {
                this.setDragsNode(e.getValueBoolean(undo));
                return;
            }
            case 14: {
                this.setUpdatePartner(e.getValueBoolean(undo));
                return;
            }
            case 15: {
                this.setAutoRescale(e.getValueBoolean(undo));
                return;
            }
            case 40: {
                this.setInitializing(e.getValueBoolean(undo));
                return;
            }
            case 0: {
                return;
            }
        }
        throw new IllegalArgumentException("unknown CHANGED sub-hint: " + Integer.toString(e.getFlags()));
    }

    public final void setFlags(int f) {
        this.myExternalFlags = f;
    }

    public final int getFlags() {
        return this.myExternalFlags;
    }

    final void setInternalFlags(int f) {
        this.myInternalFlags = f;
    }

    final int getInternalFlags() {
        return this.myInternalFlags;
    }

    public void setVisible(boolean bFlag) {
        boolean oldVisible;
        boolean bl = oldVisible = (this.myInternalFlags & 2) != 0;
        if (oldVisible != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 2) : (this.myInternalFlags &= 0xFFFFFFFD);
            this.update(2, oldVisible ? 1 : 0, null);
        }
    }

    public boolean isVisible() {
        return (this.myInternalFlags & 2) != 0;
    }

    public boolean canView() {
        for (JGoObject obj = this; obj != null; obj = obj.getParent()) {
            if (obj.isVisible()) continue;
            return false;
        }
        JGoLayer layer = this.getLayer();
        if (layer != null) {
            return layer.isVisible();
        }
        return true;
    }

    public void setSelectable(boolean bFlag) {
        boolean oldSelectable;
        boolean bl = oldSelectable = (this.myInternalFlags & 4) != 0;
        if (oldSelectable != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 4) : (this.myInternalFlags &= 0xFFFFFFFB);
            this.update(3, oldSelectable ? 1 : 0, null);
        }
    }

    public boolean isSelectable() {
        return (this.myInternalFlags & 4) != 0;
    }

    public void setDraggable(boolean bFlag) {
        boolean oldDraggable;
        boolean bl = oldDraggable = (this.myInternalFlags & 8) != 0;
        if (oldDraggable != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 8) : (this.myInternalFlags &= 0xFFFFFFF7);
            this.update(4, oldDraggable ? 1 : 0, null);
        }
    }

    public boolean isDraggable() {
        return (this.myInternalFlags & 8) != 0;
    }

    public void setResizable(boolean bFlag) {
        boolean oldResizable;
        boolean bl = oldResizable = (this.myInternalFlags & 0x10) != 0;
        if (oldResizable != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x10) : (this.myInternalFlags &= 0xFFFFFFEF);
            this.update(5, oldResizable ? 1 : 0, null);
        }
    }

    public boolean isResizable() {
        return (this.myInternalFlags & 0x10) != 0;
    }

    public void set4ResizeHandles(boolean bFlag) {
        boolean old4ResizeHandles;
        boolean bl = old4ResizeHandles = (this.myInternalFlags & 0x20) != 0;
        if (old4ResizeHandles != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x20) : (this.myInternalFlags &= 0xFFFFFFDF);
            this.update(6, old4ResizeHandles ? 1 : 0, null);
        }
    }

    public boolean is4ResizeHandles() {
        return (this.myInternalFlags & 0x20) != 0;
    }

    public void setAutoRescale(boolean bFlag) {
        boolean old;
        boolean bl = old = (this.myInternalFlags & 0x400000) != 0;
        if (old != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x400000) : (this.myInternalFlags &= 0xFFBFFFFF);
            this.update(15, old ? 1 : 0, null);
        }
    }

    public boolean isAutoRescale() {
        return (this.myInternalFlags & 0x400000) != 0;
    }

    public void setDragsNode(boolean bFlag) {
        boolean oldDraggable;
        boolean bl = oldDraggable = (this.myInternalFlags & 0x400) != 0;
        if (oldDraggable != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x400) : (this.myInternalFlags &= 0xFFFFFBFF);
            this.update(13, oldDraggable ? 1 : 0, null);
        }
    }

    public boolean isDragsNode() {
        return (this.myInternalFlags & 0x400) != 0;
    }

    public void setSuspendUpdates(boolean bFlag) {
        boolean oldSuspendUpdates;
        boolean bl = oldSuspendUpdates = (this.myInternalFlags & 0x40) != 0;
        if (oldSuspendUpdates != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x40) : (this.myInternalFlags &= 0xFFFFFFBF);
            this.update(0, 1, null);
        }
    }

    public boolean isSuspendUpdates() {
        return (this.myInternalFlags & 0x40) != 0;
    }

    public void setSkipsUndoManager(boolean bFlag) {
        boolean oldSkip;
        boolean bl = oldSkip = (this.myInternalFlags & 0x800) != 0;
        if (oldSkip != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x800) : (this.myInternalFlags &= 0xFFFFF7FF);
        }
    }

    public boolean isSkipsUndoManager() {
        return (this.myInternalFlags & 0x800) != 0;
    }

    public void setSuspendChildUpdates(boolean bFlag) {
        if ((this.myInternalFlags & 0x80) != 0 != bFlag) {
            this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x80) : (this.myInternalFlags &= 0xFFFFFF7F);
        }
    }

    public boolean isSuspendChildUpdates() {
        return (this.myInternalFlags & 0x80) != 0;
    }

    public void setGrabChildSelection(boolean grab) {
        if (this instanceof JGoArea) {
            if (grab) {
                ((JGoArea)this).setPickableBackground(this.isSelectable());
                this.setSelectable(true);
            } else if (this.isSelectable()) {
                ((JGoArea)this).setPickableBackground(true);
            }
        }
    }

    public boolean isGrabChildSelection() {
        return this.isSelectable();
    }

    protected void setBoundingRectInvalid(boolean bFlag) {
        this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x100) : (this.myInternalFlags &= 0xFFFFFEFF);
    }

    protected boolean isBoundingRectInvalid() {
        return (this.myInternalFlags & 0x100) != 0;
    }

    public void setInitializing(boolean bFlag) {
        this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x100000) : (this.myInternalFlags &= 0xFFEFFFFF);
    }

    public boolean isInitializing() {
        return (this.myInternalFlags & 0x100000) != 0;
    }

    void setSkipsBoundingRectChanged(boolean bFlag) {
        this.myInternalFlags = bFlag ? (this.myInternalFlags |= 0x200000) : (this.myInternalFlags &= 0xFFDFFFFF);
    }

    boolean isSkipsBoundingRectChanged() {
        return (this.myInternalFlags & 0x200000) != 0;
    }

    static void setBoundsRect(Rectangle r, Rectangle b) {
        r.x = b.x;
        r.y = b.y;
        r.width = b.width;
        r.height = b.height;
    }

    static Rectangle copyRect(Rectangle b) {
        return new Rectangle(b.x, b.y, b.width, b.height);
    }
}

