/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import java.io.Serializable;

class JGoObjList
implements Serializable {
    protected JGoListPosition myHead = null;
    protected JGoListPosition myTail = null;
    protected int myNumObjects = 0;
    protected boolean myOwner = false;

    public JGoObjList() {
    }

    public JGoObjList(boolean owner) {
        this.myOwner = owner;
    }

    public int getNumObjects() {
        return this.myNumObjects;
    }

    public boolean isEmpty() {
        return this.myHead == null;
    }

    public JGoListPosition addObjectAtHead(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        JGoListPosition temp = new JGoListPosition(obj, null, this.myHead);
        if (this.myHead != null) {
            this.myHead.prev = temp;
        }
        this.myHead = temp;
        if (this.myTail == null) {
            this.myTail = this.myHead;
        }
        ++this.myNumObjects;
        if (this.myOwner) {
            obj.setCurrentListPosition(this.myHead);
        }
        return this.myHead;
    }

    public JGoListPosition addObjectAtTail(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        JGoListPosition temp = new JGoListPosition(obj, this.myTail, null);
        if (this.myTail != null) {
            this.myTail.next = temp;
        }
        this.myTail = temp;
        if (this.myHead == null) {
            this.myHead = this.myTail;
        }
        ++this.myNumObjects;
        if (this.myOwner) {
            obj.setCurrentListPosition(this.myTail);
        }
        return this.myTail;
    }

    public JGoListPosition insertObjectBefore(JGoListPosition pos, JGoObject obj) {
        if (pos == null || obj == null) {
            return null;
        }
        JGoListPosition newNode = new JGoListPosition(obj, pos.prev, pos);
        if (pos.prev != null) {
            pos.prev.next = newNode;
        } else {
            this.myHead = newNode;
        }
        pos.prev = newNode;
        ++this.myNumObjects;
        if (this.myOwner) {
            obj.setCurrentListPosition(newNode);
        }
        return newNode;
    }

    public JGoListPosition insertObjectAfter(JGoListPosition pos, JGoObject obj) {
        if (pos == null || obj == null) {
            return null;
        }
        JGoListPosition newNode = new JGoListPosition(obj, pos, pos.next);
        if (pos.next != null) {
            pos.next.prev = newNode;
        } else {
            this.myTail = newNode;
        }
        pos.next = newNode;
        ++this.myNumObjects;
        if (this.myOwner) {
            obj.setCurrentListPosition(newNode);
        }
        return newNode;
    }

    public void removeObject(JGoObject obj) {
        JGoListPosition pos = this.findObject(obj);
        this.removeObjectAtPos(pos);
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        JGoObject obj = pos.obj;
        if (pos == this.myHead) {
            this.myHead = pos.next;
        }
        if (pos == this.myTail) {
            this.myTail = pos.prev;
        }
        if (pos.prev != null) {
            pos.prev.next = pos.next;
        }
        if (pos.next != null) {
            pos.next.prev = pos.prev;
        }
        pos.prev = null;
        pos.next = null;
        if (this.myOwner) {
            obj.setCurrentListPosition(null);
        }
        --this.myNumObjects;
        return obj;
    }

    public JGoListPosition getFirstObjectPos() {
        return this.myHead;
    }

    public JGoListPosition getLastObjectPos() {
        return this.myTail;
    }

    public JGoListPosition getNextObjectPos(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        return pos.next;
    }

    public JGoListPosition getPrevObjectPos(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        return pos.prev;
    }

    public JGoObject getObjectAtPos(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        return pos.obj;
    }

    public JGoListPosition findObject(JGoObject obj) {
        JGoListPosition pos = null;
        if (this.myOwner && (pos = obj.getCurrentListPosition()) != null) {
            return pos;
        }
        pos = this.myHead;
        while (pos != null) {
            if (pos.obj == obj) {
                return pos;
            }
            pos = pos.next;
        }
        return null;
    }
}

