/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.tests.jfluid.benchmarks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.tests.jfluid.CommonProfilerTestCase;
import org.netbeans.lib.profiler.tests.jfluid.utils.DumpStream;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilerAppHandler;
import org.netbeans.lib.profiler.tests.jfluid.utils.TestProfilingPointsProcessor;
import org.netbeans.lib.profiler.tests.jfluid.utils.Utils;

public abstract class JbbTestType
extends CommonProfilerTestCase {
    public JbbTestType(String name) {
        super(name);
    }

    protected int[] checkResults(File workdir) {
        try {
            File rawres = new File(workdir, "results/SPECjbbSingleJVM/SPECjbb.001.raw");
            this.log(rawres.getAbsolutePath() + " exists " + rawres.exists());
            BufferedInputStream inp = new BufferedInputStream(new FileInputStream(rawres));
            Properties props = new Properties();
            props.load(inp);
            inp.close();
            int[] ret = new int[]{(int)Double.parseDouble(props.getProperty("result.test1.company.score")), (int)Double.parseDouble(props.getProperty("result.test2.company.score"))};
            return ret;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void evalueateResults(int[] without, int[] with) {
        double[] diffs = new double[with.length];
        for (int i = 0; i < diffs.length; ++i) {
            diffs[i] = 100.0 * (double)(without[i] - with[i]) / (double)with[i];
        }
        int maxmult = 0;
        this.log("\n\nTests     Normal    Profiler  Diff%     Multiple");
        for (int i = 0; i < diffs.length; ++i) {
            this.log(this.complete("test " + String.valueOf(i + 1), 10) + this.complete(String.valueOf(without[i]), 10) + this.complete(String.valueOf(with[i]), 10) + this.complete(String.valueOf(diffs[i]), 6) + " %  " + this.complete(String.valueOf(without[i] / with[i]), 8));
            if (maxmult >= without[i] / with[i]) continue;
            maxmult = without[i] / with[i];
        }
        this.log("\nMax multiple: " + String.valueOf(maxmult) + " %\n");
        JbbTestType.assertTrue((String)("Difference multiple is greater than 5 - " + String.valueOf(maxmult)), (maxmult <= 5 ? 1 : 0) != 0);
    }

    protected ProfilerEngineSettings initCpuTest(String projectName, String mainClass) {
        ProfilerEngineSettings settings = this.initTest(projectName, mainClass, null);
        String xData = new File(this.getDataDir(), "/projects/" + projectName + "/config.properties").getAbsolutePath();
        this.addJVMArgs(settings, "-Xms256m -Xmx256m");
        settings.setMainArgs("-propfile " + xData);
        settings.setThreadCPUTimerOn(false);
        settings.setCPUProfilingType(0);
        Utils.copyFolder(new File(this.getDataDir(), "/projects/" + projectName + "/xml"), new File(settings.getWorkingDir(), "xml"));
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startBenchmarkTest(ProfilerEngineSettings settings, long checkDelay) {
        int i;
        this.log("without profiler");
        this.log("*******************************************************************************");
        ArrayList<String> command = new ArrayList<String>(20);
        command.add(settings.getTargetJVMExeFile());
        command.add("-cp");
        command.add(settings.getMainClassPath());
        String[] args = settings.getJVMArgs();
        for (i = 0; i < args.length; ++i) {
            command.add(args[i]);
        }
        command.add(settings.getMainClassName());
        args = settings.getMainArgs();
        for (i = 0; i < args.length; ++i) {
            command.add(args[i]);
        }
        try {
            Process p = Runtime.getRuntime().exec(command.toArray(new String[command.size()]), null, new File(settings.getWorkingDir()));
            new DumpStream(p, p.getErrorStream(), this.getLogStream(), "[App error] ").start();
            new DumpStream(p, p.getInputStream(), this.getLogStream(), "[App output] ").start();
            p.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        File workdir = new File(settings.getWorkingDir());
        int[] res1 = this.checkResults(workdir);
        TargetAppRunner runner = new TargetAppRunner(settings, (AppStatusHandler)new TestProfilerAppHandler(this), (ProfilingPointsProcessor)new TestProfilingPointsProcessor());
        try {
            Utils.removeFolder(new File(workdir, "results"));
            this.log("with profiler");
            this.log("*******************************************************************************");
            runner.addProfilingEventListener(Utils.createProfilingListener(this));
            runner.readSavedCalibrationData();
            runner.getProfilerClient().initiateRecursiveCPUProfInstrumentation(settings.getInstrumentationRootMethods());
            long time = System.currentTimeMillis();
            Process p = this.startTargetVM(runner);
            JbbTestType.assertNotNull((String)"Target JVM is not started", (Object)p);
            time = System.currentTimeMillis();
            runner.connectToStartedVMAndStartTA();
            this.waitForStatus(1);
            JbbTestType.assertTrue((String)"runner is not running", (boolean)runner.targetAppIsRunning());
            ArrayList metods = new ArrayList();
            while (!this.isStatus(4) && !this.isStatus(255)) {
                time = System.currentTimeMillis();
                Thread.sleep(checkDelay);
            }
            this.setStatus(8);
            this.log("finish ****************************** " + this.getStatus());
            int[] res2 = this.checkResults(workdir);
            this.evalueateResults(res1, res2);
            Utils.removeFolder(new File(workdir, "results"));
        }
        catch (Exception ex) {
            this.log(ex);
            JbbTestType.assertTrue((String)("Exception thrown: " + ex.getMessage()), (boolean)false);
        }
        finally {
            this.finalizeTest(runner);
        }
    }
}

