/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.w3c.dom.Attr;

public class DOMAttributePointer
extends NodePointer {
    private Attr attr;

    public DOMAttributePointer(NodePointer parent, Attr attr) {
        super(parent);
        this.attr = attr;
    }

    public QName getName() {
        return new QName(DOMNodePointer.getPrefix(this.attr), DOMNodePointer.getLocalName(this.attr));
    }

    public QName getExpandedName() {
        return new QName(this.getNamespaceURI(), DOMNodePointer.getLocalName(this.attr));
    }

    public String getNamespaceURI() {
        String prefix = DOMNodePointer.getPrefix(this.attr);
        if (prefix == null) {
            return null;
        }
        return this.parent.getNamespaceURI(prefix);
    }

    public Object getBaseValue() {
        return this.attr;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public Object getImmediateNode() {
        String value = this.attr.getValue();
        if (value == null) {
            return null;
        }
        if (value.equals("") && !this.attr.getSpecified()) {
            return null;
        }
        return value;
    }

    public boolean isActual() {
        return true;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean testNode(NodeTest nodeTest) {
        return nodeTest == null || nodeTest instanceof NodeTypeTest && ((NodeTypeTest)nodeTest).getNodeType() == 1;
    }

    public void setValue(Object value) {
        this.attr.setValue((String)TypeUtils.convert(value, String.class));
    }

    public void remove() {
        this.attr.getOwnerElement().removeAttributeNode(this.attr);
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
        }
        buffer.append('@');
        buffer.append(this.getName());
        return buffer.toString();
    }

    public int hashCode() {
        return System.identityHashCode(this.attr);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DOMAttributePointer)) {
            return false;
        }
        DOMAttributePointer other = (DOMAttributePointer)object;
        return this.attr == other.attr;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }
}

