/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.jxpath.JXPathBasicBeanInfo;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.MapDynamicPropertyHandler;

public class JXPathIntrospector {
    static Map byClassLoader = new WeakHashMap();
    private static PerClassLoader singleton;

    private static PerClassLoader getPerClassLoader(Class beanClass) {
        return singleton;
    }

    public static synchronized void registerAtomicClass(Class beanClass) {
        PerClassLoader perClassLoader = JXPathIntrospector.getPerClassLoader(beanClass);
        PerClassLoader.byClass.put(beanClass, new JXPathBasicBeanInfo(beanClass, true));
    }

    public static synchronized void registerDynamicClass(Class beanClass, Class dynamicPropertyHandlerClass) {
        JXPathBasicBeanInfo bi = new JXPathBasicBeanInfo(beanClass, dynamicPropertyHandlerClass);
        PerClassLoader perClassLoader = JXPathIntrospector.getPerClassLoader(beanClass);
        if (beanClass.isInterface()) {
            PerClassLoader.byInterface.put(beanClass, bi);
        } else {
            PerClassLoader.byClass.put(beanClass, bi);
        }
    }

    public static synchronized JXPathBeanInfo getBeanInfo(Class beanClass) {
        PerClassLoader perClassLoader = JXPathIntrospector.getPerClassLoader(beanClass);
        JXPathBeanInfo beanInfo = (JXPathBeanInfo)PerClassLoader.byClass.get(beanClass);
        if (beanInfo == null) {
            beanInfo = JXPathIntrospector.findDynamicBeanInfo(beanClass);
            if (beanInfo == null && (beanInfo = JXPathIntrospector.findInformant(beanClass)) == null) {
                beanInfo = new JXPathBasicBeanInfo(beanClass);
            }
            PerClassLoader.byClass.put(beanClass, beanInfo);
        }
        return beanInfo;
    }

    private static JXPathBeanInfo findDynamicBeanInfo(Class beanClass) {
        Class sup;
        Class<?>[] interfaces;
        JXPathBeanInfo beanInfo;
        PerClassLoader perClassLoader = JXPathIntrospector.getPerClassLoader(beanClass);
        if (beanClass.isInterface()) {
            beanInfo = (JXPathBeanInfo)PerClassLoader.byInterface.get(beanClass);
            if (beanInfo != null) {
                return beanInfo;
            }
        }
        if ((interfaces = beanClass.getInterfaces()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                beanInfo = JXPathIntrospector.findDynamicBeanInfo(interfaces[i]);
                if (beanInfo == null) continue;
                return beanInfo;
            }
        }
        if ((sup = beanClass.getSuperclass()) != null) {
            return JXPathIntrospector.findDynamicBeanInfo(sup);
        }
        return null;
    }

    private static synchronized JXPathBeanInfo findInformant(Class beanClass) {
        String name = beanClass.getName() + "XBeanInfo";
        try {
            return (JXPathBeanInfo)JXPathIntrospector.instantiate(beanClass, name);
        }
        catch (Exception ex) {
            try {
                if (JXPathBeanInfo.class.isAssignableFrom(beanClass)) {
                    return (JXPathBeanInfo)beanClass.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static Object instantiate(Class sibling, String className) throws Exception {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Class<?> cls = Class.forName(className);
        return cls.newInstance();
    }

    static {
        JXPathIntrospector.registerAtomicClass(Boolean.TYPE);
        JXPathIntrospector.registerAtomicClass(Boolean.class);
        JXPathIntrospector.registerAtomicClass(Byte.TYPE);
        JXPathIntrospector.registerAtomicClass(Byte.class);
        JXPathIntrospector.registerAtomicClass(Character.TYPE);
        JXPathIntrospector.registerAtomicClass(Character.class);
        JXPathIntrospector.registerAtomicClass(Short.TYPE);
        JXPathIntrospector.registerAtomicClass(Short.class);
        JXPathIntrospector.registerAtomicClass(Integer.TYPE);
        JXPathIntrospector.registerAtomicClass(Integer.class);
        JXPathIntrospector.registerAtomicClass(Long.TYPE);
        JXPathIntrospector.registerAtomicClass(Long.class);
        JXPathIntrospector.registerAtomicClass(Float.TYPE);
        JXPathIntrospector.registerAtomicClass(Float.class);
        JXPathIntrospector.registerAtomicClass(Double.TYPE);
        JXPathIntrospector.registerAtomicClass(Double.class);
        JXPathIntrospector.registerAtomicClass(String.class);
        JXPathIntrospector.registerAtomicClass(java.util.Date.class);
        JXPathIntrospector.registerAtomicClass(Date.class);
        JXPathIntrospector.registerAtomicClass(Time.class);
        JXPathIntrospector.registerAtomicClass(Timestamp.class);
        JXPathIntrospector.registerDynamicClass(Map.class, MapDynamicPropertyHandler.class);
        singleton = new PerClassLoader();
    }

    static class PerClassLoader {
        private static HashMap byClass = new HashMap();
        private static HashMap byInterface = new HashMap();

        PerClassLoader() {
        }
    }
}

