/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.Annotations;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineXmlCommand;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.tigris.subversion.svnclientadapter.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CmdLineAnnotations
extends Annotations {
    private CmdLineAnnotations() {
    }

    public static CmdLineAnnotations createFromXml(byte[] annotations, InputStream contents) throws CmdLineException {
        CmdLineAnnotations result = new CmdLineAnnotations();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            InputSource source = new InputSource(new ByteArrayInputStream(annotations));
            Document doc = factory.newDocumentBuilder().parse(source);
            NodeList nodes = doc.getElementsByTagName("entry");
            Annotations.Annotation[] lines = new Annotations.Annotation[nodes.getLength()];
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node entry = nodes.item(i);
                SVNRevision.Number revision = SVNRevision.Number.INVALID_REVISION;
                String author = null;
                Date date = null;
                int lineNr = Integer.parseInt(entry.getAttributes().getNamedItem("line-number").getNodeValue());
                Element commitNode = CmdLineXmlCommand.getFirstNamedElement(entry, "commit");
                if (commitNode != null) {
                    Element dateNode;
                    Node revisionAttribute = commitNode.getAttributes().getNamedItem("revision");
                    revision = Helper.toRevNum(revisionAttribute.getNodeValue());
                    Element authorNode = CmdLineXmlCommand.getFirstNamedElement(commitNode, "author");
                    if (authorNode != null) {
                        author = authorNode.getFirstChild().getNodeValue();
                    }
                    if ((dateNode = CmdLineXmlCommand.getNextNamedElement(authorNode, "date")) != null) {
                        date = Helper.convertXMLDate(dateNode.getFirstChild().getNodeValue());
                    }
                }
                lines[lineNr - 1] = new Annotations.Annotation(revision.getNumber(), author, date, null);
            }
            BufferedReader bReader = new BufferedReader(new InputStreamReader(contents));
            String line = bReader.readLine();
            int i = 0;
            while (line != null) {
                lines[i].setLine(line);
                result.addAnnotation(lines[i]);
                line = bReader.readLine();
                ++i;
            }
            bReader.close();
        }
        catch (Exception e) {
            throw new CmdLineException(e);
        }
        return result;
    }

    public static CmdLineAnnotations createFromStdOut(String annotations, String lineSeparator) {
        CmdLineAnnotations result = new CmdLineAnnotations();
        String[] lines = StringUtils.split(annotations, lineSeparator);
        for (int i = 0; i < lines.length; ++i) {
            Annotations.Annotation ann = new Annotations.Annotation(CmdLineAnnotations.getRevisionFrom(lines[i]), CmdLineAnnotations.getAuthorFrom(lines[i]), CmdLineAnnotations.getChangedFrom(lines[i]), CmdLineAnnotations.getLineFrom(lines[i]));
            result.addAnnotation(ann);
        }
        return result;
    }

    private static long getRevisionFrom(String line) {
        String version = line.substring(0, 6).trim();
        if (version.equals("-")) {
            return -1L;
        }
        return Integer.parseInt(version);
    }

    private static Date getChangedFrom(String line) {
        return null;
    }

    private static String getAuthorFrom(String line) {
        String author = StringUtils.stripStart(line.substring(7, 17), null);
        if (author.equals("-")) {
            return null;
        }
        return author;
    }

    private static String getLineFrom(String line) {
        return line.substring(18);
    }
}

