/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.UserInterface;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;
import org.xhtmlrenderer.swing.Java2DFontContext;
import org.xhtmlrenderer.swing.Java2DOutputDevice;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.Uu;
import org.xhtmlrenderer.util.XRLog;

public class RootPanel
extends JPanel
implements ComponentListener,
UserInterface {
    static final long serialVersionUID = 1L;
    protected Map documentListeners;
    protected SharedContext sharedContext;
    private volatile LayoutContext layout_context;
    private Box rootBox = null;
    private boolean pendingResize = false;
    protected JScrollPane enclosingScrollPane;
    private int default_scroll_mode = -1;
    protected Document doc = null;
    boolean layoutInProgress = false;
    public Element hovered_element = null;
    public Element active_element = null;
    public Element focus_element = null;

    public SharedContext getSharedContext() {
        return this.sharedContext;
    }

    public LayoutContext getLayoutContext() {
        return this.layout_context;
    }

    public void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this.fireDocumentStarted();
        this.resetScrollPosition();
        this.setRootBox(null);
        this.doc = doc;
        if (Configuration.isTrue("xr.cache.stylesheets", true)) {
            this.getSharedContext().getCss().flushStyleSheets();
        } else {
            this.getSharedContext().getCss().flushAllStyleSheets();
        }
        this.getSharedContext().reset();
        this.getSharedContext().setBaseURL(url);
        this.getSharedContext().setNamespaceHandler(nsh);
        this.getSharedContext().getCss().setDocumentContext(this.getSharedContext(), this.getSharedContext().getNamespaceHandler(), doc, this);
        this.repaint();
    }

    public void resetScrollPosition() {
        if (this.enclosingScrollPane != null) {
            this.enclosingScrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    protected void setEnclosingScrollPane(JScrollPane scrollPane) {
        if (this.enclosingScrollPane != null) {
            this.enclosingScrollPane.removeComponentListener(this);
        }
        this.enclosingScrollPane = scrollPane;
        if (this.enclosingScrollPane != null) {
            Uu.p("added root panel as a component listener to the scroll pane");
            this.enclosingScrollPane.addComponentListener(this);
            this.default_scroll_mode = this.enclosingScrollPane.getViewport().getScrollMode();
        }
    }

    public Rectangle getFixedRectangle() {
        if (this.enclosingScrollPane != null) {
            return this.enclosingScrollPane.getViewportBorderBounds();
        }
        Dimension dim = this.getSize();
        return new Rectangle(0, 0, dim.width, dim.height);
    }

    public void addNotify() {
        Container vp;
        super.addNotify();
        XRLog.general(Level.FINE, "add notify called");
        Container p = this.getParent();
        if (p instanceof JViewport && (vp = p.getParent()) instanceof JScrollPane) {
            this.setEnclosingScrollPane((JScrollPane)vp);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.setEnclosingScrollPane(null);
    }

    protected void init() {
        this.documentListeners = new HashMap();
        this.setBackground(Color.white);
        super.setLayout(null);
    }

    protected RenderingContext newRenderingContext(Graphics2D g) {
        XRLog.layout(Level.FINEST, "new context begin");
        this.getSharedContext().setCanvas(this);
        XRLog.layout(Level.FINEST, "new context end");
        RenderingContext result = this.getSharedContext().newRenderingContextInstance();
        result.setFontContext(new Java2DFontContext(g));
        result.setOutputDevice(new Java2DOutputDevice(g));
        this.getSharedContext().getTextRenderer().setup(result.getFontContext());
        return result;
    }

    protected LayoutContext newLayoutContext(Graphics2D g) {
        XRLog.layout(Level.FINEST, "new context begin");
        this.getSharedContext().setCanvas(this);
        XRLog.layout(Level.FINEST, "new context end");
        LayoutContext result = this.getSharedContext().newLayoutContextInstance();
        Graphics2D layoutGraphics = g.getDeviceConfiguration().createCompatibleImage(1, 1).createGraphics();
        result.setFontContext(new Java2DFontContext(layoutGraphics));
        this.getSharedContext().getTextRenderer().setup(result.getFontContext());
        return result;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        if (!c.isPrint()) {
            Rectangle extents = this.getScreenExtents();
            if (extents.width == 0 && extents.height == 0) {
                extents = new Rectangle(0, 0, 1, 1);
            }
            return extents;
        }
        PageBox first = Layer.createPageBox(c, "first");
        return new Rectangle(0, 0, first.getContentWidth(c), first.getContentHeight(c));
    }

    public Rectangle getScreenExtents() {
        Rectangle extents;
        if (this.enclosingScrollPane != null) {
            Rectangle bnds = this.enclosingScrollPane.getViewportBorderBounds();
            extents = new Rectangle(0, 0, bnds.width, bnds.height);
        } else {
            extents = new Rectangle(this.getWidth(), this.getHeight());
        }
        return extents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout(Graphics g) {
        try {
            this.removeAll();
            if (g == null) {
                return;
            }
            if (this.doc == null) {
                return;
            }
            LayoutContext c = this.newLayoutContext((Graphics2D)g);
            RootPanel rootPanel = this;
            synchronized (rootPanel) {
                this.layout_context = c;
            }
            long start = System.currentTimeMillis();
            BlockBox root = (BlockBox)this.getRootBox();
            if (root != null && this.isPendingResize()) {
                root.reset(c);
            } else {
                root = BoxBuilder.createRootBox(c, this.doc);
                this.setRootBox(root);
            }
            root.setContainingBlock(new ViewportBox(this.getInitialExtents(c)));
            root.layout(c);
            long end = System.currentTimeMillis();
            XRLog.layout(Level.INFO, "Layout took " + (end - start) + "ms");
            if (root.getLayer().containsFixedContent()) {
                super.setOpaque(false);
            } else {
                super.setOpaque(true);
            }
            XRLog.layout(Level.FINEST, "after layout: " + root);
            Dimension intrinsic_size = root.getLayer().getPaintingDimension(c);
            if (c.isPrint()) {
                root.getLayer().trimEmptyPages(c, intrinsic_size.height);
            }
            this.setPreferredSize(intrinsic_size);
            this.revalidate();
            if (this.enclosingScrollPane != null) {
                if (intrinsic_size.height < this.enclosingScrollPane.getViewport().getHeight()) {
                    if (this.enclosingScrollPane.getViewport().getHeight() != this.getHeight()) {
                        this.setPreferredSize(new Dimension(intrinsic_size.width, this.enclosingScrollPane.getViewport().getHeight()));
                        this.revalidate();
                    }
                    if (root != null && !c.isPrint()) {
                        intrinsic_size.height = root.getHeight();
                    }
                }
                if (root.getLayer().containsFixedContent()) {
                    this.enclosingScrollPane.getViewport().setScrollMode(0);
                } else {
                    this.enclosingScrollPane.getViewport().setScrollMode(this.default_scroll_mode);
                }
            }
            this.fireDocumentLoaded();
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            if (this.documentListeners.size() > 0) {
                this.fireOnLayoutException(t);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            XRLog.exception(t.getMessage(), t);
        }
    }

    protected void fireDocumentStarted() {
        Iterator it = this.documentListeners.keySet().iterator();
        while (it.hasNext()) {
            DocumentListener list = (DocumentListener)it.next();
            list.documentStarted();
        }
    }

    protected void fireDocumentLoaded() {
        Iterator it = this.documentListeners.keySet().iterator();
        while (it.hasNext()) {
            DocumentListener list = (DocumentListener)it.next();
            list.documentLoaded();
        }
    }

    protected void fireOnLayoutException(Throwable t) {
        Iterator it = this.documentListeners.keySet().iterator();
        while (it.hasNext()) {
            DocumentListener list = (DocumentListener)it.next();
            list.onLayoutException(t);
        }
    }

    protected void fireOnRenderException(Throwable t) {
        Iterator it = this.documentListeners.keySet().iterator();
        while (it.hasNext()) {
            DocumentListener list = (DocumentListener)it.next();
            list.onRenderException(t);
        }
    }

    public boolean isHover(Element e) {
        return e == this.hovered_element;
    }

    public boolean isActive(Element e) {
        return e == this.active_element;
    }

    public boolean isFocus(Element e) {
        return e == this.focus_element;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        Uu.p("componentResized() " + this.getSize());
        Uu.p("viewport = " + this.enclosingScrollPane.getViewport().getSize());
        if (!this.getSharedContext().isPrint()) {
            this.relayout(this.enclosingScrollPane.getViewport().getSize());
        }
    }

    protected void relayout(Dimension viewportSize) {
        if (this.doc != null) {
            this.setPendingResize(true);
            this.repaint();
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public double getLayoutWidth() {
        if (this.enclosingScrollPane != null) {
            return this.enclosingScrollPane.getViewportBorderBounds().width;
        }
        return this.getSize().width;
    }

    public boolean isPrintView() {
        return false;
    }

    public synchronized Box getRootBox() {
        return this.rootBox;
    }

    public synchronized void setRootBox(Box rootBox) {
        this.rootBox = rootBox;
    }

    public synchronized Layer getRootLayer() {
        return this.getRootBox() == null ? null : this.getRootBox().getLayer();
    }

    public Box find(MouseEvent e) {
        return this.find(e.getX(), e.getY());
    }

    public Box find(int x, int y) {
        Layer l = this.getRootLayer();
        if (l != null) {
            return l.find(this.layout_context, x, y);
        }
        return null;
    }

    protected synchronized boolean isPendingResize() {
        return this.pendingResize;
    }

    protected synchronized void setPendingResize(boolean pendingResize) {
        this.pendingResize = pendingResize;
    }
}

