/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class UnsignedIntegerType
extends BaseNumberDataType {
    static final long MIN_VALUE = 0L;
    static final long MAX_VALUE = 0xFFFFFFFFL;
    private static final long serialVersionUID = 236465010536902146L;

    public int getJdbcType() {
        return -5;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Long";
    }

    public int getPrecision() {
        return String.valueOf(0xFFFFFFFFL).length();
    }

    public int getColumnDisplaySize() {
        return String.valueOf(0xFFFFFFFFL).length();
    }

    public String toString() {
        return "unsignedinteger";
    }

    public boolean accepts(Object value) {
        if (value instanceof Number) {
            long s = ((Number)value).longValue();
            try {
                this.assertValidUnsignedInteger(s);
            }
            catch (AxionException e) {
                return false;
            }
            return true;
        }
        return super.accepts(value);
    }

    public Object convert(Object value) throws AxionException {
        if (value instanceof Number) {
            long s = ((Number)value).longValue();
            this.assertValidUnsignedInteger(s);
            return new Long(s);
        }
        if (value instanceof String) {
            try {
                Long lval = new Long(new BigDecimal(value.toString().trim()).longValue());
                this.assertValidUnsignedInteger(lval);
                return lval;
            }
            catch (NumberFormatException e) {
                throw new AxionException(22018);
            }
        }
        return super.convert(value);
    }

    public Object successor(Object value) throws IllegalArgumentException {
        long v = (Long)value;
        try {
            this.assertValidUnsignedInteger(v);
        }
        catch (AxionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (v == 0xFFFFFFFFL) {
            return value;
        }
        return new Long(++v);
    }

    public Object read(DataInput in) throws IOException {
        long value = this.toLong(in.readInt());
        if (0L == value && !in.readBoolean()) {
            return null;
        }
        return new Long(value);
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeInt(this.fromLong(0L));
            out.writeBoolean(false);
        } else {
            try {
                long val = (Long)this.convert(value);
                out.writeInt(this.fromLong(val));
                if (0L == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new UnsignedIntegerType();
    }

    public boolean isUnsigned() {
        return true;
    }

    private final long toLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    private final int fromLong(long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    private final void assertValidUnsignedInteger(long value) throws AxionException {
        if (value > 0xFFFFFFFFL || value < 0L) {
            throw new AxionException(22003);
        }
    }
}

