/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class ShortType
extends BaseNumberDataType {
    private static final long serialVersionUID = -8598189286242089718L;

    public int getJdbcType() {
        return 5;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Short";
    }

    public int getPrecision() {
        return String.valueOf(Short.MAX_VALUE).length();
    }

    public int getColumnDisplaySize() {
        return String.valueOf(Short.MIN_VALUE).length();
    }

    public String toString() {
        return "short";
    }

    public Object convert(Object value) throws AxionException {
        int rawValue = 0;
        if (value instanceof Short) {
            return value;
        }
        if (value instanceof BigDecimal) {
            rawValue = ((BigDecimal)value).intValue();
        } else if (value instanceof Number) {
            rawValue = ((Number)value).intValue();
        } else if (value instanceof String) {
            try {
                rawValue = new BigDecimal(value.toString().trim()).intValue();
            }
            catch (NumberFormatException e) {
                throw new AxionException(22018);
            }
        } else {
            return super.convert(value);
        }
        this.assertValueInRange(rawValue);
        return new Short((short)rawValue);
    }

    public Object successor(Object value) throws IllegalArgumentException {
        short v = (Short)value;
        if (v == Short.MAX_VALUE) {
            return value;
        }
        v = (short)(v + 1);
        return new Short(v);
    }

    public Object read(DataInput in) throws IOException {
        short value = in.readShort();
        if (Short.MIN_VALUE == value && !in.readBoolean()) {
            return null;
        }
        return new Short(value);
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeShort(Short.MIN_VALUE);
            out.writeBoolean(false);
        } else {
            try {
                short val = (Short)this.convert(value);
                out.writeShort(val);
                if (Short.MIN_VALUE == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new ShortType();
    }

    public int compare(Object a, Object b) {
        short pb;
        short pa = ((Number)a).shortValue();
        return pa < (pb = ((Number)b).shortValue()) ? -1 : (pa == pb ? 0 : 1);
    }

    protected Comparator getComparator() {
        return this;
    }

    private void assertValueInRange(int value) throws AxionException {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new AxionException(22003);
        }
    }
}

