/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.axiondb.DataType;
import org.axiondb.types.BaseDataType;

public class ObjectType
extends BaseDataType {
    private static final long serialVersionUID = -8691318615765776179L;

    public int getJdbcType() {
        return 2000;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Object";
    }

    public String toString() {
        return "Object";
    }

    public boolean accepts(Object value) {
        return value == null || value instanceof Serializable;
    }

    public Object convert(Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        if (value instanceof Serializable) {
            return value;
        }
        throw new IllegalArgumentException("The object must implement Serializable: " + value);
    }

    public int getColumnDisplaySize() {
        return 0;
    }

    public boolean supportsSuccessor() {
        return false;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Object read(DataInput in) throws IOException {
        try {
            ObjectInput objectInput = null;
            if (in instanceof ObjectInput) {
                objectInput = (ObjectInput)in;
            } else {
                int size = in.readInt();
                byte[] data = new byte[size];
                in.readFully(data);
                ByteArrayInputStream buffer = new ByteArrayInputStream(data);
                objectInput = new ObjectInputStream(buffer);
            }
            return objectInput.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFound: " + e.getMessage());
        }
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (out instanceof ObjectOutput) {
            ObjectOutput objectOutput = (ObjectOutput)out;
            objectOutput.writeObject(value);
        } else {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(buffer);
            objectOut.writeObject(value);
            objectOut.close();
            byte[] data = buffer.toByteArray();
            out.writeInt(data.length);
            out.write(data);
        }
    }

    public DataType makeNewInstance() {
        return new ObjectType();
    }
}

