/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class FloatType
extends BaseNumberDataType {
    private static final long serialVersionUID = -831981915887585231L;
    private static final int SIGN_MASK = Integer.MIN_VALUE;
    private static final int SIGN_NEGATIVE = Integer.MIN_VALUE;
    private static final int EXP_MANTISSA_MASK = Integer.MAX_VALUE;

    public int getJdbcType() {
        return 6;
    }

    public String getPreferredValueClassName() {
        return "java.lang.Float";
    }

    public int getPrecision() {
        return String.valueOf(Float.MAX_VALUE).length();
    }

    public int getScale() {
        return 0;
    }

    public int getColumnDisplaySize() {
        return String.valueOf(Float.MAX_VALUE).length();
    }

    public String toString() {
        return "float";
    }

    public Object convert(Object value) throws AxionException {
        double doubleValue = 0.0;
        if (value instanceof Float) {
            float floatValue = ((Float)value).floatValue();
            if (Float.isInfinite(floatValue) || Float.isNaN(floatValue)) {
                throw new AxionException(22003);
            }
            return value;
        }
        if (value instanceof Number) {
            doubleValue = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            try {
                doubleValue = new BigDecimal(value.toString().trim()).doubleValue();
            }
            catch (NumberFormatException e) {
                throw new AxionException(22018);
            }
        } else {
            return super.convert(value);
        }
        this.assertValueInRange(doubleValue);
        return new Float(doubleValue);
    }

    public Object read(DataInput in) throws IOException {
        float value = in.readFloat();
        if (Float.MIN_VALUE == value && !in.readBoolean()) {
            return null;
        }
        return new Float(value);
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        float v = ((Float)value).floatValue();
        if (v == Float.MAX_VALUE) {
            return value;
        }
        int ieee754Bits = Float.floatToIntBits(v);
        int sign = ieee754Bits & Integer.MIN_VALUE;
        boolean isNegative = Integer.MIN_VALUE == sign;
        int accumExpMantissa = ieee754Bits & Integer.MAX_VALUE;
        if (isNegative) {
            if (0L != (long)accumExpMantissa) {
                --accumExpMantissa;
            } else {
                sign = 0;
                accumExpMantissa = 0;
            }
        } else {
            accumExpMantissa = 0L != (long)accumExpMantissa ? ++accumExpMantissa : 1;
        }
        return new Float(Float.intBitsToFloat(sign | accumExpMantissa));
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeFloat(Float.MIN_VALUE);
            out.writeBoolean(false);
        } else {
            try {
                float val = ((Float)this.convert(value)).floatValue();
                out.writeFloat(val);
                if (Float.MIN_VALUE == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new FloatType();
    }

    public int compare(Object a, Object b) {
        float pb;
        float pa = ((Number)a).floatValue();
        return pa < (pb = ((Number)b).floatValue()) ? -1 : (pa == pb ? 0 : 1);
    }

    protected Comparator getComparator() {
        return this;
    }

    private void assertValueInRange(double doubleValue) throws AxionException {
        if (doubleValue > 3.4028234663852886E38 || doubleValue < -3.4028234663852886E38) {
            throw new AxionException(22003);
        }
    }
}

