/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseNumberDataType;

public class ByteType
extends BaseNumberDataType {
    private static final long serialVersionUID = -8198635981830444420L;

    public int getJdbcType() {
        return -6;
    }

    public int getColumnDisplaySize() {
        return String.valueOf(-128).length();
    }

    public String getPreferredValueClassName() {
        return "java.lang.Byte";
    }

    public int getPrecision() {
        return String.valueOf(127).length();
    }

    public String toString() {
        return "byte";
    }

    public Object convert(Object value) throws AxionException {
        short rawValue = 0;
        if (value instanceof Byte) {
            return value;
        }
        if (value instanceof Number) {
            rawValue = ((Number)value).shortValue();
        } else if (value instanceof String) {
            try {
                rawValue = new BigDecimal(value.toString().trim()).shortValue();
            }
            catch (NumberFormatException e) {
                throw new AxionException(22018);
            }
        } else {
            return super.convert(value);
        }
        this.assertValueInRange(rawValue);
        return new Byte((byte)rawValue);
    }

    public Object successor(Object value) throws IllegalArgumentException {
        byte v = (Byte)value;
        if (v == 127) {
            return value;
        }
        v = (byte)(v + 1);
        return new Byte(v);
    }

    public Object read(DataInput in) throws IOException {
        byte value = in.readByte();
        if (-128 == value && !in.readBoolean()) {
            return null;
        }
        return new Byte(value);
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeByte(-128);
            out.writeBoolean(false);
        } else {
            try {
                byte val = (Byte)this.convert(value);
                out.writeByte(val);
                if (-128 == val) {
                    out.writeBoolean(true);
                }
            }
            catch (AxionException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public DataType makeNewInstance() {
        return new ByteType();
    }

    public int compare(Object a, Object b) {
        byte pa = ((Number)a).byteValue();
        byte pb = ((Number)b).byteValue();
        return pa - pb;
    }

    protected Comparator getComparator() {
        return this;
    }

    private void assertValueInRange(short rawValue) throws AxionException {
        if (rawValue < -128 || rawValue > 127) {
            throw new AxionException(22003);
        }
    }
}

