/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.Selectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxionResultSetMetaData
implements ResultSetMetaData {
    private Selectable[] _sels = null;

    public AxionResultSetMetaData(Selectable[] selected) {
        this._sels = selected;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._sels.length;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getDataType(column).getPreferredValueClassName();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getDataType(column).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getSelectable(column).getLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getSelectable(column).getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getDataType(column).getJdbcType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getDataType(column).getClass().getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        DataType type = this.getDataType(column);
        if (type instanceof DataType.BinaryRepresentation) {
            // empty if block
        }
        return type.getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getDataType(column).getScale();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumnIndex(column);
        String val = null;
        Selectable sel = this.getSelectable(column);
        if (sel instanceof ColumnIdentifier) {
            val = ((ColumnIdentifier)sel).getTableName();
        }
        if (null == val) {
            return "";
        }
        return val;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getDataType(column).isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getDataType(column).isCurrency();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getDataType(column).getNullableCode();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getDataType(column).getSearchableCode() != 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return !this.getDataType(column).isUnsigned();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return !this.isWritable(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    private DataType getDataType(int column) throws SQLException {
        DataType type = this.getSelectable(column).getDataType();
        if (null != type) {
            return type;
        }
        throw new SQLException("Unable to determine the type of column " + column);
    }

    private Selectable getSelectable(int column) throws SQLException {
        this.checkColumnIndex(column);
        Selectable sel = this._sels[column - 1];
        if (null != sel) {
            return sel;
        }
        throw new SQLException("Unable to access column " + column);
    }

    private void checkColumnIndex(int column) throws SQLException {
        if (column - 1 < 0 || column - 1 >= this._sels.length) {
            throw new SQLException("Index " + column + " is out of bounds.");
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Operation not supported.");
    }
}

