/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;

public class HexFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final DataType STRING_TYPE = new StringType();

    public HexFunction() {
        super("HEX");
    }

    public ConcreteFunction makeNewInstance() {
        return new HexFunction();
    }

    public DataType getDataType() {
        return STRING_TYPE;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = this.getArgument(0).evaluate(row);
        String strval = (String)STRING_TYPE.convert(val);
        if (null == strval) {
            return null;
        }
        return this.toHex(strval.getBytes());
    }

    private String toHex(byte[] data) {
        int dataLen = data.length;
        char[] out = new char[dataLen << 1];
        int j = 0;
        for (int i = 0; i < dataLen; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return new String(out);
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

