/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.util.HashSet;
import java.util.Set;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.AggregateFunction;
import org.axiondb.functions.BaseFunction;

public abstract class BaseAggregateFunction
extends BaseFunction
implements AggregateFunction {
    private Set _distinctValues = null;
    private boolean _distinct = false;

    public BaseAggregateFunction(String name) {
        super(name);
    }

    public final Object evaluate(RowDecorator row) throws AxionException {
        return row.get(new ColumnIdentifier(this.getName()));
    }

    protected boolean acceptable(Object val) throws AxionException {
        if (!this._distinct) {
            return true;
        }
        if (this._distinctValues.contains(val)) {
            return false;
        }
        this._distinctValues.add(val);
        return true;
    }

    protected void setDistinct() throws AxionException {
        if (this.getArgumentCount() == 2) {
            boolean distinct;
            Selectable distinctStr = this.getArgument(1);
            this._distinct = distinct = ((String)distinctStr.evaluate(null)).equals("DISTINCT");
        }
        this._distinctValues = new HashSet();
    }

    protected void setDistinct(boolean distinct) throws AxionException {
        this._distinct = distinct;
    }

    protected boolean isDistinct() {
        return this._distinct;
    }

    public final boolean isValid() {
        return this.getArgumentCount() >= 1 && this.getArgumentCount() <= 2;
    }
}

