/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import java.math.BigDecimal;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.BigDecimalType;

public class ABSFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new BigDecimalType();
    private DataType _datatype = null;

    public ABSFunction() {
        super("ABS");
    }

    public ConcreteFunction makeNewInstance() {
        return new ABSFunction();
    }

    public DataType getDataType() {
        return this._datatype == null ? RETURN_TYPE : this._datatype;
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Selectable sel = this.getArgument(0);
        Object val = sel.evaluate(row);
        this._datatype = sel.getDataType();
        BigDecimal bdVal = this._datatype.toBigDecimal(val);
        if (null == bdVal) {
            return null;
        }
        return this._datatype.convert(bdVal.abs());
    }

    public boolean isValid() {
        return this.getArgumentCount() == 1;
    }
}

