/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rows;

import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowSource;
import org.axiondb.engine.rows.BaseRow;
import org.axiondb.util.ExceptionConverter;

public class LazyRow
extends BaseRow
implements Row {
    private Row _row;
    private RowSource _source;
    private int _knownColumnIndex = -1;
    private Object _knownValue;

    public LazyRow(RowSource source, int id) {
        this(source, id, -1, null);
    }

    public LazyRow(RowSource source, int id, int col, Object value) {
        super.setIdentifier(id);
        this._source = source;
        this._knownColumnIndex = col;
        this._knownValue = value;
    }

    public Object get(int i) {
        if (i == this._knownColumnIndex) {
            return this._knownValue;
        }
        Row row = this.getRow();
        return row != null ? row.get(i) : null;
    }

    public void set(int i, Object val) throws UnsupportedOperationException {
        this.getRow().set(i, val);
        this._hash = 0;
    }

    public int size() {
        return this._source.getColumnCount();
    }

    private Row getRow() {
        if (null == this._row) {
            try {
                this._row = this._source.getRow(this.getIdentifier());
            }
            catch (AxionException e) {
                throw ExceptionConverter.convertToRuntimeException(e);
            }
        }
        return this._row;
    }
}

