/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowIterator;

public class SingleRowIterator
implements RowIterator {
    private boolean _before = true;
    private boolean _currentSet = false;
    private Row _row = null;

    public SingleRowIterator(Row row) {
        this._row = row;
    }

    public void add(Row row) {
        throw new UnsupportedOperationException();
    }

    public Row current() {
        if (this._currentSet) {
            return this._row;
        }
        throw new NoSuchElementException();
    }

    public int currentIndex() {
        if (this._currentSet) {
            return 0;
        }
        return -1;
    }

    public Row first() {
        this._currentSet = true;
        this._before = true;
        return this._row;
    }

    public boolean hasCurrent() {
        return this._currentSet;
    }

    public boolean hasNext() {
        return this._before;
    }

    public boolean hasPrevious() {
        return !this._before;
    }

    public boolean isEmpty() {
        return false;
    }

    public Row last() {
        this._currentSet = true;
        this._before = false;
        return this._row;
    }

    public Row next() {
        if (this._before) {
            return this.last();
        }
        throw new NoSuchElementException();
    }

    public int next(int count) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public int nextIndex() {
        if (this._before) {
            return 0;
        }
        return 1;
    }

    public Row peekNext() {
        if (this._before) {
            return this._row;
        }
        throw new NoSuchElementException();
    }

    public Row peekPrevious() {
        if (!this._before) {
            return this._row;
        }
        throw new NoSuchElementException();
    }

    public Row previous() {
        if (!this._before) {
            return this.first();
        }
        throw new NoSuchElementException();
    }

    public int previous(int count) throws AxionException {
        throw new UnsupportedOperationException();
    }

    public int previousIndex() {
        if (this._before) {
            return -1;
        }
        return 0;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this._currentSet = false;
        this._before = true;
    }

    public void set(Row row) {
        throw new UnsupportedOperationException();
    }

    public int size() throws AxionException {
        return 1;
    }

    public String toString() {
        return "SingleRowIterator(" + this._row + ")";
    }
}

