/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import org.axiondb.AxionException;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.engine.rowiterators.FilteringRowIterator;
import org.axiondb.engine.rowiterators.MutableIndexedRowIterator;

public class FilteringChangingIndexedRowIterator
extends FilteringRowIterator
implements MutableIndexedRowIterator {
    private boolean _indexSet = false;
    private MutableIndexedRowIterator _iterator;

    public FilteringChangingIndexedRowIterator(MutableIndexedRowIterator iterator, RowDecorator decorator, Selectable where) {
        super(iterator, decorator, where);
        this._iterator = iterator;
    }

    public String getShortName() {
        return "FilteringChangingIndexed";
    }

    public boolean hasNext() {
        if (this.indexSet()) {
            return super.hasNext();
        }
        return false;
    }

    public boolean hasPrevious() {
        if (this.indexSet()) {
            return super.hasPrevious();
        }
        return false;
    }

    public boolean indexSet() {
        return this._indexSet;
    }

    public boolean isEmpty() {
        if (this._indexSet) {
            return super.isEmpty();
        }
        return false;
    }

    public void removeIndexKey() throws AxionException {
        this._indexSet = false;
        this._iterator.removeIndexKey();
        this.reset();
    }

    public void reset() throws AxionException {
        if (this._indexSet) {
            super.reset();
        }
    }

    public void setIndexKey(Object value) throws AxionException {
        this._indexSet = true;
        this._iterator.setIndexKey(value);
        this.reset();
    }
}

