/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.engine.rowiterators.FilteringRowIterator;
import org.axiondb.engine.rowiterators.JoinRowIterator;
import org.axiondb.engine.rowiterators.SingleRowIterator;
import org.axiondb.engine.rows.JoinedRow;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.util.ExceptionConverter;

public abstract class AbstractJoinedRowIterator
extends BaseRowIterator {
    private Row _current = null;
    private int _currentIndex = -1;
    private RowIterator _currentIterator = null;
    private boolean _currentSet = false;
    private Selectable _joinCondition = null;
    private RowIterator _left = null;
    private Row _next = null;
    private int _nextIndex = 0;
    private boolean _nextSet = false;
    private Row _previous = null;
    private boolean _previousSet = false;
    private int _rightColumnCount;
    private boolean _rightOuter = false;
    private RowDecorator _rowDecorator = null;
    private boolean _swapLeftAndRight = false;

    public Row current() throws NoSuchElementException {
        if (this._currentSet) {
            return this._current;
        }
        throw new NoSuchElementException();
    }

    public int currentIndex() throws NoSuchElementException {
        return this._currentIndex;
    }

    public boolean hasCurrent() {
        return this._currentSet;
    }

    public boolean hasNext() {
        if (this._nextSet) {
            return true;
        }
        try {
            return this.setNext();
        }
        catch (AxionException e) {
            throw ExceptionConverter.convertToRuntimeException(e);
        }
    }

    public boolean hasPrevious() {
        return this.nextIndex() > 0;
    }

    public Row next() throws NoSuchElementException, AxionException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._current = this._next;
        this._currentSet = true;
        this._currentIndex = this._nextIndex++;
        this.clearNext();
        return this._current;
    }

    public int nextIndex() {
        return this._nextIndex;
    }

    public Row previous() throws NoSuchElementException, AxionException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.setPrevious();
        this._current = this._previous;
        this._currentSet = true;
        this._currentIndex = this._nextIndex - 1;
        --this._nextIndex;
        this.clearPrevious();
        return this._current;
    }

    public int previousIndex() {
        return this._nextIndex - 1;
    }

    public void reset() throws AxionException {
        this._currentIterator = null;
        this._left.reset();
        this._nextIndex = 0;
        this._nextSet = false;
        this._previousSet = false;
        this._currentSet = false;
        this._currentIndex = -1;
        this._next = null;
        this._previous = null;
        this._current = null;
    }

    public void setJoinCondition(Selectable joinCondition, RowDecorator decorator) {
        this.setJoinCondition(joinCondition);
        this.setRowDecorator(decorator);
    }

    public String toString() {
        String joinType = this.isSwapLeftAndRight() ? "right" : "left";
        joinType = this.isRightOuter() ? joinType + "-outer" : "inner";
        String condition = this.getJoinCondition() != null ? this.getJoinCondition().toString() : "";
        return "type=" + joinType + ";condition=" + condition;
    }

    protected abstract RowIterator generateRightRowIterator() throws AxionException;

    protected Selectable getJoinCondition() {
        return this._joinCondition;
    }

    protected RowIterator getLeftRowIterator() {
        return this._left;
    }

    protected int getRightSideColumnCount() {
        return this._rightColumnCount;
    }

    protected RowDecorator getRowDecorator() {
        return this._rowDecorator;
    }

    protected boolean isRightOuter() {
        return this._rightOuter;
    }

    protected boolean isSwapLeftAndRight() {
        return this._swapLeftAndRight;
    }

    protected void setLeftRowIterator(RowIterator left) {
        this._left = left;
    }

    protected void setRightOuter(boolean b) {
        this._rightOuter = b;
    }

    protected void setRightSideColumnCount(int rightColumnCount) {
        this._rightColumnCount = rightColumnCount;
    }

    protected void setSwapLeftAndRight(boolean b) {
        this._swapLeftAndRight = b;
    }

    private void clearNext() {
        this._next = null;
        this._nextSet = false;
    }

    private void clearPrevious() {
        this._previous = null;
        this._previousSet = false;
    }

    private RowIterator generateCurrentRowIterator() throws AxionException {
        RowIterator iter = new JoinRowIterator(this._left.current(), this.generateRightRowIterator(), this.isSwapLeftAndRight());
        if (null != this.getJoinCondition()) {
            iter = new FilteringRowIterator(iter, this.getRowDecorator(), this.getJoinCondition());
        }
        if (iter.isEmpty() && this.isRightOuter()) {
            JoinedRow row = new JoinedRow();
            if (this.isSwapLeftAndRight()) {
                row.addRow(new SimpleRow(this.getRightSideColumnCount()));
                row.addRow(this._left.current());
            } else {
                row.addRow(this._left.current());
                row.addRow(new SimpleRow(this.getRightSideColumnCount()));
            }
            iter = new SingleRowIterator(row);
        }
        return iter;
    }

    private void setJoinCondition(Selectable joinCondition) {
        this._joinCondition = joinCondition;
    }

    private boolean setNext() throws AxionException {
        if (!this._left.hasCurrent()) {
            if (this._left.hasNext()) {
                this._left.next();
                this._currentIterator = this.generateCurrentRowIterator();
            } else {
                return false;
            }
        }
        if (this._left.currentIndex() == this._left.nextIndex()) {
            this._left.next();
        }
        while (true) {
            if (this._currentIterator.hasNext()) {
                this.setNext(this._currentIterator.next());
                break;
            }
            if (!this._left.hasNext()) {
                this.clearNext();
                break;
            }
            this._left.next();
            this._currentIterator = this.generateCurrentRowIterator();
        }
        return this._nextSet;
    }

    private void setNext(Row next) {
        this._next = next;
        this._nextSet = true;
    }

    private boolean setPrevious() throws AxionException {
        if (this._nextSet) {
            this.clearNext();
            this.setPrevious();
        }
        if (this._left.currentIndex() == this._left.previousIndex()) {
            this._left.previous();
        }
        while (true) {
            if (this._currentIterator.hasPrevious()) break;
            this._left.previous();
            this._currentIterator = this.generateCurrentRowIterator();
            if (this._currentIterator.isEmpty()) continue;
            this._currentIterator.last();
        }
        this.setPrevious(this._currentIterator.previous());
        return this._previousSet;
    }

    private void setPrevious(Row previous) {
        this._previous = previous;
        this._previousSet = true;
    }

    private void setRowDecorator(RowDecorator rowDecorator) {
        this._rowDecorator = rowDecorator;
    }
}

