/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.engine.commands.DropCommand;

public class DropDatabaseLinkCommand
extends DropCommand {
    public DropDatabaseLinkCommand(String serverName, boolean exists, boolean cascade) {
        this.setObjectName(serverName);
        this.setIfExists(exists);
        this.setCascade(cascade);
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (!this.isIfExists() || db.hasDatabaseLink(this.getObjectName())) {
            this.dropDependentTables(db);
            db.dropDatabaseLink(this.getObjectName());
        }
        return false;
    }

    private void dropDependentTables(Database db) throws AxionException {
        List tables = db.getDependentExternalDBTable(this.getObjectName());
        if (tables.size() > 0) {
            if (this.isCascade()) {
                db.dropDependentExternalDBTable(tables);
            } else {
                throw new AxionException("Can't drop Database Link, one or more tables has reference to " + this.getObjectName());
            }
        }
    }
}

