/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.ChildTableUpdater;
import org.axiondb.engine.commands.TruncateCommand;
import org.axiondb.engine.visitors.FindBindVariableVisitor;
import org.axiondb.jdbc.AxionResultSet;

public class DeleteCommand
extends ChildTableUpdater {
    private boolean _resolved = false;
    private TableIdentifier _tableId;
    private Selectable _where;
    private RowDecorator _dec;

    public DeleteCommand(String tableName, Selectable where) {
        this.setTable(new TableIdentifier(tableName));
        this.setWhere(where);
    }

    public DeleteCommand(TableIdentifier table, Selectable where) {
        this.setTable(table);
        this.setWhere(where);
    }

    public boolean execute(Database database) throws AxionException {
        this.executeUpdate(database);
        return false;
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use executeUpdate.");
    }

    public int executeUpdate(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        this.resolve(db);
        Table table = db.getTable(this.getTable());
        if (null == table) {
            throw new AxionException("Table " + this.getTable() + " not found.");
        }
        int deletecount = -1;
        if (this._where == null) {
            deletecount = this.tryToTruncate(db);
        }
        if (deletecount == -1) {
            deletecount = 0;
            if (this._dec == null) {
                this._dec = this.makeRowDecorator(table);
            }
            RowIterator rows = this.getRowIterator(db, this.getTable(), table, this.getWhere(), false, this._dec);
            this.setDeferAllConstraintIfRequired(table);
            while (rows.hasNext()) {
                Row row = rows.next();
                this._dec.setRow(row);
                this.deleteOrSetNullChildRows(db, table, this._dec);
                rows.remove();
                ++deletecount;
            }
        }
        this.setEffectedRowCount(deletecount);
        return deletecount;
    }

    private int tryToTruncate(Database db) {
        TruncateCommand tc = new TruncateCommand();
        tc.setObjectName(this._tableId.getTableName());
        try {
            return tc.executeUpdate(db);
        }
        catch (AxionException axionException) {
            return -1;
        }
    }

    public final TableIdentifier getTable() {
        return this._tableId;
    }

    public final Selectable getWhere() {
        return this._where;
    }

    protected void buildBindVariables() {
        this.setBindVariableVisitor(new FindBindVariableVisitor());
        this.getBindVariableVisitor().visit(this.getWhere());
    }

    protected void resolve(Database db) throws AxionException {
        if (!this._resolved) {
            TableIdentifier[] tables = new TableIdentifier[]{this.getTable()};
            this.setWhere(this.resolveSelectable(this.getWhere(), db, tables));
            this._resolved = true;
        }
    }

    private void setTable(TableIdentifier tableId) {
        this._tableId = tableId;
    }

    private void setWhere(Selectable where) {
        this._where = where;
    }
}

