/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.engine.commands.CreateCommand;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.engine.tables.TableView;
import org.axiondb.parser.AxionSqlParser;

public class CreateViewCommand
extends CreateCommand {
    private String _subQuery;

    public void setSubQuery(String query) {
        this._subQuery = query;
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (!db.hasTable(this.getObjectName())) {
            AxionSqlParser parser = new AxionSqlParser();
            SelectCommand selectCmd = (SelectCommand)parser.parse(this._subQuery);
            SubSelectCommand subSelectCmd = new SubSelectCommand(selectCmd.getQueryContext());
            TableView table = (TableView)subSelectCmd.getTableView(db, this.getObjectName());
            table.setSubQuery(this._subQuery);
            table.setType(TableView.VIEW);
            db.addTable(table);
        } else if (!this.isIfNotExists()) {
            throw new AxionException("A table/view named \"" + this.getObjectName() + "\" already exists.");
        }
        return false;
    }
}

