/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.adapters.ListIntList;
import org.axiondb.Column;
import org.axiondb.Index;
import org.axiondb.engine.indexes.BaseArrayIndex;
import org.axiondb.engine.indexes.BaseArrayIndexLoader;
import org.axiondb.engine.indexes.IntArrayIndex;

public class IntArrayIndexLoader
extends BaseArrayIndexLoader {
    protected Object readKeys(ObjectInputStream in) throws IOException {
        return this.readIntList(in);
    }

    protected Index makeIndex(String name, Column col, boolean unique, Object keys, IntList values) {
        return new IntArrayIndex(name, col, unique, (IntList)keys, values);
    }

    protected void writeKeys(ObjectOutputStream out, BaseArrayIndex index) throws IOException {
        IntList keylist = ListIntList.wrap((List)index.getKeyList());
        out.writeInt(keylist.size());
        int I = keylist.size();
        for (int i = 0; i < I; ++i) {
            out.writeInt(keylist.get(i));
        }
    }
}

