/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.axiondb.AxionException;
import org.axiondb.ExternalConnectionProvider;

public class DatabaseLink {
    private String _name = null;
    private String _driverClass = null;
    private String _jdbcUrl;
    private String _userName;
    private String _password;
    private String _catalogName;
    private String _schemaName;
    private Properties _connSpec;
    private ExternalConnectionProvider _connProvider;

    public DatabaseLink(String name, Properties spec) {
        this._name = name;
        this._connProvider = this.getExternalConnectionProvider();
        this._connSpec = spec;
        this._driverClass = spec.getProperty("DRIVER");
        this._jdbcUrl = spec.getProperty("URL");
        this._userName = spec.getProperty("USERNAME");
        this._password = spec.getProperty("PASSWORD");
        this._catalogName = spec.getProperty("CATALOG");
        this._schemaName = spec.getProperty("SCHEMA");
        if (this._connProvider == null && (this._driverClass == null || this._driverClass.trim().length() == 0 || this._jdbcUrl == null || this._jdbcUrl.trim().length() == 0 || this._userName == null || this._userName.trim().length() == 0 || this._password == null)) {
            throw new IllegalArgumentException("Missing required connection properties.");
        }
    }

    private ExternalConnectionProvider getExternalConnectionProvider() {
        Object connectionProvider = null;
        String externalConnectionProvider = System.getProperty("org.axiondb.external.connection.provider");
        if (externalConnectionProvider != null && !externalConnectionProvider.trim().equals("")) {
            try {
                connectionProvider = Thread.currentThread().getContextClassLoader().loadClass(externalConnectionProvider).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return connectionProvider;
    }

    public Connection getConnection() throws AxionException {
        Connection conn = null;
        try {
            if (this._connProvider == null) {
                Class.forName(this._driverClass);
                conn = DriverManager.getConnection(this._jdbcUrl, this._userName, this._password);
            } else {
                conn = this._connProvider.getConnection(this._connSpec);
            }
            conn.setAutoCommit(false);
        }
        catch (ClassNotFoundException e) {
            throw new AxionException("Could not locate class for driver: " + this._driverClass);
        }
        catch (SQLException e) {
            throw new AxionException("Could not connect to database for URL: " + this._jdbcUrl, e);
        }
        return conn;
    }

    public String getName() {
        return this._name;
    }

    public String getCatalogName() {
        return this._catalogName;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getJdbcUrl() {
        return this._jdbcUrl;
    }

    public String getUserName() {
        return this._userName;
    }

    public Properties getProperties() {
        return this._connSpec;
    }
}

