/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

public class Misc {
    public static byte[] str2bytes(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        byte[] b = new byte[len];
        while (len-- > 0) {
            b[len] = (byte)text.charAt(len);
        }
        return b;
    }

    public static String bytes2str(byte[] data, int offset, int length) {
        StringBuffer sb = new StringBuffer();
        while (length-- > 0) {
            sb.append((char)(data[offset++] & 0xFF));
        }
        return sb.toString();
    }

    public static String bytes2str(byte[] data) {
        if (data == null) {
            return null;
        }
        return Misc.bytes2str(data, 0, data.length);
    }

    public static char hex(int n) {
        return "0123456789abcdef".charAt(n & 0xF);
    }

    public static String printable(byte b) {
        switch (b) {
            case 92: {
                return "\\\\";
            }
            case 34: {
                return "\\\"";
            }
            case 8: {
                return "\\b";
            }
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
            case 9: {
                return "\\t";
            }
        }
        if (b < 32 || 126 < b || b == 92 || b == 34) {
            return "\\x" + Misc.hex(b >> 4) + Misc.hex(b >> 0);
        }
        return new String(new char[]{(char)b});
    }

    public static String printable(byte[] data) {
        if (data == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("\"");
        for (int i = 0; i < data.length; ++i) {
            sb.append(Misc.printable(data[i]));
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String printable(char b) {
        switch (b) {
            case '\\': {
                return "\\\\";
            }
            case '\"': {
                return "\\\"";
            }
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        if (b < ' ' || '~' < b || b == '\\' || b == '\"') {
            return "\\u" + Misc.hex(b >> 12) + Misc.hex(b >> 8) + Misc.hex(b >> 4) + Misc.hex(b >> 0);
        }
        return new String(new char[]{b});
    }

    public static String printable(String data) {
        if (data == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("\"");
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            sb.append(Misc.printable(data.charAt(i)));
        }
        sb.append('\"');
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String nonPrintable(String printableData) {
        if (printableData == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = printableData.length();
        int i = 0;
        while (true) {
            block17: {
                block18: {
                    if (i >= length) {
                        return sb.toString();
                    }
                    if (printableData.charAt(i) != '\\' || i + 1 >= length) break block18;
                    char c = printableData.charAt(i + 1);
                    switch (c) {
                        case '\\': {
                            sb.append('\\');
                            ++i;
                            break block17;
                        }
                        case 'b': {
                            sb.append('\b');
                            ++i;
                            break block17;
                        }
                        case 'f': {
                            sb.append('\f');
                            ++i;
                            break block17;
                        }
                        case 'n': {
                            sb.append('\n');
                            ++i;
                            break block17;
                        }
                        case 'r': {
                            sb.append('\r');
                            ++i;
                            break block17;
                        }
                        case 't': {
                            sb.append('\t');
                            ++i;
                            break block17;
                        }
                        case 'x': {
                            if (i + 3 >= length) break;
                            try {
                                int b = Integer.parseInt(printableData.substring(i + 2, i + 4), 16);
                                sb.append((char)b);
                                i += 3;
                                break block17;
                            }
                            catch (NumberFormatException e) {
                                break;
                            }
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': {
                            if (i + 3 >= length) break;
                            try {
                                int b = Integer.parseInt(printableData.substring(i + 1, i + 4), 8);
                                sb.append((char)b);
                                i += 3;
                                break block17;
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                sb.append(printableData.charAt(i));
            }
            ++i;
        }
    }

    public static byte[] byteslice(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException("no data");
        }
        if (offset < 0 || length < 0 || data.length < offset + length) {
            throw new IllegalArgumentException("offset=" + offset + ", length=" + length + " for " + data.length + " bytes data");
        }
        byte[] result = new byte[length];
        System.arraycopy(data, offset, result, 0, length);
        return result;
    }
}

