/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime;

import java.io.PrintStream;
import java.io.PrintWriter;

public class CoderException
extends RuntimeException {
    private final Throwable mCause;
    private final long mOffset;
    private String mMessage;

    public CoderException(String message) {
        this(message, null);
    }

    public CoderException(String message, Throwable cause) {
        this(-1L, message, cause);
    }

    public CoderException(long offset, String message) {
        this(offset, message, null);
    }

    public CoderException(long offset, String message, Throwable cause) {
        super((offset < 0L ? "" : "at byte " + offset + ": ") + message);
        this.mCause = cause;
        this.mOffset = offset;
        this.mMessage = message;
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.mCause != null) {
            stream.println("-- caused by --");
            this.mCause.printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        if (this.mCause != null) {
            writer.println("-- caused by --");
            this.mCause.printStackTrace(writer);
        }
    }

    public String getOriginalMessage() {
        return this.mMessage;
    }

    public boolean hasOffset() {
        return this.mOffset > -1L;
    }

    public long getOffset() {
        return this.mOffset;
    }
}

