/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.runtime;

import com.sun.encoder.coco.runtime.CobolCharacteristics;
import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CobolDataConverter {
    private static final int MAX_EXFLOAT_EXPONENT = 99;
    private static final byte LIT_BYTE = -1;
    private static final byte ZONE_NYBBLE_SIGN_BYTEMASK = -16;
    private static final byte ZONE_NYBBLE_VALUE_BYTEMASK = 15;
    private static final byte PACKED_NYBBLE_SIGN_BYTEMASK = 15;
    private static final byte POSITIVE_ZONE_SIGN = -64;
    private static final byte NEGATIVE_ZONE_SIGN = -48;
    private static final byte UNSIGNED_ZONE_SIGN = -16;
    private static final byte POSITIVE_PACK_SIGN = 12;
    private static final byte NEGATIVE_PACK_SIGN = 13;
    private static final byte UNSIGNED_PACK_SIGN = 15;
    private static final byte[] DBCSSPACE = new byte[]{64, 64};
    private static final char[] SPACE = new char[]{' '};
    private static final char[] PLUS = new char[]{'+'};
    private static final char[] MINUS = new char[]{'-'};
    private static final Map<String, byte[]> mSpaceEncodings = Collections.synchronizedMap(new HashMap());
    private static final Map<String, byte[]> mPlusEncodings = Collections.synchronizedMap(new HashMap());
    private static final Map<String, byte[]> mMinusEncodings = Collections.synchronizedMap(new HashMap());
    private static final ErrorManager cErrorMgr = ErrorManager.getManager("OpenESB.encoder.COBOLCopybook." + CobolDataConverter.class.getName());

    private CobolDataConverter() {
    }

    public static void encodeToDisplay(OutputStream outStream, String data, CobolCharacteristics specs, String enc) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outStream, enc);
        int size = specs.getSize();
        if (data.length() > size) {
            Message msg = MessageCatalog.getMessage("CCCR3002");
            cErrorMgr.log(ErrorManager.Severity.WARN, null, msg.formatText(new Object[]{data, String.valueOf(size)}));
            data = data.substring(0, size);
        }
        writer.write(data);
        writer.flush();
        int pad = size - data.length();
        for (int i = 0; i < pad; ++i) {
            writer.write(32);
        }
    }

    public static void encodeToExternalFloat(OutputStream outStream, BigDecimal data, String picture, CobolCharacteristics specs, String enc) throws IOException {
        boolean explicitSignificandSign;
        boolean haveExplicitDecimal;
        int snip;
        StringBuffer value = new StringBuffer(data.unscaledValue().toString());
        int scalePic = specs.getDecimalPosition();
        int scale = data.scale();
        int exponent = 0 - scale;
        int digitsPic = 0;
        int digits = value.length();
        OutputStreamWriter writer = new OutputStreamWriter(outStream, enc);
        digitsPic = 0;
        for (int i = 0; i < picture.length() && picture.charAt(i) != 'E'; ++i) {
            if (picture.charAt(i) != '9') continue;
            ++digitsPic;
        }
        if (data.signum() == -1) {
            value.delete(0, 1);
            --digits;
        }
        if (digitsPic < digits) {
            snip = digits - digitsPic;
            value.delete(digits - snip, digits);
            scale = Math.max(0, scale - snip);
            exponent += snip;
            digits = value.length();
        }
        if (digits < digitsPic) {
            snip = digitsPic - digits;
            for (int i = 0; i < snip; ++i) {
                value.append('0');
            }
            scale += scale > 0 ? snip : 0;
            exponent -= snip;
            digits = value.length();
        }
        exponent = scalePic + exponent;
        int dotLoc = picture.indexOf(46);
        boolean bl = haveExplicitDecimal = dotLoc != -1;
        if (haveExplicitDecimal) {
            value.insert(dotLoc - 1, '.');
        }
        if (Math.abs(exponent) > 99) {
            Message msg = MessageCatalog.getMessage("CCCR4009");
            String err = msg.formatText(new Object[]{String.valueOf(exponent)});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new ArithmeticException(err);
        }
        boolean negValue = data.signum() == -1;
        boolean needSignificandSign = !Character.isDigit(picture.charAt(0));
        boolean bl2 = explicitSignificandSign = needSignificandSign && picture.charAt(0) == '+';
        if (needSignificandSign) {
            if (negValue && new BigDecimal(value.toString()).unscaledValue().intValue() != 0) {
                writer.write(45);
            } else if (explicitSignificandSign) {
                writer.write(43);
            }
        }
        boolean explicitExponentSign = picture.charAt(picture.indexOf(69) + 1) == '+';
        writer.write(value.toString() + 'E');
        if (exponent < 0) {
            writer.write(45);
        } else if (explicitExponentSign) {
            writer.write(43);
        }
        exponent = Math.abs(exponent);
        if (exponent < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(exponent));
        writer.flush();
    }

    public static void encodeToFloat(OutputStream stream, float val) throws IOException {
        int value = Float.floatToIntBits(val);
        byte[] bytes = new byte[]{(byte)((value & 0xFF000000) >> 24), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF00) >> 8), (byte)(value & 0xFF)};
        stream.write(bytes, 0, bytes.length);
        stream.flush();
    }

    public static void encodeToDouble(OutputStream stream, double val) throws IOException {
        long value = Double.doubleToLongBits(val);
        byte[] bytes = new byte[]{(byte)((value & 0xFF00000000000000L) >> 56), (byte)((value & 0xFF000000000000L) >> 48), (byte)((value & 0xFF0000000000L) >> 40), (byte)((value & 0xFF00000000L) >> 32), (byte)((value & 0xFF000000L) >> 24), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF00L) >> 8), (byte)(value & 0xFFL)};
        stream.write(bytes, 0, bytes.length);
        stream.flush();
    }

    public static void encodeToZoned(OutputStream stream, BigDecimal data, String picture, CobolCharacteristics specs, String enc) throws IOException {
        StringBuffer value = new StringBuffer(data.unscaledValue().toString());
        boolean needSign = specs.isSigned();
        boolean separateSign = specs.isSignSeparate();
        boolean leadingSign = specs.isSignLeading();
        int scalePic = specs.getDecimalPosition();
        int scalingPositions = specs.getDecimalScalingPositions();
        int signByte = 0;
        int digitsPic = 0;
        int len = picture.length();
        for (int i = 0; i < len; ++i) {
            if (picture.charAt(i) != '9') continue;
            ++digitsPic;
        }
        int scale = data.scale();
        scale = CobolDataConverter.fitToNumericPicture(value, scale, digitsPic, scalePic, scalingPositions);
        if (data.signum() == -1) {
            value.delete(0, 1);
        }
        if (needSign) {
            if (separateSign) {
                if (leadingSign) {
                    switch (data.signum()) {
                        case -1: {
                            value.insert(0, '-');
                            break;
                        }
                        case 0: {
                            value.insert(0, '+');
                            break;
                        }
                        case 1: {
                            value.insert(0, '+');
                            break;
                        }
                    }
                } else {
                    switch (data.signum()) {
                        case -1: {
                            value.append('-');
                            break;
                        }
                        case 0: {
                            value.append('+');
                            break;
                        }
                        case 1: {
                            value.append('+');
                            break;
                        }
                    }
                }
            } else {
                if (leadingSign) {
                    signByte = (byte)Character.digit(value.charAt(0), 10);
                    value.delete(0, 1);
                } else {
                    int last = value.length() - 1;
                    signByte = (byte)Character.digit(value.charAt(last), 10);
                    value.delete(last, last + 1);
                }
                switch (data.signum()) {
                    case -1: {
                        signByte = (byte)(signByte | 0xFFFFFFD0);
                        break;
                    }
                    case 0: {
                        signByte = (byte)(signByte | 0xFFFFFFC0);
                        break;
                    }
                    case 1: {
                        signByte = (byte)(signByte | 0xFFFFFFC0);
                        break;
                    }
                }
            }
        }
        if (needSign && !separateSign && leadingSign) {
            stream.write(signByte);
            stream.flush();
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, enc);
        writer.write(value.toString());
        writer.flush();
        if (needSign && !separateSign && !leadingSign) {
            stream.write(signByte);
            stream.flush();
        }
    }

    public static void encodeToZoned(OutputStream stream, long data, String picture, CobolCharacteristics specs, String enc) throws IOException {
        BigDecimal decimal = new BigDecimal(Long.toString(data));
        decimal.movePointLeft(specs.getDecimalPosition());
        CobolDataConverter.encodeToZoned(stream, decimal, picture, specs, enc);
    }

    public static void encodeToZoned(OutputStream stream, int data, String picture, CobolCharacteristics specs, String enc) throws IOException {
        BigDecimal decimal = new BigDecimal(Integer.toString(data));
        decimal.movePointLeft(specs.getDecimalPosition());
        CobolDataConverter.encodeToZoned(stream, decimal, picture, specs, enc);
    }

    public static void encodeToDbcs(OutputStream stream, byte[] data, int size) throws IOException {
        int length = data.length;
        if (length % 2 != 0) {
            Message msg = MessageCatalog.getMessage("CCCR4010");
            String err = msg.formatText(new Object[]{String.valueOf(length)});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new IllegalArgumentException(err);
        }
        if (length > size) {
            Message msg = MessageCatalog.getMessage("CCCR3003");
            cErrorMgr.log(ErrorManager.Severity.WARN, null, msg.formatText(new Object[]{String.valueOf(length), String.valueOf(size)}));
            byte[] copy = new byte[size];
            System.arraycopy(data, 0, copy, 0, size);
            data = copy;
        }
        stream.write(data);
        int pad = (size - length) / DBCSSPACE.length;
        for (int i = 0; i < pad; ++i) {
            stream.write(DBCSSPACE, 0, DBCSSPACE.length);
        }
        stream.flush();
    }

    public static void encodeToBinary(OutputStream stream, BigDecimal data, String picture, CobolCharacteristics specs) throws IOException {
        StringBuffer svalue = new StringBuffer(data.unscaledValue().toString());
        int size = specs.getSize();
        boolean signed = specs.isSigned();
        int scalePic = specs.getDecimalPosition();
        int scalingPositions = specs.getDecimalScalingPositions();
        if (!signed && data.signum() == -1) {
            svalue.delete(0, 1);
        }
        int digitsPic = 0;
        int len = picture.length();
        for (int i = 0; i < len; ++i) {
            if (picture.charAt(i) != '9') continue;
            ++digitsPic;
        }
        CobolDataConverter.fitToNumericPicture(svalue, data.scale(), digitsPic, scalePic, scalingPositions);
        BigInteger value = new BigInteger(svalue.toString());
        byte[] valueBytes = value.toByteArray();
        int valueLen = valueBytes.length;
        if (size - valueLen > 0) {
            int padding = size - valueLen;
            byte[] newbytes = new byte[size];
            int pos = 0;
            int pad = signed && data.signum() == -1 ? -1 : 0;
            while (padding-- > 0) {
                newbytes[pos] = pad;
                ++pos;
            }
            for (int i = 0; i < valueLen; ++i) {
                newbytes[pos] = valueBytes[i];
                ++pos;
            }
            valueBytes = newbytes;
        }
        stream.write(valueBytes);
    }

    public static void encodeToNativeBinary(OutputStream stream, BigDecimal data, String picture, CobolCharacteristics specs) throws IOException {
        StringBuffer svalue = new StringBuffer(data.unscaledValue().toString());
        int size = specs.getSize();
        boolean signed = specs.isSigned();
        int scalePic = specs.getDecimalPosition();
        int scalingPositions = specs.getDecimalScalingPositions();
        if (!signed && data.signum() == -1) {
            svalue.delete(0, 1);
        }
        int digitsPic = 0;
        int len = picture.length();
        for (int i = 0; i < len; ++i) {
            if (picture.charAt(i) != '9') continue;
            ++digitsPic;
        }
        CobolDataConverter.fitToNumericNativePicture(svalue, data.scale(), digitsPic, scalePic, scalingPositions, size);
        BigInteger value = new BigInteger(svalue.toString());
        byte[] valueBytes = value.toByteArray();
        int valueLen = valueBytes.length;
        if (size - valueLen > 0) {
            int padding = size - valueLen;
            byte[] newbytes = new byte[size];
            int pos = 0;
            int pad = signed && value.signum() == -1 ? -1 : 0;
            while (padding-- > 0) {
                newbytes[pos] = pad;
                ++pos;
            }
            for (int i = 0; i < valueLen; ++i) {
                newbytes[pos] = valueBytes[i];
                ++pos;
            }
            valueBytes = newbytes;
        }
        stream.write(valueBytes);
    }

    public static void encodeToBinary(OutputStream stream, long data, String picture, CobolCharacteristics specs) throws IOException {
        BigDecimal decimal = new BigDecimal(Long.toString(data));
        decimal.movePointLeft(specs.getDecimalPosition());
        CobolDataConverter.encodeToBinary(stream, decimal, picture, specs);
    }

    public static void encodeToBinary(OutputStream stream, int data, String picture, CobolCharacteristics specs) throws IOException {
        BigDecimal decimal = new BigDecimal(Integer.toString(data));
        decimal.movePointLeft(specs.getDecimalPosition());
        CobolDataConverter.encodeToBinary(stream, decimal, picture, specs);
    }

    public static void encodeToPacked(OutputStream stream, BigDecimal data, String picture, CobolCharacteristics specs) throws IOException {
        StringBuffer value = new StringBuffer(data.unscaledValue().toString());
        boolean signed = specs.isSigned();
        int size = specs.getSize();
        int scalePic = specs.getDecimalPosition();
        int scalingPositions = specs.getDecimalScalingPositions();
        int digitsPic = 0;
        for (int i = 0; i < picture.length(); ++i) {
            if (picture.charAt(i) != '9') continue;
            ++digitsPic;
        }
        if (data.signum() == -1) {
            value.delete(0, 1);
        }
        int scale = data.scale();
        scale = CobolDataConverter.fitToNumericPicture(value, scale, digitsPic, scalePic, scalingPositions);
        int maxFitDigits = (size << 1) - 1;
        if (maxFitDigits < value.length()) {
            int truncsize;
            Message msg = MessageCatalog.getMessage("CCCR3004");
            String err = msg.formatText(new Object[]{data.toString(), String.valueOf((value.length() >> 1) + 1), String.valueOf(maxFitDigits)});
            cErrorMgr.log(ErrorManager.Severity.WARN, null, err);
            if (scale > 0) {
                truncsize = Math.max(0, scale - scalePic);
                value.delete(value.length() - truncsize, value.length());
                scale -= truncsize;
            }
            if (maxFitDigits < value.length()) {
                truncsize = Math.max(0, value.length() - scale - (digitsPic - scalePic));
                value.delete(0, truncsize);
            }
        }
        boolean needPad = value.length() % 2 == 0;
        int current = 0;
        if (needPad) {
            byte pad = 0;
            byte digit = (byte)Character.digit(value.charAt(current++), 10);
            byte b = (byte)(pad | digit);
            stream.write(b);
        }
        for (int i = current; i < value.length(); i += 2) {
            byte digit1 = (byte)Character.digit(value.charAt(i), 10);
            int digit2 = 0;
            if (i < value.length() - 1) {
                digit2 = (byte)Character.digit(value.charAt(i + 1), 10);
            } else if (!signed) {
                digit2 = 15;
            } else if (new BigInteger(value.toString()).equals(BigInteger.ZERO)) {
                digit2 = 12;
            } else {
                switch (data.signum()) {
                    case -1: {
                        digit2 = 13;
                        break;
                    }
                    case 0: {
                        digit2 = 12;
                        break;
                    }
                    case 1: {
                        digit2 = 12;
                        break;
                    }
                }
            }
            byte b = (byte)(digit1 << 4 | digit2);
            stream.write(b);
        }
    }

    public static void encodeToPacked(OutputStream stream, long data, String picture, CobolCharacteristics specs) throws IOException {
        BigDecimal decimal = new BigDecimal(Long.toString(data));
        decimal.movePointLeft(specs.getDecimalPosition());
        CobolDataConverter.encodeToPacked(stream, decimal, picture, specs);
    }

    public static void encodeToPacked(OutputStream stream, int data, String picture, CobolCharacteristics specs) throws IOException {
        BigDecimal decimal = new BigDecimal(Integer.toString(data));
        decimal.movePointLeft(specs.getDecimalPosition());
        CobolDataConverter.encodeToPacked(stream, decimal, picture, specs);
    }

    public static void encodeToIndex(OutputStream stream, int data, CobolCharacteristics specs) throws IOException {
        BigDecimal value = new BigDecimal(data);
        CobolDataConverter.encodeToNativeBinary(stream, value, "999999999", specs);
    }

    public static int decodeToInt(InputStream stream, String picture, CobolCharacteristics specs, String enc) throws IOException {
        int result;
        int category = specs.getPicCategory();
        int usage = specs.getUsage();
        if (4 == category) {
            switch (usage) {
                case 1: {
                    String value = CobolDataConverter.readNumberDisplay(stream, specs, enc);
                    result = Integer.parseInt(value);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    BigDecimal value = CobolDataConverter.readNumberBinary(stream, specs);
                    result = value.unscaledValue().intValue();
                    break;
                }
                case 11: {
                    BigDecimal value = CobolDataConverter.readNumberBinary(stream, specs);
                    result = value.unscaledValue().intValue();
                    break;
                }
                case 5: 
                case 6: {
                    BigDecimal value = CobolDataConverter.readNumberPacked(stream, specs);
                    result = value.unscaledValue().intValue();
                    break;
                }
                case 7: {
                    BigDecimal value = CobolDataConverter.readNumberBinary(stream, specs);
                    result = value.unscaledValue().intValue();
                    break;
                }
                default: {
                    Message msg = MessageCatalog.getMessage("CCCR4011");
                    String err = msg.toString();
                    cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
                    throw new IllegalArgumentException(err);
                }
            }
        } else {
            Message msg = MessageCatalog.getMessage("CCCR4013");
            String err = msg.formatText(new Object[]{CobolDataConverter.compressedPic(picture)});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new IllegalArgumentException(err);
        }
        return result;
    }

    public static long decodeTolong(InputStream stream, String picture, CobolCharacteristics specs, String enc) throws IOException {
        long result;
        int category = specs.getPicCategory();
        int usage = specs.getUsage();
        if (4 == category) {
            switch (usage) {
                case 1: {
                    String value = CobolDataConverter.readNumberDisplay(stream, specs, enc);
                    result = Long.parseLong(value);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    BigDecimal value = CobolDataConverter.readNumberBinary(stream, specs);
                    result = value.unscaledValue().longValue();
                    break;
                }
                case 5: 
                case 6: {
                    BigDecimal value = CobolDataConverter.readNumberPacked(stream, specs);
                    result = value.unscaledValue().longValue();
                    break;
                }
                case 7: {
                    BigDecimal value = CobolDataConverter.readNumberBinary(stream, specs);
                    result = value.unscaledValue().longValue();
                    break;
                }
                case 11: {
                    BigDecimal value = CobolDataConverter.readNumberBinary(stream, specs);
                    result = value.unscaledValue().longValue();
                    break;
                }
                default: {
                    Message msg = MessageCatalog.getMessage("CCCR4012");
                    String err = msg.toString();
                    cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
                    throw new IllegalArgumentException(err);
                }
            }
        } else {
            Message msg = MessageCatalog.getMessage("CCCR4013");
            String err = msg.formatText(new Object[]{CobolDataConverter.compressedPic(picture)});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new IllegalArgumentException(err);
        }
        return result;
    }

    public static float decodeToFloat(InputStream stream) throws IOException {
        int NEED = 4;
        byte[] bytebuf = new byte[4];
        int got = stream.read(bytebuf);
        if (got != 4) {
            Message msg = MessageCatalog.getMessage("CCCR4014");
            String err = msg.formatText(new Object[]{"COMP-1", String.valueOf(4), String.valueOf(Math.max(0, got))});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new IOException(err);
        }
        int intBits = bytebuf[0] << 24 & 0xFF000000;
        intBits |= bytebuf[1] << 16 & 0xFF0000;
        intBits |= bytebuf[2] << 8 & 0xFF00;
        return Float.intBitsToFloat(intBits |= bytebuf[3] & 0xFF);
    }

    public static double decodeToDouble(InputStream stream) throws IOException {
        int NEED = 8;
        byte[] bytebuf = new byte[8];
        int got = stream.read(bytebuf);
        if (got != 8) {
            Message msg = MessageCatalog.getMessage("CCCR4014");
            String err = msg.formatText(new Object[]{"COMP-2", String.valueOf(8), String.valueOf(Math.max(0, got))});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new IOException(err);
        }
        long longBits = (long)bytebuf[0] << 56 & 0xFF00000000000000L;
        longBits |= (long)bytebuf[1] << 48 & 0xFF000000000000L;
        longBits |= (long)bytebuf[2] << 40 & 0xFF0000000000L;
        longBits |= (long)bytebuf[3] << 32 & 0xFF00000000L;
        longBits |= (long)bytebuf[4] << 24 & 0xFF000000L;
        longBits |= (long)bytebuf[5] << 16 & 0xFF0000L;
        longBits |= (long)bytebuf[6] << 8 & 0xFF00L;
        return Double.longBitsToDouble(longBits |= (long)bytebuf[7] & 0xFFL);
    }

    public static byte[] decodeTobytes(InputStream stream, String picture, CobolCharacteristics specs) throws IOException {
        byte[] result = null;
        int category = specs.getPicCategory();
        if (6 != category) {
            Message msg = MessageCatalog.getMessage("CCCR4015");
            String err = msg.formatText(new Object[]{CobolDataConverter.compressedPic(picture)});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new IllegalArgumentException(err);
        }
        result = CobolDataConverter.readDBCS(stream, specs);
        return result;
    }

    public static String decodeToString(InputStream stream, String picture, CobolCharacteristics specs, String enc) throws IOException {
        String result = null;
        int category = specs.getPicCategory();
        switch (category) {
            case 1: {
                result = CobolDataConverter.readAlpha(stream, specs, enc);
                break;
            }
            case 2: {
                result = CobolDataConverter.readAlphanum(stream, specs, enc);
                break;
            }
            case 3: {
                result = CobolDataConverter.readAlphanumEdited(stream, specs, enc);
                break;
            }
            case 5: {
                result = CobolDataConverter.readNumEdited(stream, specs, enc);
                break;
            }
            case 6: {
                result = CobolDataConverter.readDBCS(stream, specs, enc);
                break;
            }
            default: {
                Message msg = MessageCatalog.getMessage("CCCR4016");
                String err = msg.formatText(new Object[]{CobolDataConverter.compressedPic(picture)});
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
                throw new IllegalArgumentException(err);
            }
        }
        return result;
    }

    public static BigDecimal decodeToBigDecimal(InputStream stream, String picture, CobolCharacteristics specs, String enc) throws IOException {
        BigDecimal result = null;
        int category = specs.getPicCategory();
        int usage = specs.getUsage();
        if (7 == category) {
            result = CobolDataConverter.readExFloat(stream, specs, enc);
        } else if (4 == category) {
            switch (usage) {
                case 1: {
                    result = new BigDecimal(CobolDataConverter.readNumberDisplay(stream, specs, enc));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    result = CobolDataConverter.readNumberBinary(stream, specs);
                    break;
                }
                case 5: 
                case 6: {
                    result = CobolDataConverter.readNumberPacked(stream, specs);
                    break;
                }
                case 7: {
                    result = CobolDataConverter.readNumberBinary(stream, specs);
                    break;
                }
                case 11: {
                    result = CobolDataConverter.readNumberBinary(stream, specs);
                    break;
                }
                default: {
                    Message msg = MessageCatalog.getMessage("CCCR4017");
                    String err = msg.formatText(new Object[]{CobolDataConverter.compressedPic(picture)});
                    cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
                    throw new IllegalArgumentException(err);
                }
            }
        } else {
            Message msg = MessageCatalog.getMessage("CCCR4018");
            String err = msg.formatText(new Object[]{CobolDataConverter.compressedPic(picture)});
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
            throw new IllegalArgumentException(err);
        }
        return result;
    }

    public static boolean isSameEncoding(String enc1, String enc2) {
        boolean same = false;
        if (enc1 != null && enc2 != null) {
            if (enc1.equalsIgnoreCase(enc2)) {
                same = true;
            } else {
                try {
                    Charset Lcs1 = Charset.forName(enc1);
                    Charset Lcs2 = Charset.forName(enc2);
                    same = Lcs1.equals(Lcs2);
                }
                catch (Exception e) {
                    same = false;
                }
            }
        }
        return same;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSpace(String enc) throws CharacterCodingException, UnsupportedEncodingException {
        byte[] LspaceBytes;
        Map<String, byte[]> map = mSpaceEncodings;
        synchronized (map) {
            LspaceBytes = mSpaceEncodings.get(enc);
        }
        if (LspaceBytes == null) {
            LspaceBytes = CobolDataConverter.charsToBytes(SPACE, enc);
            map = mSpaceEncodings;
            synchronized (map) {
                mSpaceEncodings.put(enc, LspaceBytes);
            }
        }
        return LspaceBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPlus(String enc) throws CharacterCodingException, UnsupportedEncodingException {
        byte[] LplusBytes;
        Map<String, byte[]> map = mPlusEncodings;
        synchronized (map) {
            LplusBytes = mPlusEncodings.get(enc);
        }
        if (LplusBytes == null) {
            LplusBytes = CobolDataConverter.charsToBytes(PLUS, enc);
            map = mPlusEncodings;
            synchronized (map) {
                mPlusEncodings.put(enc, LplusBytes);
            }
        }
        return LplusBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getMinus(String enc) throws CharacterCodingException, UnsupportedEncodingException {
        byte[] LminusBytes;
        Map<String, byte[]> map = mMinusEncodings;
        synchronized (map) {
            LminusBytes = mMinusEncodings.get(enc);
        }
        if (LminusBytes == null) {
            LminusBytes = CobolDataConverter.charsToBytes(MINUS, enc);
            map = mMinusEncodings;
            synchronized (map) {
                mMinusEncodings.put(enc, LminusBytes);
            }
        }
        return LminusBytes;
    }

    private static String readAlpha(InputStream stream, CobolCharacteristics spec, String enc) throws IOException {
        byte[] buf = new byte[spec.getSize()];
        int got = stream.read(buf, 0, buf.length);
        if (got == -1 || got != buf.length) {
            return null;
        }
        return new String(buf, enc);
    }

    private static String readAlphanum(InputStream stream, CobolCharacteristics spec, String enc) throws IOException {
        int want;
        byte[] buf = new byte[spec.getSize()];
        int got = stream.read(buf, 0, want = buf.length);
        if (got == -1 || got != want) {
            return null;
        }
        return new String(buf, enc);
    }

    private static String readAlphanumEdited(InputStream stream, CobolCharacteristics spec, String enc) throws IOException {
        int want;
        byte[] buf = new byte[spec.getSize()];
        int got = stream.read(buf, 0, want = buf.length);
        if (got == -1 || got != want) {
            return null;
        }
        return new String(buf, enc);
    }

    private static String readNumEdited(InputStream stream, CobolCharacteristics spec, String enc) throws IOException {
        int want;
        byte[] buf = new byte[spec.getSize()];
        int got = stream.read(buf, 0, want = buf.length);
        if (got == -1 || got != want) {
            return null;
        }
        return new String(buf, enc);
    }

    private static BigDecimal readExFloat(InputStream stream, CobolCharacteristics spec, String enc) throws IOException {
        int count;
        char[] data;
        InputStreamReader reader = CobolDataConverter.createReader(stream, enc);
        int got = reader.read(data = new char[count = spec.getSize()]);
        if (got != count) {
            return null;
        }
        BigDecimal value = null;
        if (CobolDataConverter.validateExFloat(data)) {
            value = new BigDecimal(new String(data));
        }
        return value;
    }

    private static boolean validateExFloat(char[] data) {
        int i;
        boolean haveSignificandSign;
        boolean haveExponentSign;
        StringBuffer buf = new StringBuffer(String.valueOf(data));
        int len = buf.length();
        if (len < 3) {
            return false;
        }
        int charindex = buf.indexOf("E");
        if (charindex == -1 || len == charindex + 1) {
            return false;
        }
        char signchar = buf.charAt(charindex + 1);
        boolean bl = haveExponentSign = signchar == '-' || signchar == '+';
        if (!haveExponentSign && !Character.isDigit(signchar)) {
            return false;
        }
        char startchar = buf.charAt(0);
        boolean bl2 = haveSignificandSign = startchar == '+' || startchar == '-';
        if (!haveSignificandSign && !Character.isDigit(startchar)) {
            return false;
        }
        if (haveExponentSign && charindex + 2 == len) {
            return false;
        }
        if (haveSignificandSign && charindex == 1) {
            return false;
        }
        for (i = 1; i < charindex; ++i) {
            if (Character.isDigit(buf.charAt(i))) continue;
            return false;
        }
        for (i = charindex + 2; i < len; ++i) {
            if (Character.isDigit(buf.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static byte[] readDBCS(InputStream stream, CobolCharacteristics spec) throws IOException {
        int need = spec.getSize();
        byte[] bytebuf = new byte[need];
        int got = stream.read(bytebuf);
        if (got != need) {
            return null;
        }
        return bytebuf;
    }

    private static String readDBCS(InputStream stream, CobolCharacteristics spec, String enc) throws IOException {
        byte[] buf = new byte[spec.getSize()];
        int got = stream.read(buf, 0, buf.length);
        if (got == -1 || got != buf.length) {
            return null;
        }
        return new String(buf, enc);
    }

    private static String readNumberDisplay(InputStream stream, CobolCharacteristics spec, String enc) throws IOException {
        String[] number;
        int countDigits = spec.getSize();
        long[] value = new long[1];
        boolean isSigned = spec.isSigned();
        int read = CobolDataConverter.readZonedNumber(stream, spec, value, isSigned, countDigits, number = new String[1], enc);
        if (read != countDigits) {
            return null;
        }
        int dec_pos = spec.getDecimalPosition();
        if (dec_pos > 0) {
            BigDecimal bd = new BigDecimal(BigInteger.valueOf(value[0]), dec_pos);
            return bd.toString();
        }
        return Long.toString(value[0]);
    }

    private static BigDecimal readNumberBinary(InputStream stream, CobolCharacteristics spec) throws IOException {
        int decPos = spec.getDecimalPosition();
        int scalingDigits = spec.getDecimalScalingPositions();
        int numBytes = spec.getSize();
        long[] value = new long[1];
        int got = 0;
        switch (numBytes) {
            case 2: {
                got = CobolDataConverter.readBinaryNumber(stream, value, 2);
                break;
            }
            case 4: {
                got = CobolDataConverter.readBinaryNumber(stream, value, 4);
                break;
            }
            case 8: {
                got = CobolDataConverter.readBinaryNumber(stream, value, 8);
                break;
            }
            default: {
                got = -1;
            }
        }
        if (got != numBytes) {
            return null;
        }
        BigDecimal decimal = new BigDecimal(Long.toString(value[0]));
        decimal = decimal.movePointLeft(decPos);
        decimal = decimal.movePointRight(decPos > 0 ? 0 : scalingDigits);
        return decimal;
    }

    private static BigDecimal readNumberPacked(InputStream stream, CobolCharacteristics spec) throws IOException {
        int decPos = spec.getDecimalPosition();
        int scalingDigits = spec.getDecimalScalingPositions();
        long[] value = new long[1];
        int numBytes = spec.getSize();
        int got = CobolDataConverter.readPackedNumber(stream, value, numBytes);
        if (got != numBytes) {
            return null;
        }
        BigDecimal decimal = new BigDecimal(Long.toString(value[0]));
        decimal = decimal.movePointLeft(decPos);
        decimal = decimal.movePointRight(decPos > 0 ? 0 : scalingDigits);
        return decimal;
    }

    private static int readZonedNumber(InputStream stream, CobolCharacteristics spec, long[] data, boolean signed, int count, String[] number, String enc) throws IOException {
        String svalue;
        boolean separateSign = spec.isSignSeparate();
        boolean leadingSign = spec.isSignLeading();
        byte[] plus = CobolDataConverter.getPlus(enc);
        byte[] minus = CobolDataConverter.getMinus(enc);
        byte[] buf = new byte[count];
        int got = 0;
        int sign = 0;
        got = stream.read(buf);
        if (got != count) {
            return -1;
        }
        if (separateSign) {
            byte[] signbytes = CobolDataConverter.getSeparateSign(leadingSign, buf, plus, minus);
            if (signbytes == null) {
                return got;
            }
            if (Arrays.equals(plus, signbytes)) {
                sign = 1;
                buf = CobolDataConverter.stripSign(leadingSign, buf, plus);
            } else if (Arrays.equals(minus, signbytes)) {
                sign = -1;
                buf = CobolDataConverter.stripSign(leadingSign, buf, minus);
            }
        } else if (signed) {
            byte signByte = leadingSign ? buf[0] : buf[got - 1];
            byte signBits = (byte)(signByte & 0xFFFFFFF0);
            byte valBits = (byte)(signByte & 0xF);
            byte value = valBits;
            if (value > 9) {
                return 0;
            }
            if (leadingSign) {
                buf[0] = (byte)(valBits | 0xFFFFFFF0);
            } else {
                buf[got - 1] = (byte)(valBits | 0xFFFFFFF0);
            }
            switch (signBits) {
                case -64: {
                    sign = 1;
                    break;
                }
                case -16: {
                    sign = 1;
                    break;
                }
                case -48: {
                    sign = -1;
                    break;
                }
                default: {
                    return 0;
                }
            }
        } else {
            sign = 1;
        }
        number[0] = svalue = new String(buf, enc);
        data[0] = Long.parseLong(svalue) * (long)sign;
        return got;
    }

    private static int readBinaryNumber(InputStream stream, long[] data, int count) throws IOException {
        byte[] bytes = new byte[count];
        int got = 0;
        got = stream.read(bytes);
        if (got != count) {
            return -1;
        }
        BigInteger value = new BigInteger(bytes);
        data[0] = value.longValue();
        return got;
    }

    private static int readPackedNumber(InputStream stream, long[] data, int count) throws IOException {
        byte[] bytes = new byte[count];
        int got = 0;
        got = stream.read(bytes);
        if (got != count) {
            Message msg = MessageCatalog.getMessage("CCCR4014");
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, msg.formatText(new Object[]{"COMP-3", String.valueOf(count), String.valueOf(Math.max(0, got))}));
            return -1;
        }
        byte signByte = (byte)(bytes[count - 1] & 0xF);
        --count;
        long value = 0L;
        for (int i = 0; i < count; ++i) {
            int digit = (bytes[i] & 0xF0) >> 4;
            if (digit < 0 || digit > 9) {
                Message msg = MessageCatalog.getMessage("CCCR4019");
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, msg.formatText(new Object[]{"COMP-3", String.valueOf((char)digit), String.valueOf(digit), String.valueOf(i), Integer.toHexString(bytes[i])}));
                return -1;
            }
            value += (long)digit;
            value *= 10L;
            digit = bytes[i] & 0xF;
            if (digit < 0 || digit > 9) {
                Message msg = MessageCatalog.getMessage("CCCR4020");
                cErrorMgr.log(ErrorManager.Severity.ERROR, null, msg.formatText(new Object[]{"COMP-3", String.valueOf((char)digit), String.valueOf(digit), String.valueOf(i), Integer.toHexString(bytes[i])}));
                return -1;
            }
            value += (long)digit;
            value *= 10L;
        }
        int digit = (bytes[count] & 0xF0) >> 4;
        if (digit < 0 || digit > 9) {
            Message msg = MessageCatalog.getMessage("CCCR4019");
            cErrorMgr.log(ErrorManager.Severity.ERROR, null, msg.formatText(new Object[]{"COMP-3", String.valueOf((char)digit), String.valueOf(digit), String.valueOf(count), Integer.toHexString(bytes[count])}));
            return -1;
        }
        value += (long)digit;
        if (signByte == 13) {
            value *= -1L;
        }
        data[0] = value;
        return got;
    }

    private static String compressedPic(String pic) {
        char symbol;
        StringBuffer buf = new StringBuffer(pic);
        char lastSymbol = buf.charAt(0);
        int occurs = 1;
        for (int i = 1; i < buf.length() && (symbol = buf.charAt(i)) != 'E'; ++i) {
            int lastpos = buf.length() - 1;
            if (lastSymbol == symbol) {
                ++occurs;
            }
            if (lastSymbol == symbol && i != lastpos) continue;
            if (occurs > 1) {
                int cutpos = i - occurs + 1 + (lastSymbol == symbol ? 1 : 0);
                buf.delete(cutpos, lastSymbol == symbol ? i + 1 : i);
                buf.insert(cutpos, ')');
                buf.insert(cutpos, occurs);
                buf.insert(cutpos, '(');
                occurs = 1;
                i = buf.indexOf(")", cutpos) + 1;
            }
            lastSymbol = symbol;
        }
        return buf.toString();
    }

    private static byte[] stripSign(boolean leadingSign, byte[] buf, byte[] sign) {
        byte[] newbuf = new byte[buf.length - sign.length];
        System.arraycopy(buf, leadingSign ? sign.length : 0, newbuf, 0, newbuf.length);
        return newbuf;
    }

    private static byte[] getSeparateSign(boolean leadingSign, byte[] buf, byte[] plus, byte[] minus) {
        int maxsignlen = Math.max(plus.length, minus.length);
        if (buf.length <= maxsignlen) {
            return null;
        }
        byte[] bbuf = new byte[maxsignlen];
        if (leadingSign) {
            System.arraycopy(buf, 0, bbuf, 0, maxsignlen);
        } else {
            int startOffset = Math.max(0, buf.length - maxsignlen - 1);
            int endOffset = Math.min(buf.length - startOffset, maxsignlen);
            System.arraycopy(buf, startOffset, bbuf, 0, endOffset);
        }
        if (Arrays.equals(plus, bbuf)) {
            return plus;
        }
        if (Arrays.equals(minus, bbuf)) {
            return minus;
        }
        return null;
    }

    private static byte[] charsToBytes(char[] chars, String enc) throws CharacterCodingException, UnsupportedEncodingException {
        byte[] Ldecoded;
        Charset Lcs;
        try {
            Lcs = Charset.forName(enc);
        }
        catch (Exception e) {
            Lcs = null;
        }
        if (Lcs != null) {
            ByteBuffer Lbb = Lcs.newEncoder().encode(CharBuffer.wrap(chars));
            ByteArrayOutputStream Lbs = new ByteArrayOutputStream(Lbb.limit() - Lbb.position());
            while (Lbb.hasRemaining()) {
                Lbs.write(Lbb.get());
            }
            Ldecoded = Lbs.toByteArray();
        } else {
            String Lchars = new String(chars);
            Ldecoded = Lchars.getBytes(enc);
        }
        return Ldecoded;
    }

    private static InputStreamReader createReader(InputStream stream, String enc) throws UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader(stream, enc);
        return reader;
    }

    private static int fitToNumericPicture(StringBuffer value, int scale, int digitsPic, int scalePic, int scalingPositions) {
        int i;
        boolean isNegativeValue = value.charAt(0) == '-';
        if (isNegativeValue) {
            value.delete(0, 1);
        }
        if (scalingPositions > 0) {
            if (scalePic > 0) {
                int truncsize = Math.max(0, value.length() - scale);
                value.delete(0, truncsize);
            } else {
                value.delete(value.length() - scale, value.length());
                scale = 0;
            }
            if (value.length() == 0) {
                value.append('0');
            }
            int addsize = Math.max(0, digitsPic + scalingPositions - value.length());
            if (scalePic > 0) {
                for (i = 0; i < addsize; ++i) {
                    value.append('0');
                }
                scale += addsize;
            } else {
                for (i = 0; i < addsize; ++i) {
                    value.insert(0, '0');
                }
            }
            int truncsize = Math.max(0, value.length() - (digitsPic + scalingPositions));
            if (scalePic > 0) {
                value.delete(value.length() - truncsize, value.length());
                scale -= truncsize;
            } else {
                value.delete(0, truncsize);
            }
            if (scalePic > 0) {
                value.delete(0, scalingPositions);
                scale -= scalingPositions;
            } else {
                value.delete(value.length() - scalingPositions, value.length());
            }
        }
        if (scalingPositions == 0) {
            int diff = digitsPic - scalePic - (value.length() - scale);
            if (diff < 1) {
                value.delete(0, Math.abs(diff));
            } else {
                for (i = 0; i < diff; ++i) {
                    value.insert(0, '0');
                }
            }
            diff = scalePic - scale;
            if (diff < 0) {
                value.delete(value.length() + diff, value.length());
                scale += diff;
            } else {
                scale += diff;
                for (i = 0; i < diff; ++i) {
                    value.append('0');
                }
            }
        }
        if (isNegativeValue) {
            value.insert(0, '-');
        }
        return scale;
    }

    private static int fitToNumericNativePicture(StringBuffer value, int scale, int digitsPic, int scalePic, int scalingPositions, int size) {
        BigInteger unscaledValue;
        byte[] unscaledBytes;
        int i;
        boolean isNegativeValue = value.charAt(0) == '-';
        if (isNegativeValue) {
            value.delete(0, 1);
        }
        if (scalingPositions > 0) {
            if (scalePic > 0) {
                int truncsize = Math.max(0, value.length() - scale);
                value.delete(0, truncsize);
            } else {
                value.delete(value.length() - scale, value.length());
                scale = 0;
            }
            if (value.length() == 0) {
                value.append('0');
            }
            int addsize = Math.max(0, digitsPic + scalingPositions - value.length());
            if (scalePic > 0) {
                for (i = 0; i < addsize; ++i) {
                    value.append('0');
                }
                scale += addsize;
            } else {
                for (i = 0; i < addsize; ++i) {
                    value.insert(0, '0');
                }
            }
            if (scalePic > 0) {
                value.delete(0, scalingPositions);
                scale -= scalingPositions;
            } else {
                value.delete(value.length() - scalingPositions, value.length());
            }
        }
        if (scalingPositions == 0) {
            int diff = digitsPic - scalePic - (value.length() - scale);
            if (diff < 1) {
                value.delete(0, Math.abs(diff));
            } else {
                for (i = 0; i < diff; ++i) {
                    value.insert(0, '0');
                }
            }
            diff = scalePic - scale;
            if (diff < 0) {
                value.delete(value.length() + diff, value.length());
                scale += diff;
            } else {
                scale += diff;
                for (i = 0; i < diff; ++i) {
                    value.append('0');
                }
            }
        }
        if (isNegativeValue) {
            value.insert(0, '-');
        }
        if ((unscaledBytes = (unscaledValue = new BigInteger(value.toString())).toByteArray()).length > size) {
            int diff = unscaledBytes.length - size;
            byte[] truncBytes = new byte[size];
            System.arraycopy(unscaledBytes, diff, truncBytes, 0, size);
            unscaledValue = new BigInteger(truncBytes);
            value.delete(0, value.length());
            value.append(unscaledValue.toString());
        }
        return scale;
    }
}

