/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.model;

import com.sun.encoder.coco.model.CobolSourceArea;
import com.sun.encoder.coco.model.CobolSourceAreaA;
import com.sun.encoder.coco.model.CobolSourceAreaB;
import com.sun.encoder.coco.model.CobolSourceIndicatorArea;
import com.sun.encoder.coco.model.CobolSourceSequenceArea;
import com.sun.encoder.coco.model.CocoDataModel;
import com.sun.encoder.coco.model.CocoDescriptionEntry;
import com.sun.encoder.coco.model.CocoLanguage;
import com.sun.encoder.coco.model.CocoLexer;
import com.sun.encoder.coco.model.CocoParseException;
import com.sun.encoder.coco.model.CocoPicture;
import com.sun.encoder.coco.model.CocoSign;
import com.sun.encoder.coco.model.CocoToken;
import com.sun.encoder.coco.model.ReservedWordEncounteredException;
import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class CocoParser {
    public static final int SOURCE_LINE_LENGTH = 82;
    private static Set cSourceAreas;
    private ArrayList mCols;
    private ArrayList mRows;
    private CocoLexer mLexer;
    private CocoDataModel mModel;
    private CocoDescriptionEntry mCurrentEntry;
    private CocoDescriptionEntry mLastEntry;
    private int mCol;
    private int mRow;
    private boolean mReservedWordCheck = true;
    private final ErrorManager mErrorMgr = ErrorManager.getManager("STC.eWay.converter.COBOLCopybook." + this.getClass().getName());

    public CocoParser(CocoLexer lexer) {
        this.mLexer = lexer;
        this.mModel = new CocoDataModel();
        this.mCol = 1;
        this.mRow = 1;
        this.mCols = new ArrayList();
        this.mRows = new ArrayList();
    }

    public CocoDataModel parse() throws CocoParseException, IOException {
        this.createModel();
        this.mModel.validate();
        this.mModel.resolveOccurs();
        return this.mModel;
    }

    public CocoDataModel parse(CocoDataModel model) throws CocoParseException, IOException {
        if (model != null) {
            this.mModel = model;
        }
        return this.parse();
    }

    public void disableItemNameReservedWordChecking(boolean disable) {
        this.mReservedWordCheck = !disable;
    }

    protected void createModel() throws CocoParseException, IOException {
        this.processEntries();
    }

    private void processEntries() throws CocoParseException, IOException {
        CocoDescriptionEntry entry = null;
        do {
            if ((entry = this.getEntry()) == null || entry.getLevel() == -1) continue;
            this.mLastEntry = entry;
            if (entry.getLevel() == 88) continue;
            try {
                this.mModel.addEntry(entry);
            }
            catch (IllegalArgumentException iae) {
                this.logAndThrow("CCCB4201", new Object[]{iae.getLocalizedMessage()}, ErrorManager.Severity.ERROR, iae, null);
            }
        } while (entry != null);
    }

    private CocoDescriptionEntry getEntry() throws CocoParseException, IOException {
        CocoDescriptionEntry entry = null;
        if (this.skipSequenceArea()) {
            this.mCurrentEntry = new CocoDescriptionEntry();
            entry = this.mCurrentEntry;
            if (this.parseIndicatorArea(entry)) {
                this.consumeEOL();
            } else {
                boolean eol = this.parseAreaA(entry);
                if (eol) {
                    this.consumeEOL();
                }
                if (!eol || entry.isContinuation()) {
                    this.parseAreaB(entry);
                    this.skipLine();
                }
            }
        } else {
            CocoToken token = this.getNextToken();
            this.ungetToken(token);
            if (token != null) {
                if (token.isEOL()) {
                    entry = new CocoDescriptionEntry();
                    this.consumeEOL();
                } else if (this.isEOF(token)) {
                    entry = null;
                }
            }
        }
        return entry;
    }

    private void consumeEOL() throws IOException {
        CocoToken token = this.getNextToken();
        if (token != null && token.isEOL()) {
            this.updatePosition(token);
        } else {
            this.ungetToken(token);
        }
    }

    private boolean parseIndicatorArea(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        CocoToken token = this.getNextToken();
        if (!this.isInIndicatorArea(token)) {
            return false;
        }
        if (token.isEOL()) {
            this.ungetToken(token);
            return true;
        }
        if (this.isSpace(token)) {
            this.skipIndicatorArea();
            return false;
        }
        if (this.isComment(token)) {
            entry.setComment(true);
            this.skipIndicatorArea();
            return false;
        }
        String value = token.getStringValue().toUpperCase();
        if (value.equals("D")) {
            entry.setIndicatorValue(value);
            return false;
        }
        if (value.equals("-")) {
            entry.setContinuation(true);
            return false;
        }
        this.logAndThrow("CCCB4202", new Object[]{token.getStringValue()}, ErrorManager.Severity.ERROR, null, null);
        return false;
    }

    private boolean isEOF(CocoToken token) {
        return token.getType() == 5;
    }

    private boolean parseAreaA(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        CocoToken token;
        block8: {
            boolean eodEncountered = false;
            if (entry.isComment()) {
                this.skipAreaA();
                return eodEncountered;
            }
            token = null;
            do {
                if ((token = this.getNextToken()) == null || this.isEOF(token)) {
                    this.ungetToken(token);
                    break block8;
                }
                if (!" ".equals(token.getStringValue())) {
                    this.ungetToken(token);
                    break block8;
                }
                if (!token.isEOL()) continue;
                this.ungetToken(token);
                return true;
            } while (this.isInAreaA(token) || this.isPartiallyInAreaA(token));
            this.ungetToken(token);
        }
        if (token == null || this.isEOF(token)) {
            this.ungetToken(token);
            return false;
        }
        if (!this.isInAreaA(token) && !this.isPartiallyInAreaA(token)) {
            entry.setContinuation(true);
            return false;
        }
        if (entry.isContinuation()) {
            this.logAndThrow("CCCB4204", null, ErrorManager.Severity.ERROR, null, token);
        }
        this.parseLevelNumber(entry);
        this.skipSpacesOrPeriods(true);
        token = this.getNextToken();
        if (token != null && !token.isEOL()) {
            this.ungetToken(token);
            this.parseDataName(entry);
        }
        return false;
    }

    private void parseAreaB(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        if (entry.isComment()) {
            this.skipAreaB();
            return;
        }
        this.skipOptionalSpaces(false);
        CocoToken token = this.getNextTokenAreaB(true, true);
        this.ungetToken(token);
        if (token == null || this.isEOF(token) || !this.isInAreaB(token)) {
            entry.setContinuation(false);
            return;
        }
        if (entry.getLevel() == -1 && (entry.getName() == null || entry.getName().trim().length() == 0) && token != null && token.isEOL()) {
            return;
        }
        if (entry.getLevel() == -1) {
            entry.setContinuation(false);
            this.parseLevelNumber(entry);
        }
        if (entry.getLevel() <= 0 || entry.getName() == null || entry.getName().length() <= 0) {
            this.parseDataName(entry);
        }
        this.parseRedefinesClause(entry);
        boolean gotBlankClause = false;
        boolean gotExternalClause = false;
        boolean gotGlobalClause = false;
        boolean gotJustifiedClause = false;
        boolean gotOccursClause = false;
        boolean gotPictureClause = false;
        boolean gotSignClause = false;
        boolean gotSynchronizedClause = false;
        boolean gotUsageClause = false;
        boolean gotValueClause = false;
        boolean gotDateFormatClause = false;
        boolean done = false;
        int prevCount = 0;
        while (!done) {
            String value;
            int passCount = 0;
            if (!gotBlankClause) {
                gotBlankClause = this.parseBlankWhenZeroClause(entry);
                passCount += gotBlankClause ? 1 : 0;
            }
            if (!gotExternalClause) {
                gotExternalClause = this.parseExternalClause(entry);
                passCount += gotExternalClause ? 1 : 0;
            }
            if (!gotGlobalClause) {
                gotGlobalClause = this.parseGlobalClause(entry);
                passCount += gotGlobalClause ? 1 : 0;
            }
            if (!gotJustifiedClause) {
                gotJustifiedClause = this.parseJustifiedClause(entry);
                passCount += gotJustifiedClause ? 1 : 0;
            }
            if (!gotOccursClause) {
                gotOccursClause = this.parseOccursClause(entry);
                passCount += gotOccursClause ? 1 : 0;
            }
            if (!gotPictureClause) {
                gotPictureClause = this.parsePictureClause(entry);
                passCount += gotPictureClause ? 1 : 0;
            }
            if (!gotSignClause) {
                gotSignClause = this.parseSignClause(entry);
                passCount += gotSignClause ? 1 : 0;
            }
            if (!gotSynchronizedClause) {
                gotSynchronizedClause = this.parseSynchronizedClause(entry);
                passCount += gotSynchronizedClause ? 1 : 0;
            }
            if (!gotUsageClause) {
                gotUsageClause = this.parseUsageClause(entry);
                passCount += gotUsageClause ? 1 : 0;
            }
            if (!gotValueClause) {
                gotValueClause = this.parseValueClause(entry);
                passCount += gotValueClause ? 1 : 0;
            }
            if (!gotDateFormatClause) {
                gotDateFormatClause = this.parseDateFormatClause(entry);
                passCount += gotDateFormatClause ? 1 : 0;
            }
            this.skipOptionalSpaces(true);
            token = this.getNextTokenAreaB(false, true);
            this.ungetToken(token);
            if (token == null || this.isEOF(token)) {
                this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, null);
            }
            boolean bl = done = (value = token.getStringValue()).equals(".") || value.equals(". ");
            if (!done && passCount <= prevCount) {
                this.logAndThrow("CCCB4205", new Object[]{value}, ErrorManager.Severity.ERROR, null, token, entry);
            }
            prevCount = passCount;
        }
        this.skipLine();
    }

    private void parseLevelNumber(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        CobolSourceArea area = this.getCurrentArea();
        CocoToken token = null;
        this.skipOptionalSpaces(true);
        token = area instanceof CobolSourceAreaB ? this.getNextTokenAreaB(false, true) : this.getNextToken();
        if (token != null && !this.isEOF(token)) {
            if (token.getType() == 1) {
                int level = -1;
                try {
                    level = Integer.parseInt(token.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    this.logAndThrow("CCCB4108", new Object[]{entry.getName(), String.valueOf(token.getStringValue())}, ErrorManager.Severity.ERROR, nfe, token);
                }
                try {
                    entry.setLevel(level);
                }
                catch (IllegalArgumentException e) {
                    this.logAndThrow("CCCB4108", new Object[]{entry.getName(), String.valueOf(token.getStringValue())}, ErrorManager.Severity.ERROR, e, token);
                }
            } else {
                this.logAndThrow("CCCB4108", new Object[]{entry.getName(), String.valueOf(token.getStringValue())}, ErrorManager.Severity.ERROR, null, token);
            }
        } else {
            this.logAndThrow("CCCB4206", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, null);
        }
    }

    private void parseDataName(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        try {
            String name = this.parseCobolWord(this.mReservedWordCheck);
            entry.setName(name);
            entry.setOriginalName(name);
            this.skipClauseSeparator();
        }
        catch (ReservedWordEncounteredException rwe) {
            String name;
            if (this.mReservedWordCheck) {
                entry.setReservedWordAfterLevel(rwe);
            }
            if ((name = this.formWord("FILLER", false)) != null && !"".equals(name.trim())) {
                entry.setName(name);
                entry.setOriginalName(name);
            } else {
                entry.setName("BLANK");
                entry.setOriginalName("");
            }
        }
        catch (CocoParseException cpe) {
            String name = this.formWord("FILLER", false);
            if (name != null && !"".equals(name.trim())) {
                entry.setName(name);
                entry.setOriginalName(name);
            }
            entry.setName("BLANK");
            entry.setOriginalName("");
        }
    }

    private void parseRedefinesClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        if (this.expectWord("REDEFINES")) {
            this.skipOptionalSpaces(true);
            CocoToken token = this.getNextTokenAreaB(false, true);
            if (token == null || this.isEOF(token)) {
                this.logAndThrow("CCCB4203", new Object[]{entry.getInfo()}, ErrorManager.Severity.ERROR, null, null);
            }
            if (token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token))) {
                this.logAndThrow("CCCB4203", new Object[]{entry.getInfo()}, ErrorManager.Severity.ERROR, null, null);
            }
            this.ungetToken(token);
            String name = this.parseCobolWord(this.mReservedWordCheck);
            CocoDescriptionEntry redefineTarget = this.mModel.findRedefineTarget(entry, name);
            if (redefineTarget == null) {
                this.logAndThrow("CCCB4207", new Object[]{name, entry.getName()}, ErrorManager.Severity.ERROR, null, null);
            } else if (redefineTarget == entry) {
                this.logAndThrow("CCCB4114", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, null);
            } else if (redefineTarget.getLevel() != entry.getLevel()) {
                this.logAndThrow("CCCB4116", new Object[]{entry.getName(), redefineTarget.getName(), String.valueOf(entry.getLevel()), String.valueOf(redefineTarget.getLevel())}, ErrorManager.Severity.ERROR, null, null);
            } else {
                try {
                    entry.setRedefinedTarget(redefineTarget);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
            this.skipClauseSeparator();
        }
    }

    private boolean parseBlankWhenZeroClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = true;
        if (this.expectWord("BLANK")) {
            this.expectWord("WHEN");
            if (!this.expectWord("ZERO")) {
                if (!this.expectWord("ZEROS")) {
                    if (!this.expectWord("ZEROES")) {
                        this.logAndThrow("CCCB4208", null, ErrorManager.Severity.ERROR, null, null);
                    } else {
                        entry.setBlankWhenZero(true);
                        this.skipClauseSeparator();
                    }
                } else {
                    entry.setBlankWhenZero(true);
                    this.skipClauseSeparator();
                }
            } else {
                entry.setBlankWhenZero(true);
                this.skipClauseSeparator();
            }
        } else {
            entry.setBlankWhenZero(false);
            gotClause = false;
        }
        return gotClause;
    }

    private boolean parseExternalClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = false;
        if (this.expectWord("EXTERNAL")) {
            this.skipClauseSeparator();
            gotClause = true;
        }
        return gotClause;
    }

    private boolean parseGlobalClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = false;
        if (this.expectWord("GLOBAL")) {
            this.skipClauseSeparator();
            gotClause = true;
        }
        return gotClause;
    }

    private boolean parseJustifiedClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = false;
        if (this.expectWord("JUSTIFIED") || this.expectWord("JUST")) {
            this.expectWord("RIGHT");
            entry.setJustified(true);
            this.skipClauseSeparator();
            gotClause = true;
        } else {
            entry.setJustified(false);
        }
        return gotClause;
    }

    private boolean parseOccursClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = false;
        if (this.expectWord("OCCURS")) {
            int level = entry.getLevel();
            if (level == 1 || level == 66 || level == 77 || level == 88) {
                this.logAndThrow("CCCB4209", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, null);
            }
            CocoToken token = null;
            if (this.skipOptionalSpaces(true)) {
                token = this.getNextToken();
            }
            int count1 = 0;
            int count2 = 0;
            token = this.getNextTokenAreaB(false, true);
            if (token == null || this.isEOF(token)) {
                this.logAndThrow("CCCB4203", new Object[]{entry.getInfo()}, ErrorManager.Severity.ERROR, null, null);
            }
            if (token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token))) {
                this.logAndThrow("CCCB4203", new Object[]{entry.getInfo()}, ErrorManager.Severity.ERROR, null, null);
            }
            if (token.getType() == 1) {
                try {
                    count2 = count1 = Integer.parseInt(token.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    this.logAndThrow("CCCB4210", new Object[]{token.getStringValue()}, ErrorManager.Severity.ERROR, nfe, token);
                }
            }
            if (this.expectWord("TO")) {
                if (this.skipOptionalSpaces(true)) {
                    token = this.getNextToken();
                }
                if ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token)) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getInfo()}, ErrorManager.Severity.ERROR, null, null);
                }
                if (token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token))) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                }
                if (token.getType() == 1) {
                    try {
                        int count;
                        count2 = count = Integer.parseInt(token.getStringValue());
                    }
                    catch (NumberFormatException nfe) {
                        this.logAndThrow("CCCB4210", new Object[]{token.getStringValue()}, ErrorManager.Severity.ERROR, nfe, token);
                    }
                }
                if (count1 < 0 || count2 <= count1) {
                    this.logAndThrow("CCCB4118", new Object[]{String.valueOf(count1), String.valueOf(count2)}, ErrorManager.Severity.ERROR, null, token);
                }
            } else if (count1 < 1) {
                this.logAndThrow("CCCB4117", new Object[]{String.valueOf(count1)}, ErrorManager.Severity.ERROR, null, token);
            }
            this.expectWord("TIMES");
            if (this.expectWord("DEPENDING")) {
                count1 = 0;
                this.expectWord("ON");
                if (this.skipOptionalSpaces(true)) {
                    token = this.getNextToken();
                }
                if ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token)) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                }
                if (token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token))) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                }
                this.ungetToken(token);
                String entryName = this.parseCobolWord(this.mReservedWordCheck);
                if (entryName == null || entryName.trim().length() == 0) {
                    String item1 = entry.getLevel() + " " + entry.getName();
                    token = this.getNextTokenAreaB(false, true);
                    this.logAndThrow("CCCB4224", new Object[]{"data name", "DEPENDING ON", item1}, ErrorManager.Severity.ERROR, null, token);
                }
                ArrayList<String> qualifiers = null;
                while (this.expectWord("OF")) {
                    if (this.skipOptionalSpaces(true)) {
                        token = this.getNextToken();
                    }
                    if ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token)) {
                        this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                    }
                    if (token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token))) {
                        this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                    }
                    this.ungetToken(token);
                    String qualifierName = this.parseCobolWord(this.mReservedWordCheck);
                    if (qualifierName == null || qualifierName.trim().length() == 0) {
                        token = this.getNextTokenAreaB(false, true);
                        this.logAndThrow("CCCB4224", new Object[]{"data name", "OF", entry.getInfo()}, ErrorManager.Severity.ERROR, null, token);
                    }
                    if (qualifiers == null) {
                        qualifiers = new ArrayList<String>(1);
                    }
                    qualifiers.add(qualifierName);
                }
                entry.setOccursResolveLater(count1, count2, qualifiers, entryName);
                this.mModel.addOccurs(entry);
            } else if (count1 == count2) {
                entry.setOccurs(count1);
            } else {
                token = this.getNextTokenAreaB(false, true);
                this.logAndThrow("CCCB4215", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
            }
            if (this.expectWord("ASCENDING") || this.expectWord("DESCENDING")) {
                this.expectWord("KEY");
                this.expectWord("IS");
                this.skipOptionalSpaces(true);
                token = this.getNextTokenAreaB(false, true);
                if (token == null || this.isEOF(token)) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                }
                if (token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token))) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                }
                this.ungetToken(token);
                String wd = this.parseCobolWord(this.mReservedWordCheck);
                if (wd == null || wd.trim().length() == 0) {
                    token = this.getNextTokenAreaB(false, true);
                    this.logAndThrow("CCCB4224", new Object[]{"data name", "ASCENDING or DESCENDINNG [KEY] [IS]", entry.getInfo()}, ErrorManager.Severity.ERROR, null, token);
                }
            }
            if (this.expectWord("INDEXED")) {
                this.expectWord("BY");
                this.skipOptionalSpaces(true);
                token = this.getNextTokenAreaB(false, true);
                if (token == null || this.isEOF(token)) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                }
                if (token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token))) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
                }
                this.ungetToken(token);
                String wd = this.parseCobolWord(this.mReservedWordCheck);
                if (wd == null || wd.trim().length() == 0) {
                    token = this.getNextTokenAreaB(false, true);
                    this.logAndThrow("CCCB4224", new Object[]{"data name", "INDEXED [BY]", entry.getInfo()}, ErrorManager.Severity.ERROR, null, token);
                }
                this.skipUntilNextClause();
            } else {
                this.skipClauseSeparator();
            }
            gotClause = true;
        }
        return gotClause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipUntilNextClause() throws CocoParseException, IOException {
        block8: {
            ArrayList<CocoToken> tokenList = new ArrayList<CocoToken>();
            StringBuffer wordBuffer = new StringBuffer();
            try {
                String word;
                do {
                    CocoToken tok;
                    tokenList.clear();
                    this.skipOptionalSpaces(true);
                    while (null != (tok = this.getNextTokenAreaB(false, true))) {
                        if (tok.getType() == 3) {
                            this.ungetToken(tok);
                            break;
                        }
                        wordBuffer.append(tok.getStringValue());
                        tokenList.add(0, tok);
                    }
                    if (wordBuffer.length() == 0) {
                        break block8;
                    }
                    word = wordBuffer.toString();
                    wordBuffer.delete(0, word.length());
                } while (!CocoLanguage.isClauseWord(word));
                ListIterator it = tokenList.listIterator();
                while (it.hasNext()) {
                    this.ungetToken((CocoToken)it.next());
                }
            }
            finally {
                tokenList.clear();
                wordBuffer.delete(0, wordBuffer.length());
            }
        }
    }

    private boolean parsePictureClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = false;
        if (this.expectWord("PIC") || this.expectWord("PICTURE")) {
            this.expectWord("IS");
            this.skipOptionalSpaces(true);
            CocoToken token = this.getNextTokenAreaB(false, true);
            if (token == null || this.isEOF(token)) {
                this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
            }
            if (token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token)) && (token == null || this.isEOF(token))) {
                this.logAndThrow("CCCB4203", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, token);
            }
            this.ungetToken(token);
            this.parsePictureLiteral(entry);
            this.skipClauseSeparator();
            gotClause = true;
        }
        return gotClause;
    }

    private void parsePictureLiteral(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        CocoToken token;
        StringBuffer buffer = new StringBuffer();
        boolean foundPart = false;
        this.skipOptionalSpaces(true);
        while ((token = this.getNextTokenAreaB(true, true)) != null && !this.isEOF(token)) {
            String value = token.getStringValue();
            int type = token.getType();
            boolean bl = foundPart = type == 0 || type == 1 || value.equals("/") || value.equals(",") || value.equals(".") || value.equals("+") || value.equals("-") || value.equals("*") || value.equals("(") || value.equals(")") || CocoLanguage.isCurrencySymbol(value);
            if (value.equals(".") || value.equals(",")) {
                CocoToken nextToken = this.getNextTokenAreaB(true, true);
                if (nextToken == null) {
                    foundPart = false;
                } else {
                    String nextValue = nextToken.getStringValue();
                    if (nextValue.equals(" ") || nextValue.charAt(0) == '\r') {
                        foundPart = false;
                        this.ungetToken(nextToken);
                    } else if (nextValue.equals(",") || nextValue.equals(";") || nextValue.equals(".")) {
                        CocoToken anotherToken = this.getNextTokenAreaB(true, true);
                        this.ungetToken(nextToken);
                        if (anotherToken != null) {
                            String anotherValue = anotherToken.getStringValue();
                            this.ungetToken(anotherToken);
                            foundPart = anotherValue.equals(" ");
                        }
                    } else {
                        this.ungetToken(nextToken);
                    }
                }
            }
            if (foundPart) {
                buffer.append(value);
            } else {
                this.ungetToken(token);
            }
            if (foundPart) continue;
        }
        String picstr = "";
        try {
            picstr = buffer.toString();
            CocoPicture picture = new CocoPicture(picstr);
            entry.setPicture(picture);
        }
        catch (IllegalArgumentException iae) {
            this.logAndThrow("CCCB4218", new Object[]{entry.getName(), picstr, iae.getLocalizedMessage()}, ErrorManager.Severity.ERROR, iae, null);
        }
    }

    private boolean parseSignClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = true;
        if (this.expectWord("SIGN")) {
            this.expectWord("IS");
            if (this.expectWord("LEADING")) {
                entry.setSign(CocoSign.LeadingSign);
            } else if (this.expectWord("TRAILING")) {
                entry.setSign(CocoSign.TrailingSign);
            } else {
                this.logAndThrow("CCCB4219", new Object[]{entry.getName()}, ErrorManager.Severity.ERROR, null, null);
            }
            if (this.expectWord("SEPARATE")) {
                this.expectWord("CHARACTER");
                entry.setSeparateSign(true);
            }
            this.skipClauseSeparator();
        } else if (this.expectWord("LEADING")) {
            entry.setSign(CocoSign.LeadingSign);
            if (this.expectWord("SEPARATE")) {
                this.expectWord("CHARACTER");
                entry.setSeparateSign(true);
            }
            this.skipClauseSeparator();
        } else if (this.expectWord("TRAILING")) {
            entry.setSign(CocoSign.TrailingSign);
            if (this.expectWord("SEPARATE")) {
                this.expectWord("CHARACTER");
                entry.setSeparateSign(true);
            }
            this.skipClauseSeparator();
        } else {
            gotClause = false;
        }
        return gotClause;
    }

    private boolean parseSynchronizedClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = false;
        if (this.expectWord("SYNCHRONIZED") || this.expectWord("SYNC")) {
            if (!this.expectWord("LEFT")) {
                this.expectWord("RIGHT");
            }
            this.skipClauseSeparator();
            gotClause = true;
        }
        return gotClause;
    }

    private boolean parseUsageClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = true;
        if (this.expectWord("USAGE")) {
            this.expectWord("IS");
        }
        try {
            if (this.expectWord("BINARY")) {
                entry.setUsage(1);
            } else if (this.expectWord("COMP")) {
                entry.setUsage(1);
            } else if (this.expectWord("COMPUTATIONAL")) {
                entry.setUsage(1);
            } else if (this.expectWord("DISPLAY")) {
                entry.setUsage(3);
            } else if (this.expectWord("PACKED-DECIMAL")) {
                entry.setUsage(4);
            } else if (this.expectWord("DISPLAY-1")) {
                entry.setUsage(31);
            } else if (this.expectWord("COMP-1")) {
                entry.setUsage(21);
            } else if (this.expectWord("COMPUTATIONAL-1")) {
                entry.setUsage(21);
            } else if (this.expectWord("COMP-2")) {
                entry.setUsage(22);
            } else if (this.expectWord("COMPUTATIONAL-2")) {
                entry.setUsage(22);
            } else if (this.expectWord("COMP-3")) {
                entry.setUsage(23);
            } else if (this.expectWord("COMPUTATIONAL-3")) {
                entry.setUsage(23);
            } else if (this.expectWord("COMP-4")) {
                entry.setUsage(24);
            } else if (this.expectWord("COMPUTATIONAL-4")) {
                entry.setUsage(24);
            } else if (this.expectWord("COMP-5")) {
                entry.setUsage(25);
            } else if (this.expectWord("COMPUTATIONAL-5")) {
                entry.setUsage(25);
            } else if (this.expectWord("INDEX")) {
                entry.setUsage(5);
            } else if (this.expectWord("POINTER") || this.expectWord("PROCEDURE-POINTER")) {
                entry.setUsage(3);
            } else if (this.expectWord("OBJECT")) {
                if (this.expectWord("REFERENCE")) {
                    if (this.expectWord("METACLASS")) {
                        this.expectWord("OF");
                    }
                    this.formWord(null, true);
                } else {
                    CocoToken token = this.getNextToken();
                    this.ungetToken(token);
                    this.logAndThrow("CCCB4205", new Object[]{token.getStringValue()}, ErrorManager.Severity.ERROR, null, token, entry);
                }
            } else {
                gotClause = false;
            }
            if (gotClause) {
                this.skipClauseSeparator();
            }
            return gotClause;
        }
        catch (IllegalArgumentException e) {
            throw new CocoParseException(e.getLocalizedMessage(), null, -1, -1, entry);
        }
    }

    private boolean parseValueClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = true;
        if (this.expectWord("VALUE")) {
            this.expectWord("IS");
            this.skipValueClause(entry);
            this.skipClauseSeparator();
        } else if (this.expectWord("VALUES")) {
            this.expectWord("ARE");
            this.skipValueClause(entry);
            this.skipClauseSeparator();
        } else {
            gotClause = false;
        }
        return gotClause;
    }

    private boolean parseDateFormatClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        boolean gotClause = false;
        if (this.expectWord("DATE")) {
            if (this.expectWord("FORMAT")) {
                this.expectWord("IS");
                this.skipOptionalSpaces(true);
                CocoToken token = this.getNextTokenAreaB(false, true);
                if (token == null || this.isEOF(token)) {
                    this.logAndThrow("CCCB4203", new Object[]{entry.getInfo()}, ErrorManager.Severity.ERROR, null, null);
                }
                if (!token.isEOL()) {
                    this.ungetToken(token);
                }
                if ((token = this.getNextTokenAreaB(false, true)).getType() != 0) {
                    this.logAndThrow("CCCB4205", new Object[]{token.getStringValue()}, ErrorManager.Severity.ERROR, null, token, entry);
                }
                this.skipClauseSeparator();
                gotClause = true;
            } else {
                CocoToken token = this.getNextTokenAreaB(true, true);
                if (token != null && !this.isEOF(token)) {
                    this.ungetToken(token);
                }
                this.logAndThrow("CCCB4220", new Object[]{entry.getName(), token.getStringValue()}, ErrorManager.Severity.ERROR, null, token);
            }
        }
        return gotClause;
    }

    private boolean skipSequenceArea() throws IOException {
        CocoToken token = null;
        boolean haveTokens = false;
        do {
            try {
                token = this.getNextToken();
                if (token == null || this.isEOF(token)) break;
                if (!this.isInSequenceArea(token)) {
                    if (!token.isEOL()) {
                        haveTokens = true;
                    }
                    this.ungetToken(token);
                    token = null;
                    continue;
                }
                if (!token.isEOL()) continue;
                this.ungetToken(token);
                token = null;
            }
            catch (CocoParseException cpe) {
                token = null;
            }
        } while (token != null && !this.isEOF(token));
        return haveTokens;
    }

    private boolean skipIndicatorArea() throws IOException {
        CocoToken token = null;
        boolean haveTokens = false;
        do {
            try {
                token = this.getNextToken();
            }
            catch (CocoParseException cpe) {
                token = null;
            }
            haveTokens |= token != null && !this.isEOF(token);
            if (token == null || this.isEOF(token) || this.isInIndicatorArea(token)) continue;
            this.ungetToken(token);
            token = null;
        } while (token != null && !this.isEOF(token));
        return haveTokens;
    }

    private boolean skipAreaA() throws IOException {
        CocoToken token = null;
        boolean haveTokens = false;
        do {
            try {
                token = this.getNextToken();
            }
            catch (CocoParseException cpe) {
                token = null;
            }
            haveTokens |= token != null && !this.isEOF(token);
            if (token == null || this.isEOF(token) || this.isInAreaA(token)) continue;
            this.ungetToken(token);
            token = null;
        } while (token != null && !this.isEOF(token));
        return haveTokens;
    }

    private boolean skipAreaB() throws IOException {
        CocoToken token = null;
        boolean haveTokens = false;
        do {
            try {
                token = this.getNextToken();
            }
            catch (CocoParseException cpe) {
                token = null;
            }
            haveTokens |= token != null && !this.isEOF(token);
            if (token == null || this.isEOF(token) || this.isInAreaB(token)) continue;
            this.ungetToken(token);
            token = null;
        } while (token != null && !this.isEOF(token));
        return haveTokens;
    }

    private boolean expectWord(String word) throws CocoParseException, IOException {
        boolean gotExpected = false;
        if (word != null) {
            gotExpected = this.formWord(word, false) != null;
        }
        return gotExpected;
    }

    private String formWord(String word, boolean checkReserved) throws CocoParseException, IOException {
        CocoToken tok;
        String name;
        StringBuffer wordBuf;
        CocoToken previous_token;
        ArrayList spaces;
        ArrayList<CocoToken> undoTokens;
        block28: {
            undoTokens = new ArrayList<CocoToken>();
            spaces = new ArrayList();
            CobolSourceArea area = this.getCurrentArea();
            previous_token = null;
            CocoToken token = null;
            wordBuf = new StringBuffer();
            boolean gotFirst = false;
            boolean gotStartColon = false;
            boolean wasHyphen = false;
            boolean eol = this.skipOptionalSpaces(true, spaces);
            if (eol) {
                token = this.getNextToken();
            }
            while (true) {
                CocoToken previousToken;
                String value;
                if ((area = this.getCurrentArea()) == null || area instanceof CobolSourceAreaB) {
                    token = this.getNextTokenAreaB(false, true);
                    if ((token == null || this.isEOF(token)) && wordBuf.length() == 0) {
                        this.logAndThrow("CCCB4216", null, ErrorManager.Severity.ERROR, null, token);
                    }
                } else {
                    token = this.getNextToken();
                    if (token != null && !this.isEOF(token)) {
                        if (area instanceof CobolSourceAreaA && (this.isInAreaA(token) || this.isPartiallyInAreaA(token))) {
                            if ((token == null || this.isEOF(token)) && wordBuf.length() == 0) {
                                this.logAndThrow("CCCB4216", null, ErrorManager.Severity.ERROR, null, token);
                            }
                        } else if (!this.isInArea(token, area)) {
                            this.ungetToken(token);
                            if (wordBuf.length() == 0) {
                                this.logAndThrow("CCCB4217", null, ErrorManager.Severity.ERROR, null, token);
                            }
                        }
                    }
                }
                if (token == null || this.isEOF(token)) {
                    this.logAndThrow("CCCB4216", null, ErrorManager.Severity.ERROR, null, token);
                }
                if ((value = token.getStringValue()).equals("-")) {
                    wasHyphen = true;
                    if (gotFirst) {
                        wordBuf.append(token.getStringValue());
                        undoTokens.add(token);
                        continue;
                    }
                    this.ungetToken(token);
                    break block28;
                }
                if (wasHyphen == gotFirst && (token.getType() == 0 || token.getType() == 1)) {
                    gotFirst = true;
                    wasHyphen = false;
                    wordBuf.append(token.getStringValue());
                    previous_token = token;
                    undoTokens.add(token);
                    continue;
                }
                if (!value.equals(":")) break;
                if (gotStartColon && (previousToken = (CocoToken)(undoTokens.size() == 0 ? null : undoTokens.get(undoTokens.size() - 1))) != null && value.equals(previousToken.getStringValue())) {
                    this.ungetToken(token);
                    break block28;
                }
                gotStartColon = !gotStartColon;
                wasHyphen = false;
                wordBuf.append(token.getStringValue());
                undoTokens.add(token);
            }
            this.ungetToken(token);
            if (wasHyphen) {
                CocoToken lastToken = (CocoToken)undoTokens.get(undoTokens.size() - 1);
                this.ungetToken(lastToken);
                wordBuf.delete(wordBuf.length() - 1, wordBuf.length());
            }
            if (gotStartColon) {
                if (undoTokens.size() > 0) {
                    for (int i = undoTokens.size() - 1; i >= 0; --i) {
                        CocoToken tok2 = (CocoToken)undoTokens.get(i);
                        this.ungetToken(tok2);
                    }
                }
                if (spaces.size() > 0) {
                    for (int i = spaces.size() - 1; i >= 0; --i) {
                        this.ungetToken((CocoToken)spaces.get(i));
                    }
                }
            }
        }
        String string = name = wordBuf.length() == 0 ? null : wordBuf.toString();
        if (word != null && name != null && name.compareToIgnoreCase(word) != 0) {
            int i;
            name = null;
            int size = undoTokens.size();
            for (i = size - 1; i >= 0; --i) {
                tok = (CocoToken)undoTokens.remove(i);
                this.ungetToken(tok);
            }
            for (i = spaces.size() - 1; i >= 0; --i) {
                this.ungetToken((CocoToken)spaces.get(i));
            }
        }
        if (checkReserved && name != null && CocoLanguage.isReservedWord(name)) {
            int i;
            int size = undoTokens.size();
            for (i = size - 1; i >= 0; --i) {
                tok = (CocoToken)undoTokens.remove(i);
                this.ungetToken(tok);
            }
            for (i = spaces.size() - 1; i >= 0; --i) {
                this.ungetToken((CocoToken)spaces.get(i));
            }
            this.logAndThrow2("CCCB4221", new Object[]{name}, ErrorManager.Severity.ERROR, null, previous_token);
        }
        undoTokens.clear();
        spaces.clear();
        return name;
    }

    private String parseCobolWord(boolean checkReserved) throws CocoParseException, IOException {
        String word = this.formWord(null, checkReserved);
        if (word == null) {
            this.logAndThrow("CCCB4217", null, ErrorManager.Severity.ERROR, null, null);
        }
        return word;
    }

    private void skipValueClause(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        CocoToken token;
        boolean gotFirstOperand = false;
        this.skipOptionalSpaces(true);
        while (!((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token) || token.isEOL() && ((token = this.getNextTokenAreaB(false, true)) == null || this.isEOF(token)))) {
            this.ungetToken(token);
            String value = token.getStringValue();
            if (CocoLanguage.isNonnumericLiteralStart(token.getStringValue())) {
                this.skipNonnumericLiteral(entry);
                gotFirstOperand = true;
            } else if (value.equals("+") || value.equals("-") || CocoLanguage.isNumericLiteral(value)) {
                this.skipNumericLiteral(entry);
                gotFirstOperand = true;
            } else if (this.skipFigurativeConstant()) {
                gotFirstOperand = true;
            } else if (this.expectWord("THRU") || this.expectWord("THROUGH")) {
                this.skipOptionalSpaces(true);
            } else {
                if (gotFirstOperand) break;
                token = this.mLexer.getNextToken();
                this.mLexer.ungetToken(token);
                this.logAndThrow("CCCB4205", new Object[]{token.getStringValue()}, ErrorManager.Severity.ERROR, null, token, entry);
            }
            this.skipClauseSeparator();
        }
    }

    private boolean skipValueOperandSeparator() throws IOException {
        CocoToken token = null;
        boolean foundSeparator = false;
        token = this.getNextTokenAreaB(false, false);
        if (null != token) {
            CocoToken nextToken;
            if (" ".equals(token.getStringValue())) {
                foundSeparator = true;
            } else if ((",".equals(token.getStringValue()) || ";".equals(token.getStringValue())) && null != (nextToken = this.getNextTokenAreaB(false, false))) {
                foundSeparator = true;
                if (!" ".equals(nextToken.getStringValue())) {
                    this.ungetToken(nextToken);
                }
            }
        }
        if (!foundSeparator && token != null && !this.isEOF(token)) {
            this.ungetToken(token);
        }
        return foundSeparator;
    }

    private void skipNumericLiteral(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        CocoToken token;
        boolean findSign = true;
        boolean findDot = true;
        boolean haveNum = false;
        while (null != (token = this.getNextToken())) {
            block15: {
                String value;
                block16: {
                    value = token.getStringValue();
                    if (!findSign) break block16;
                    findSign = false;
                    if (value.equals("+") || value.equals("-")) break block15;
                }
                if (token.getType() == 1) {
                    haveNum = true;
                } else if (value.equals(".")) {
                    if (findDot) {
                        findDot = false;
                        try {
                            CocoToken nextToken = this.getNextToken();
                            this.ungetToken(nextToken);
                            if (nextToken.getType() != 1) {
                                this.ungetToken(token);
                                token = null;
                            }
                        }
                        catch (Exception e) {
                            this.ungetToken(token);
                            token = null;
                        }
                    } else {
                        this.ungetToken(token);
                        token = null;
                    }
                } else {
                    if (value.equalsIgnoreCase("E")) {
                        CocoToken nextToken1 = this.getNextToken();
                        CocoToken nextToken2 = this.getNextToken();
                        CocoToken nextToken3 = this.getNextToken();
                        if (nextToken3.getType() != 1) {
                            this.ungetToken(nextToken3);
                            nextToken3 = this.mLexer.getNextToken();
                            this.logAndThrow("CCCB4205", new Object[]{nextToken3.getStringValue()}, ErrorManager.Severity.ERROR, null, token, entry);
                        }
                        if (nextToken2.getType() != 1) {
                            this.ungetToken(nextToken3);
                            this.ungetToken(nextToken2);
                            nextToken2 = this.mLexer.getNextToken();
                            this.logAndThrow("CCCB4205", new Object[]{nextToken2.getStringValue()}, ErrorManager.Severity.ERROR, null, token, entry);
                        }
                        if (nextToken1.getStringValue().equals("+") || nextToken1.getStringValue().equals("-")) break;
                        this.ungetToken(nextToken3);
                        this.ungetToken(nextToken2);
                        this.ungetToken(nextToken1);
                        nextToken1 = this.mLexer.getNextToken();
                        this.logAndThrow("CCCB4205", new Object[]{nextToken1.getStringValue()}, ErrorManager.Severity.ERROR, null, token, entry);
                        break;
                    }
                    this.ungetToken(token);
                    token = null;
                }
            }
            if (token != null && !this.isEOF(token)) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void skipNonnumericLiteral(CocoDescriptionEntry entry) throws CocoParseException, IOException {
        CocoToken secondToken;
        byte[] bytes;
        CocoToken token = this.getNextToken();
        if (null == token) {
            return;
        }
        String value = token.getStringValue();
        String firstQuote = null;
        String lastQuote = null;
        boolean usesDbcsShiftChars = false;
        boolean gotDbcsShiftClose = false;
        if (value.equals("\"") || value.equals("'")) {
            firstQuote = value;
        } else if (CocoLanguage.isNonnumericLiteralStart(value)) {
            if (!(value = String.valueOf(value.charAt(value.length() > 1 ? 1 : 0))).equals("\"") && !value.equals("'")) {
                this.ungetToken(token);
                return;
            }
            firstQuote = value;
        } else {
            bytes = token.getBytesValue();
            if (bytes[0] == 0 && CocoLanguage.isSeparator(bytes[1])) {
                usesDbcsShiftChars = true;
            } else {
                this.ungetToken(token);
                return;
            }
        }
        while (null != (secondToken = this.getNextToken())) {
            if (usesDbcsShiftChars) {
                byte[] bytes2 = secondToken.getBytesValue();
                if (bytes2[0] != 0 || !CocoLanguage.isSeparator(bytes2[1])) continue;
                gotDbcsShiftClose = true;
                break;
            }
            value = secondToken.getStringValue();
            if (String.valueOf(value.charAt(value.length() - 1)).equals(firstQuote)) {
                CocoToken thirdToken = this.getNextToken();
                if (thirdToken != null && thirdToken.getStringValue().equals(value)) continue;
                lastQuote = firstQuote;
                if (thirdToken == null) break;
                this.ungetToken(thirdToken);
                break;
            }
            if (!value.equals("\"") && !value.equals("'")) continue;
            token = secondToken;
            break;
        }
        if (usesDbcsShiftChars && !gotDbcsShiftClose || lastQuote == null) {
            bytes = token.getBytesValue();
            this.logAndThrow("CCCB4205", new Object[]{token.getStringValue() + " (" + Integer.toHexString(bytes[0]) + Integer.toHexString(bytes[1]) + ")"}, ErrorManager.Severity.ERROR, null, token, entry);
        }
    }

    private boolean skipFigurativeConstant() throws IOException {
        boolean gotConstant;
        StringBuffer wordBuf;
        ArrayList spaces;
        ArrayList<CocoToken> undoTokens;
        block18: {
            undoTokens = new ArrayList<CocoToken>();
            spaces = new ArrayList();
            CobolSourceArea area = this.getCurrentArea();
            CocoToken token = null;
            wordBuf = new StringBuffer();
            boolean gotFirst = false;
            boolean gotStartColon = false;
            boolean wasHyphen = false;
            boolean eol = this.skipOptionalSpaces(true, spaces);
            while (true) {
                CocoToken previousToken;
                if (area == null || area instanceof CobolSourceAreaB) {
                    token = this.getNextTokenAreaB(false, true);
                    if (token == null || this.isEOF(token)) {
                        if (wordBuf.length() != 0) break block18;
                        this.logAndThrow("CCCB4216", null, ErrorManager.Severity.ERROR, null, token);
                    }
                } else {
                    token = this.getNextToken();
                    if (token == null || this.isEOF(token)) {
                        if (wordBuf.length() != 0) break block18;
                        this.logAndThrow("CCCB4216", null, ErrorManager.Severity.ERROR, null, token);
                    }
                    if (!this.isInArea(token, area)) {
                        this.ungetToken(token);
                        if (wordBuf.length() == 0) {
                            this.logAndThrow("CCCB4217", null, ErrorManager.Severity.ERROR, null, token);
                        }
                    }
                }
                if (token == null || this.isEOF(token)) break block18;
                String value = token.getStringValue();
                if (value.equals("-")) {
                    wasHyphen = true;
                    if (gotFirst) {
                        wordBuf.append(token.getStringValue());
                        undoTokens.add(token);
                        continue;
                    }
                    this.ungetToken(token);
                    break block18;
                }
                if (wasHyphen == gotFirst && (token.getType() == 0 || token.getType() == 1)) {
                    gotFirst = true;
                    wasHyphen = false;
                    wordBuf.append(token.getStringValue());
                    undoTokens.add(token);
                    continue;
                }
                if (!value.equals(":")) break;
                if (gotStartColon && (previousToken = (CocoToken)(undoTokens.size() == 0 ? null : undoTokens.get(undoTokens.size() - 1))) != null && value.equals(previousToken.getStringValue())) {
                    this.ungetToken(token);
                    break block18;
                }
                gotStartColon = !gotStartColon;
                wasHyphen = false;
                wordBuf.append(token.getStringValue());
                undoTokens.add(token);
            }
            this.ungetToken(token);
            if (wasHyphen) {
                CocoToken lastToken = (CocoToken)undoTokens.get(undoTokens.size() - 1);
                this.ungetToken(lastToken);
                wordBuf.delete(wordBuf.length() - 1, wordBuf.length());
            }
            if (gotStartColon) {
                int i;
                for (i = undoTokens.size(); i >= 0; --i) {
                    CocoToken tok = (CocoToken)undoTokens.get(i);
                    this.ungetToken(tok);
                }
                for (i = spaces.size() - 1; i >= 0; --i) {
                    this.ungetToken((CocoToken)spaces.get(i));
                }
            }
        }
        String name = wordBuf.length() == 0 ? null : wordBuf.toString();
        boolean bl = gotConstant = name != null && CocoLanguage.isFigurativeConstant(name);
        if (!gotConstant) {
            int i;
            name = null;
            int size = undoTokens.size();
            for (i = size - 1; i >= 0; --i) {
                CocoToken tok = (CocoToken)undoTokens.remove(i);
                this.ungetToken(tok);
            }
            for (i = spaces.size() - 1; i >= 0; --i) {
                this.ungetToken((CocoToken)spaces.get(i));
            }
        }
        undoTokens.clear();
        spaces.clear();
        return gotConstant;
    }

    private void skipClauseSeparator() throws CocoParseException, IOException {
        CocoToken token = null;
        boolean foundSep = false;
        while ((token = this.getNextTokenAreaB(false, true)) != null && !this.isEOF(token)) {
            String value = token.getStringValue();
            if (value.equals(",")) {
                foundSep = true;
                this.skipOptionalSpaces(false);
                break;
            }
            if (value.equals(";")) {
                foundSep = true;
                this.skipOptionalSpaces(false);
                break;
            }
            if (value.equals(" ") || value.charAt(0) == '\r') {
                foundSep = true;
                continue;
            }
            this.ungetToken(token);
            if (foundSep) break;
            foundSep = value.equals(".");
            break;
        }
    }

    private boolean skipOptionalSpaces(boolean stayInArea) throws IOException {
        return this.skipOptionalSpaces(stayInArea, null);
    }

    private boolean skipOptionalSpaces(boolean stayInArea, List consumed) throws IOException {
        CobolSourceArea area = null;
        CocoToken token = null;
        if (stayInArea) {
            area = this.getCurrentArea();
        }
        do {
            try {
                token = this.getNextToken();
            }
            catch (CocoParseException cpe) {
                token = null;
            }
            if (token == null || this.isEOF(token)) continue;
            if (token.isEOL()) {
                this.ungetToken(token);
                return true;
            }
            if (token.getStringValue().equals(" ")) {
                if (area != null && area instanceof CobolSourceAreaB && !this.isInArea(token, area) && this.isInAreaB(token)) {
                    if (consumed == null) continue;
                    consumed.add(token);
                    continue;
                }
                if (area != null && !this.isInArea(token, area)) {
                    this.ungetToken(token);
                    token = null;
                    continue;
                }
                if (consumed == null) continue;
                consumed.add(token);
                continue;
            }
            this.ungetToken(token);
            token = null;
        } while (token != null && !this.isEOF(token));
        return false;
    }

    private void skipSpacesOrPeriods(boolean stayInArea) throws CocoParseException, IOException {
        CobolSourceArea area = null;
        CocoToken token = null;
        int count = 0;
        if (stayInArea) {
            area = this.getCurrentArea();
        }
        do {
            String value;
            if ((value = (token = this.getNextToken()).getStringValue()).equals(" ") || value.equals(".")) {
                if (area == null || this.isInArea(token, area)) {
                    ++count;
                    continue;
                }
                this.ungetToken(token);
                break;
            }
            this.ungetToken(token);
            break;
        } while (token != null && !this.isEOF(token));
        if (count == 0 && token != null && !this.isEOF(token)) {
            this.logAndThrow("CCCB4223", null, ErrorManager.Severity.ERROR, null, token);
        }
    }

    private void skipLine() throws IOException {
        CocoToken token = null;
        do {
            try {
                token = this.mLexer.getNextToken();
            }
            catch (CocoParseException cpe) {
                token = null;
            }
            if (token == null || this.isEOF(token)) continue;
            if (this.mRow != token.getRow()) {
                this.mLexer.ungetToken(token);
                token = null;
                continue;
            }
            this.updatePosition(token);
        } while (token != null && !this.isEOF(token));
    }

    private CocoToken getNextToken() throws CocoParseException, IOException {
        CocoToken token = this.mLexer.getNextToken();
        if (token == null) {
            this.logAndThrow("CCCB4203", null, ErrorManager.Severity.ERROR, null, null);
        }
        this.updatePosition(token);
        return token;
    }

    private CocoToken getNextTokenAreaB(boolean stayInLine, boolean ignoreNextLineSpaces) throws CocoParseException, IOException {
        CocoToken token;
        block13: {
            token = this.mLexer.getNextToken();
            if (token == null) {
                return null;
            }
            if (this.isEOF(token)) {
                return token;
            }
            if (this.isInAreaB(token)) {
                this.updatePosition(token);
            } else if (stayInLine) {
                token = null;
            } else {
                this.mLexer.ungetToken(token);
                this.undoUpdatePosition();
                while (true) {
                    this.skipLine();
                    this.skipSequenceArea();
                    CocoDescriptionEntry dummyEntry = new CocoDescriptionEntry();
                    this.parseIndicatorArea(dummyEntry);
                    if (dummyEntry.isComment()) continue;
                    this.parseAreaA(dummyEntry);
                    if (!dummyEntry.isContinuation()) {
                        String levelValue = " ";
                        int level = dummyEntry.getLevel();
                        int col = CobolSourceAreaA.getArea().getStartColumn();
                        int type = 3;
                        if (level != -1) {
                            levelValue = Integer.toString(level);
                            type = 1;
                        }
                        CocoToken levelToken = new CocoToken(levelValue, type, this.mRow, col);
                        this.mLexer.ungetToken(levelToken);
                        this.undoUpdatePosition();
                        String indicatorValue = dummyEntry.getIndicatorValue();
                        col = CobolSourceIndicatorArea.getArea().getStartColumn();
                        if (indicatorValue.equals("")) {
                            type = 3;
                            indicatorValue = " ";
                        } else {
                            type = Character.isDigit(indicatorValue.charAt(0)) ? 1 : (Character.isLetter(indicatorValue.charAt(0)) ? 0 : (CocoLanguage.isSeparator(indicatorValue) ? 3 : (!CocoLanguage.isInCobolCharSet(indicatorValue.charAt(0)) ? 4 : 2)));
                        }
                        CocoToken indicatorToken = new CocoToken(indicatorValue, type, this.mRow, col);
                        this.mLexer.ungetToken(indicatorToken);
                        this.undoUpdatePosition();
                        token = null;
                        break block13;
                    }
                    if (ignoreNextLineSpaces) {
                        do {
                            this.skipOptionalSpaces(true);
                        } while ((token = this.getNextToken()).isEOL());
                        this.ungetToken(token);
                    }
                    token = this.mLexer.getNextToken();
                    this.mLexer.ungetToken(token);
                    if (this.isInAreaB(token)) break;
                }
                token = this.mLexer.getNextToken();
                this.updatePosition(token);
            }
        }
        return token;
    }

    private void ungetToken(CocoToken token) throws IllegalArgumentException {
        if (token != null && !this.isEOF(token)) {
            this.mLexer.ungetToken(token);
            this.undoUpdatePosition();
        }
    }

    private void updatePosition(CocoToken token) {
        if (this.isEOF(token)) {
            return;
        }
        this.mCols.add(new Integer(this.mCol));
        this.mRows.add(new Integer(this.mRow));
        this.mCol = token.getColumn() + token.getLength();
        this.mRow = token.getRow();
    }

    private void undoUpdatePosition() {
        if (!this.mCols.isEmpty() && !this.mRows.isEmpty()) {
            this.mCol = (Integer)this.mCols.remove(this.mCols.size() - 1);
            this.mRow = (Integer)this.mRows.remove(this.mRows.size() - 1);
        }
    }

    private boolean isInArea(CocoToken token, CobolSourceArea area) {
        int begPos = token.getColumn();
        int endPos = token.getColumn() + token.getLength() - 1;
        return area.isInArea(begPos, endPos);
    }

    private boolean isInSequenceArea(CocoToken token) {
        CobolSourceArea area = CobolSourceSequenceArea.getArea();
        return this.isInArea(token, area);
    }

    private boolean isInIndicatorArea(CocoToken token) {
        CobolSourceArea area = CobolSourceIndicatorArea.getArea();
        return this.isInArea(token, area);
    }

    private CobolSourceArea getCurrentArea() {
        Iterator it = cSourceAreas.iterator();
        CobolSourceArea area = null;
        while (it.hasNext() && area == null) {
            area = (CobolSourceArea)it.next();
            area = area.isInArea(this.mCol, this.mCol) ? area : null;
        }
        return area;
    }

    private boolean isInAreaA(CocoToken token) {
        CobolSourceArea area = CobolSourceAreaA.getArea();
        return this.isInArea(token, area);
    }

    private boolean isPartiallyInAreaA(CocoToken token) {
        CobolSourceArea area = CobolSourceAreaA.getArea();
        int start = area.getStartColumn();
        int end = area.getEndColumn();
        int tokStart = token.getColumn();
        int tokEnd = token.getColumn() + token.getLength() - 1;
        return start <= tokEnd && tokEnd <= end || start <= tokStart && tokStart <= end || tokStart <= start && end <= tokEnd;
    }

    private boolean isInAreaB(CocoToken token) {
        CobolSourceArea area = CobolSourceAreaB.getArea();
        if (this.mLexer.is72ColumnLimitEnforced()) {
            return this.isInArea(token, area);
        }
        return this.isInArea(token, area) || area.getStartColumn() < token.getColumn();
    }

    private boolean isComment(CocoToken token) {
        String value;
        boolean isIt = false;
        if (this.isInIndicatorArea(token) && ((value = token.getStringValue()).equals("*") || value.equals("/"))) {
            isIt = true;
        }
        return isIt;
    }

    private boolean isSpace(CocoToken token) {
        boolean isIt = true;
        char[] chs = token.getCharsValue();
        for (int i = 0; i < chs.length; ++i) {
            isIt &= chs[i] == " ".charAt(0);
        }
        return isIt;
    }

    protected void generateParseException(String msg, CocoToken token) throws CocoParseException {
        if (msg == null) {
            msg = "";
        }
        throw new CocoParseException(msg, token, token == null ? this.mRow : token.getRow(), token == null ? this.mCol : token.getColumn(), this.mCurrentEntry);
    }

    private static void debugToken(CocoToken token) {
        System.err.println("row: " + token.getRow());
        System.err.println("column: " + token.getColumn());
        System.err.println("value: " + token.getStringValue());
        System.err.println("length: " + token.getLength());
        System.err.println("type: " + token.getType());
        System.err.flush();
    }

    private void logAndThrow(String msgKey, Object[] params, ErrorManager.Severity severity, Exception e, CocoToken token) {
        Message msg = MessageCatalog.getMessage(msgKey);
        String text = msg.formatText(params);
        this.mErrorMgr.log(severity, e, text);
        this.generateParseException(text, token);
    }

    private void logAndThrow(String msgKey, Object[] params, ErrorManager.Severity severity, Exception e, CocoToken token, CocoDescriptionEntry entry) throws CocoParseException {
        if (this.mReservedWordCheck && entry != null && entry.getReservedWordAfterLevel() != null) {
            this.mErrorMgr.log(severity, entry.getReservedWordAfterLevel(), entry.getReservedWordAfterLevel().getMessage());
            throw entry.getReservedWordAfterLevel();
        }
        Message msg = MessageCatalog.getMessage(msgKey);
        String text = msg.formatText(params);
        this.mErrorMgr.log(severity, e, text);
        this.generateParseException(text, token);
    }

    private void logAndThrow2(String msgKey, Object[] params, ErrorManager.Severity severity, Exception e, CocoToken token) {
        Message msg = MessageCatalog.getMessage(msgKey);
        String text = msg.formatText(params);
        this.mErrorMgr.log(severity, e, text);
        if (text == null) {
            text = "";
        }
        throw new ReservedWordEncounteredException(text, token, token == null ? this.mRow : token.getRow(), token == null ? this.mCol : token.getColumn(), this.mCurrentEntry);
    }

    static {
        String pkg = CocoParser.class.getPackage().getName();
        HashSet<CobolSourceArea> areas = new HashSet<CobolSourceArea>();
        areas.add(CobolSourceSequenceArea.getArea());
        areas.add(CobolSourceIndicatorArea.getArea());
        areas.add(CobolSourceAreaA.getArea());
        areas.add(CobolSourceAreaB.getArea());
        cSourceAreas = Collections.unmodifiableSet(areas);
    }
}

