/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.model;

import com.sun.encoder.coco.model.CocoDescriptionEntry;
import com.sun.encoder.coco.model.CocoToken;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;

public class CocoParseException
extends RuntimeException {
    private CocoToken mToken;
    private String mMsg;
    private String mExMsg;
    private int mRow;
    private int mCol;

    public CocoParseException(String msg, CocoToken token, int row, int col, CocoDescriptionEntry entry) {
        if (row < 0) {
            row = -1;
        }
        if (col < 0) {
            col = -1;
        }
        this.mRow = row;
        this.mCol = col;
        this.mMsg = msg;
        this.mToken = token;
        Message err = MessageCatalog.getMessage("CCCB4200");
        String tokenVal = token == null || "".equals(token.getStringValue()) ? "(n/a)" : "'" + token.getStringValue() + "'";
        String itemName = token == null || "".equals(token.getStringValue()) ? "(n/a)" : "'" + entry.getName() + "'";
        this.mExMsg = err.formatText(new Object[]{String.valueOf(row), String.valueOf(col), itemName, tokenVal, String.valueOf(this.mMsg)});
    }

    public String getMessage() {
        return this.mExMsg;
    }

    public int getColumn() {
        return this.mCol;
    }

    public int getRow() {
        return this.mRow;
    }

    public CocoToken getToken() {
        return this.mToken;
    }
}

