/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.Com4jObject;
import com4j.ComException;
import com4j.ComObjectListener;
import com4j.ComThread;
import com4j.GUID;
import com4j.IID;
import com4j.Native;
import com4j.Task;
import com4j.Variant;
import com4j.Wrapper;
import java.io.File;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class COM4J {
    public static final GUID IID_IUnknown = new GUID("{00000000-0000-0000-C000-000000000046}");
    public static final GUID IID_IDispatch = new GUID("{00020400-0000-0000-C000-000000000046}");

    private COM4J() {
    }

    public static <T extends Com4jObject> T createInstance(Class<T> primaryInterface, GUID clsid) throws ComException {
        return COM4J.createInstance(primaryInterface, clsid.toString());
    }

    public static <T extends Com4jObject> T createInstance(Class<T> primaryInterface, String clsid) throws ComException {
        return COM4J.createInstance(primaryInterface, clsid, 23);
    }

    public static <T extends Com4jObject> T createInstance(Class<T> primaryInterface, String clsid, int clsctx) throws ComException {
        return (T)((Com4jObject)new CreateInstanceTask<T>(clsid, clsctx, primaryInterface).execute());
    }

    public static <T extends Com4jObject> T getActiveObject(Class<T> primaryInterface, GUID clsid) {
        return (T)((Com4jObject)new GetActiveObjectTask<T>(clsid, primaryInterface).execute());
    }

    public static <T extends Com4jObject> T getActiveObject(Class<T> primaryInterface, String clsid) {
        return COM4J.getActiveObject(primaryInterface, new GUID(clsid));
    }

    public static GUID getIID(Class<?> _interface) {
        IID iid = _interface.getAnnotation(IID.class);
        if (iid == null) {
            throw new IllegalArgumentException(_interface.getName() + " doesn't have @IID annotation");
        }
        return new GUID(iid.value());
    }

    public static Com4jObject loadTypeLibrary(final File typeLibraryFile) {
        return (Com4jObject)new Task<Com4jObject>(){

            @Override
            public Com4jObject call() {
                return Wrapper.create(Native.loadTypeLibrary(typeLibraryFile.getAbsolutePath()));
            }
        }.execute();
    }

    public static ByteBuffer createBuffer(int ptr, int size) {
        return Native.createBuffer(ptr, size);
    }

    public static void addListener(ComObjectListener listener) {
        ComThread.get().addListener(listener);
    }

    public static void removeListener(ComObjectListener listener) {
        ComThread.get().removeListener(listener);
    }

    public static void cleanUp() {
        ComThread.detach();
    }

    static int queryInterface(int ptr, GUID iid) {
        return Native.queryInterface(ptr, iid.v[0], iid.v[1]);
    }

    static Wrapper unwrap(Com4jObject obj) {
        if (obj instanceof Wrapper) {
            return (Wrapper)obj;
        }
        return (Wrapper)Proxy.getInvocationHandler(obj);
    }

    static int getPtr(Com4jObject obj) {
        if (obj == null) {
            return 0;
        }
        return COM4J.unwrap(obj).getPtr();
    }

    private static void loadNativeLibrary() {
        Throwable cause = null;
        try {
            System.loadLibrary("com4j");
            return;
        }
        catch (Throwable t) {
            cause = t;
            URL res = COM4J.class.getClassLoader().getResource("com4j/COM4J.class");
            String url = res.toExternalForm();
            if (url.startsWith("jar:")) {
                int idx = url.lastIndexOf(33);
                String filePortion = url.substring(4, idx);
                while (filePortion.startsWith("/")) {
                    filePortion = filePortion.substring(1);
                }
                if (filePortion.startsWith("file:/")) {
                    if ((filePortion = filePortion.substring(6)).startsWith("//")) {
                        filePortion = filePortion.substring(2);
                    }
                    filePortion = URLDecoder.decode(filePortion);
                    File jarFile = new File(filePortion);
                    File dllFile = new File(jarFile.getParentFile(), "com4j.dll");
                    System.load(dllFile.getPath());
                    return;
                }
            }
            UnsatisfiedLinkError error = new UnsatisfiedLinkError("Unable to load com4j.dll");
            error.initCause(cause);
            throw error;
        }
    }

    static {
        COM4J.loadNativeLibrary();
        Native.init();
        Variant.MISSING.makeError(-2147352572);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetActiveObjectTask<T extends Com4jObject>
    extends Task<T> {
        private final GUID clsid;
        private final Class<T> intf;

        public GetActiveObjectTask(GUID clsid, Class<T> intf) {
            this.clsid = clsid;
            this.intf = intf;
        }

        @Override
        public T call() {
            GUID iid = COM4J.getIID(this.intf);
            int o1 = Native.getActiveObject(this.clsid.v[0], this.clsid.v[1]);
            int o2 = Native.queryInterface(o1, iid.v[0], iid.v[1]);
            Native.release(o1);
            return Wrapper.create(this.intf, o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CreateInstanceTask<T extends Com4jObject>
    extends Task<T> {
        private final String clsid;
        private final int clsctx;
        private final Class<T> intf;

        public CreateInstanceTask(String clsid, int clsctx, Class<T> intf) {
            this.clsid = clsid;
            this.clsctx = clsctx;
            this.intf = intf;
        }

        @Override
        public T call() {
            GUID iid = COM4J.getIID(this.intf);
            return Wrapper.create(this.intf, Native.createInstance(this.clsid, this.clsctx, iid.v[0], iid.v[1]));
        }
    }
}

