/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.xfire;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.jbi.xfire.EjbTransport;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.Transport;

public class EjbChannel
extends AbstractChannel {
    private static final Logger LOG = LoggerFactory.getLogger(EjbChannel.class);
    private XMLOutputFactory outputFactory;

    public EjbChannel(String uri, EjbTransport transport) {
        this.setTransport((Transport)transport);
        this.setUri(uri);
        this.outputFactory = XMLOutputFactory.newInstance();
    }

    public void open() throws Exception {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        LOG.debug("Xfire send called");
        if ("urn:xfire:channel:backchannel".equals(message.getUri())) {
            LOG.debug("message.getUri(): " + message.getUri());
            OutputStream out = (OutputStream)context.getProperty("urn:xfire:channel:backchannel");
            if (out != null) {
                try {
                    XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(out, message.getEncoding());
                    message.getSerializer().writeMessage(message, writer, context);
                    writer.close();
                }
                catch (XMLStreamException e) {
                    String msg = e.getMessage();
                    LOG.error(e.getMessage(), e);
                    throw new XFireException(msg, (Throwable)e);
                }
                return;
            }
        } else {
            LOG.debug("NOT a backchannel URI, not implemented");
        }
    }
}

