/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.endpoint;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4ejb.exception.Jbi4EjbException;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeHelper;
import it.imolinfo.jbi4ejb.jbi.endpoint.Jbi4EjbEndpoint;
import it.imolinfo.jbi4ejb.processor.ProviderExchangeProcessor;
import it.imolinfo.jbi4ejb.runtime.ProviderServiceCreator;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.StatelessEJBProxy;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.StatelessEJBProxyFactory;
import it.imolinfo.jbi4ejb.webservice.generator.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;

public class Jbi4EjbProviderEndpoint
extends Jbi4EjbEndpoint {
    private static final long serialVersionUID = -7829120677780408268L;
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4EjbProviderEndpoint.class);
    private ProviderServiceDescriptor serviceDescriptor;
    private Service xfireService;

    public Jbi4EjbProviderEndpoint(QName serviceName, String endpointName) throws Jbi4EjbException {
        super(serviceName, endpointName);
        this.setExchangeProcessor(new ProviderExchangeProcessor(this));
    }

    public void registerService() throws Jbi4EjbException {
        LOG.debug("Registering xfire service for: " + this.getServiceName());
        XFire xfire = this.getSuManager().getLifeCycle().getXfire();
        File wsdl = this.getEndpointWSDL();
        String deployDirectoryName = this.serviceDescriptor.getComponentRootPath() + "/" + this.serviceDescriptor.hashCode();
        LOG.debug("Starting deploy using root path: " + deployDirectoryName);
        File rootDir = new File(deployDirectoryName);
        if (!rootDir.exists()) {
            boolean result = rootDir.mkdir();
            if (!result) {
                String msg = "Error in creating working directory " + rootDir.getAbsolutePath();
                LOG.error(msg);
                throw new Jbi4EjbException(msg);
            }
            LOG.debug("created working directory: " + rootDir.getAbsolutePath());
        }
        List<String> jarFilesName = Util.prepareClassPath(RuntimeHelper.getComponentContext().getInstallRoot());
        StatelessEJBProxy ejbProxy = StatelessEJBProxyFactory.createEJBProxy(wsdl, this.serviceDescriptor, rootDir, jarFilesName);
        this.serviceDescriptor.setEjbProxy(ejbProxy);
        ProviderServiceCreator serviceCreator = new ProviderServiceCreator();
        this.xfireService = serviceCreator.createJbiService(this.serviceDescriptor, xfire);
        xfire.getServiceRegistry().register(this.xfireService);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LOG.debug("xfireService:" + this.xfireService);
        xfire.generateWSDL(this.xfireService.getSimpleName(), (OutputStream)baos);
        if (LOG.isDebugEnabled()) {
            LOG.debug("WSDL:\n------------------\n" + baos.toString() + "\n------------------");
        }
    }

    public void unregisterService() throws Jbi4EjbException {
        LOG.info("Service: " + this.getServiceName() + "/" + this.getEndpointName() + " unregistered");
    }

    public void validate() throws Jbi4EjbException {
    }

    public ProviderServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public void setServiceDescriptor(ProviderServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public Service getXfireService() {
        return this.xfireService;
    }
}

