/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.component.runtime;

import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeContext;
import it.imolinfo.jbi4ejb.jbi.component.runtime.ServiceDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class RuntimeHelper {
    public static Logger getLogger() {
        return RuntimeContext.getInstance().getLogger();
    }

    public static void logInfo(String msg) {
        System.out.println(msg);
        RuntimeHelper.getLogger().info(msg);
    }

    public static void logVerbose(String msg) {
        System.out.println(msg);
        RuntimeHelper.getLogger().fine(msg);
    }

    public static void logWarning(Object logObj) {
        System.out.println(logObj);
        if (logObj instanceof Throwable) {
            RuntimeHelper.getLogger().log(Level.WARNING, ((Throwable)logObj).getMessage(), (Throwable)logObj);
        } else {
            RuntimeHelper.getLogger().warning(logObj.toString());
        }
    }

    public static void logError(Object logObj) {
        System.out.println(logObj);
        if (logObj instanceof Throwable) {
            RuntimeHelper.getLogger().log(Level.SEVERE, ((Throwable)logObj).getMessage(), (Throwable)logObj);
        } else {
            RuntimeHelper.getLogger().severe(logObj.toString());
        }
    }

    public static void logDebug(Object logObj) {
        System.out.println(logObj);
        if (logObj instanceof Throwable) {
            RuntimeHelper.getLogger().log(Level.FINER, ((Throwable)logObj).getMessage(), (Throwable)logObj);
        } else {
            RuntimeHelper.getLogger().finer(logObj.toString());
        }
    }

    public static ComponentContext getComponentContext() {
        return RuntimeContext.getInstance().getComponentContext();
    }

    public static DeliveryChannel getDeliveryChannel() {
        return RuntimeContext.getInstance().getDeliveryChannel();
    }

    public static String getComponentName() {
        return RuntimeContext.getInstance().getComponentName();
    }

    public static ServiceEndpoint findServiceEndpoint(ServiceDescriptor serviceDescriptor) {
        QName serviceType = serviceDescriptor.getServiceType();
        QName serviceName = serviceDescriptor.getServiceName();
        String endpointName = serviceDescriptor.getEndpointName();
        ServiceEndpoint[] refs = null;
        ServiceEndpoint serviceEndpoint = null;
        ComponentContext compContext = RuntimeHelper.getComponentContext();
        if (compContext == null) {
            RuntimeHelper.logDebug("Component context is not yet initialized to Looking for ServiceEndpoint");
            return null;
        }
        if (serviceName != null && endpointName != null) {
            RuntimeHelper.logDebug("Looking for ServiceEndpoint with service name and endpiontServiceName: " + serviceName + "EndpointName: " + endpointName);
            serviceEndpoint = compContext.getEndpoint(serviceName, endpointName);
        }
        if (serviceEndpoint == null && serviceName != null && endpointName == null) {
            RuntimeHelper.logDebug("Looking for ServiceEndpoint with service name " + serviceName);
            refs = compContext.getEndpointsForService(serviceName);
            if (refs != null && refs.length > 0) {
                serviceEndpoint = refs[0];
            }
        }
        if (serviceEndpoint == null && serviceType != null && serviceName == null && endpointName == null) {
            RuntimeHelper.logDebug("Looking for ServiceEndpoint with service type " + serviceType);
            refs = compContext.getEndpoints(serviceType);
            if (refs != null && refs.length > 0) {
                serviceEndpoint = refs[0];
            }
        }
        return serviceEndpoint;
    }

    public static InOut createInOutMessageExchange(QName operation, ServiceEndpoint serviceEndpoint) throws MessagingException {
        InOut inOutME = null;
        DeliveryChannel channel = RuntimeHelper.getDeliveryChannel();
        MessageExchangeFactory factory = channel.createExchangeFactory(serviceEndpoint);
        inOutME = factory.createInOutExchange();
        inOutME.setOperation(operation);
        NormalizedMessage inMsg = inOutME.createMessage();
        inOutME.setInMessage(inMsg);
        return inOutME;
    }

    public static Document buildDOMDocument(Reader xmlReader) throws Exception {
        Document xmlDoc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        docBuilder.setErrorHandler(new DefaultHandler(){

            public void fatalError(SAXParseException e) throws SAXException {
                throw new SAXException(e.getMessage());
            }
        });
        docBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                InputSource source = new InputSource(reader);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
        });
        InputSource is = new InputSource(xmlReader);
        xmlDoc = docBuilder.parse(is);
        return xmlDoc;
    }

    public static StringBuffer readFromDOMSource(DOMSource domSource) {
        StringWriter writer = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = tFactory.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(writer);
            trans.transform(domSource, result);
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
        return writer.getBuffer();
    }

    public static StringBuffer readFromInputSource(InputSource inSource) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        InputStream inStream = inSource.getByteStream();
        Reader reader = inSource.getCharacterStream();
        if (reader == null) {
            reader = new InputStreamReader(inStream);
        }
        BufferedReader buff = new BufferedReader(reader);
        try {
            String line = null;
            while ((line = buff.readLine()) != null) {
                out.println(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return writer.getBuffer();
    }

    public static StringBuffer readFromSource(Source source) {
        if (source instanceof DOMSource) {
            return RuntimeHelper.readFromDOMSource((DOMSource)source);
        }
        InputSource inSource = SAXSource.sourceToInputSource(source);
        if (inSource != null) {
            return RuntimeHelper.readFromInputSource(inSource);
        }
        return null;
    }

    public static DOMSource createDOMSource(Reader xmlReader) {
        Document doc = null;
        try {
            doc = RuntimeHelper.buildDOMDocument(xmlReader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new DOMSource(doc);
    }

    public static StringBuffer getExceptionStackTrace(Exception ex) {
        StringWriter strWriter = new StringWriter();
        if (ex != null) {
            PrintWriter out = new PrintWriter(strWriter);
            ex.printStackTrace(out);
        }
        return strWriter.getBuffer();
    }

    public static String getExceptionAsXmlText(Exception ex) {
        String message = ex.getMessage();
        String stackTrace = RuntimeHelper.getExceptionStackTrace(ex).toString();
        String exXmlText = "<exception><message>" + message + "</message>" + "<stack-trace>" + stackTrace + "</stack-trace>" + "</exception>";
        return exXmlText;
    }
}

