/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.component.runtime;

import it.imolinfo.jbi4ejb.jbi.component.runtime.MessageExchangeHandler;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeHelper;
import java.io.StringReader;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.transform.Source;

public abstract class AbstractMessageExchangeHandler
implements MessageExchangeHandler {
    public static String IN_MESSAGE = "in";
    public static String OUT_MESSAGE = "out";
    private MessageExchange mMessageExchange = null;

    protected AbstractMessageExchangeHandler() {
    }

    protected final DeliveryChannel getDeliveryChannel() {
        return RuntimeHelper.getDeliveryChannel();
    }

    public final MessageExchange getMessageExchange() {
        return this.mMessageExchange;
    }

    public final void setMessageExchange(MessageExchange msgExchange) {
        this.mMessageExchange = msgExchange;
    }

    protected final void send() throws MessagingException {
        this.getDeliveryChannel().send(this.mMessageExchange);
    }

    protected final void sendDone() throws MessagingException {
        this.mMessageExchange.setStatus(ExchangeStatus.DONE);
        this.getDeliveryChannel().send(this.mMessageExchange);
    }

    protected final void sendFault() throws MessagingException {
        Fault fault = this.mMessageExchange.createFault();
        this.sendFault(fault);
    }

    protected final void sendFault(Exception ex) throws MessagingException {
        Fault fault = this.mMessageExchange.createFault();
        if (ex != null) {
            String xmlText = RuntimeHelper.getExceptionAsXmlText(ex);
            fault.setContent((Source)RuntimeHelper.createDOMSource(new StringReader(xmlText)));
        }
        this.sendFault(fault);
    }

    protected void sendFault(Fault fault) throws MessagingException {
        this.mMessageExchange.setFault(fault);
        this.getDeliveryChannel().send(this.mMessageExchange);
    }

    protected final void sendError(Exception ex) {
        try {
            this.mMessageExchange.setError(ex);
            this.getDeliveryChannel().send(this.mMessageExchange);
        }
        catch (MessagingException msgEx) {
            msgEx.printStackTrace();
        }
    }

    protected abstract void validateMessageExchange() throws MessagingException;

    protected abstract void processError(Exception var1);

    protected abstract void processDone();

    protected abstract void processMessage();

    protected abstract void processFault(Fault var1);

    private void processActive() {
        Fault fault = this.getMessageExchange().getFault();
        if (fault != null) {
            this.processFault(fault);
        } else {
            this.processMessage();
        }
    }

    public final void processMessageExchange() {
        try {
            this.validateMessageExchange();
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            if (this.getMessageExchange() != null) {
                this.sendError((Exception)((Object)ex));
            }
            return;
        }
        MessageExchange msgExchange = this.getMessageExchange();
        ExchangeStatus status = msgExchange.getStatus();
        if (ExchangeStatus.ACTIVE.equals(status)) {
            this.processActive();
        } else if (ExchangeStatus.DONE.equals(status)) {
            this.processDone();
        } else if (ExchangeStatus.ERROR.equals(status)) {
            this.processError(msgExchange.getError());
        }
    }

    public final void run() {
        try {
            this.processMessageExchange();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

