/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import it.imolinfo.jbi4cics.jbi.Messages;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.spi.LocationAwareLogger;

final class JDK14LoggerAdapter
extends MarkerIgnoringBase
implements LocationAwareLogger,
it.imolinfo.jbi4cics.Logger {
    private static final String SELF = JDK14LoggerAdapter.class.getName();
    private static final String SUPER = MarkerIgnoringBase.class.getName();
    private final Logger logger;
    private final Messages messages;

    JDK14LoggerAdapter(Logger logger, Messages messages) {
        this.logger = logger;
        this.messages = messages;
    }

    public String getName() {
        return this.logger.getName();
    }

    private boolean isI18N() {
        return this.messages != null;
    }

    private String formatMessage(String format, Object ... args) {
        String msg;
        if (this.isI18N()) {
            msg = args.length == 0 ? this.messages.getString(format, new Object[0]) : this.messages.getString(format, args);
        } else if (args.length == 0) {
            msg = format;
        } else {
            try {
                msg = MessageFormat.format(format, args);
            }
            catch (IllegalArgumentException e) {
                msg = format;
            }
        }
        return msg;
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(String msg) {
        this.log(SELF, Level.FINE, msg, null);
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            String msgStr = MessageFormat.format(format, arg);
            this.log(SELF, Level.FINE, msgStr, null);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            String msgStr = MessageFormat.format(format, arg1, arg2);
            this.log(SELF, Level.FINE, msgStr, null);
        }
    }

    public void debug(String format, Object[] args) {
        if (this.isDebugEnabled()) {
            String msgStr = MessageFormat.format(format, args);
            this.log(SELF, Level.FINE, msgStr, null);
        }
    }

    public void debug(String msg, Throwable t) {
        this.log(SELF, Level.FINE, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.log(SELF, Level.INFO, this.formatMessage(msg, new Object[0]), null);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.log(SELF, Level.INFO, this.formatMessage(format, arg), null);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.log(SELF, Level.INFO, this.formatMessage(format, arg1, arg2), null);
        }
    }

    public void info(String format, Object[] args) {
        if (this.isInfoEnabled()) {
            this.log(SELF, Level.INFO, this.formatMessage(format, args), null);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(SELF, Level.INFO, this.formatMessage(msg, new Object[0]), t);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.log(SELF, Level.WARNING, this.formatMessage(msg, new Object[0]), null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.log(SELF, Level.WARNING, this.formatMessage(format, arg), null);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.log(SELF, Level.WARNING, this.formatMessage(format, arg1, arg2), null);
        }
    }

    public void warn(String format, Object[] args) {
        if (this.isWarnEnabled()) {
            this.log(SELF, Level.WARNING, this.formatMessage(format, args), null);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(SELF, Level.WARNING, this.formatMessage(msg, new Object[0]), t);
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.log(SELF, Level.SEVERE, this.formatMessage(msg, new Object[0]), null);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.log(SELF, Level.SEVERE, this.formatMessage(format, arg), null);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.log(SELF, Level.SEVERE, this.formatMessage(format, arg1, arg2), null);
        }
    }

    public void error(String format, Object[] args) {
        if (this.isErrorEnabled()) {
            this.log(SELF, Level.SEVERE, this.formatMessage(format, args), null);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(SELF, Level.SEVERE, this.formatMessage(msg, new Object[0]), t);
        }
    }

    private void log(String callerFQCN, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.getName());
        record.setThrown(t);
        JDK14LoggerAdapter.fillCallerData(callerFQCN, record);
        this.logger.log(record);
    }

    private static void fillCallerData(String callerFQCN, LogRecord record) {
        String className;
        int i;
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int length = steArray.length;
        int selfIndex = -1;
        for (i = 0; i < length; ++i) {
            className = steArray[i].getClassName();
            if (!className.equals(callerFQCN) && !className.equals(SUPER)) continue;
            selfIndex = i;
            break;
        }
        for (i = selfIndex + 1; i < length; ++i) {
            className = steArray[i].getClassName();
            if (className.equals(callerFQCN) || className.equals(SUPER)) continue;
            StackTraceElement ste = steArray[i];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
            break;
        }
    }

    public void log(Marker marker, String callerFQCN, int level, String msg, Throwable t) {
        Level julLevel;
        switch (level) {
            case 0: {
                julLevel = Level.FINE;
                break;
            }
            case 1: {
                julLevel = Level.INFO;
                break;
            }
            case 2: {
                julLevel = Level.WARNING;
                break;
            }
            case 3: {
                julLevel = Level.SEVERE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Level number " + level + " is not recognized.");
            }
        }
        this.log(callerFQCN, julLevel, msg, t);
    }

    public void debug(String format, Object[] args, Throwable t) {
        if (this.isDebugEnabled()) {
            String msgStr = MessageFormat.format(format, args);
            this.log(SELF, Level.FINE, msgStr, t);
        }
    }

    public void info(String format, Object[] args, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(SELF, Level.INFO, this.formatMessage(format, args), t);
        }
    }

    public void warn(String format, Object[] args, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(SELF, Level.WARNING, this.formatMessage(format, args), t);
        }
    }

    public void error(String format, Object[] args, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(SELF, Level.SEVERE, this.formatMessage(format, args), t);
        }
    }
}

