/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.service;

import it.imolinfo.jbi4cics.configuration.ConfigurationManager;
import it.imolinfo.jbi4cics.connection.ConnectionManager;
import it.imolinfo.jbi4cics.connection.ConnectionManagerFactory;
import it.imolinfo.jbi4cics.exception.Jbi4cicsException;
import it.imolinfo.jbi4cics.locator.ServiceLocation;
import it.imolinfo.jbi4cics.locator.ServiceLocator;
import it.imolinfo.jbi4cics.locator.ServiceLocatorFactory;
import it.imolinfo.jbi4cics.messageformat.MessageFormatter;
import it.imolinfo.jbi4cics.messageformat.MessageFormatterFactory;
import it.imolinfo.jbi4cics.security.Account;
import it.imolinfo.jbi4cics.security.SecurityManager;
import it.imolinfo.jbi4cics.security.SecurityManagerFactory;
import it.imolinfo.jbi4cics.service.ServiceContext;

public class ServiceManager {
    public Object handleService(String name, Object input) throws Jbi4cicsException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        ServiceContext serviceContext = configurationManager.createServiceContext(name, input);
        ServiceLocator serviceLocator = ServiceLocatorFactory.createLocator(serviceContext);
        ServiceLocation serviceLocation = serviceLocator.locateService(serviceContext);
        serviceContext.setServiceLocation(serviceLocation);
        SecurityManager securityManager = SecurityManagerFactory.createSecurityManager(serviceContext);
        Account account = securityManager.getAccount(serviceContext);
        serviceContext.setAccount(account);
        MessageFormatter inputMessageFormatter = MessageFormatterFactory.createMessageFormatter(serviceContext, true);
        inputMessageFormatter.mapInputBeanToInputMessage(serviceContext);
        ConnectionManager connectionManager = ConnectionManagerFactory.createConnectionManager(serviceContext);
        connectionManager.handleCall(serviceContext);
        MessageFormatter outputMessageFormatter = MessageFormatterFactory.createMessageFormatter(serviceContext, false);
        outputMessageFormatter.mapOutputMessageToOutputBean(serviceContext);
        return serviceContext.getOutputBean();
    }
}

