/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.messageformat.commarea;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.messageformat.FieldDescriptor;
import it.imolinfo.jbi4cics.messageformat.MappingDescriptor;
import it.imolinfo.jbi4cics.messageformat.MessageFormatter;
import it.imolinfo.jbi4cics.messageformat.commarea.CommareaBeanMappingDescriptor;
import it.imolinfo.jbi4cics.service.ServiceContext;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolFieldFormatter;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolTypeDescriptor;
import it.imolinfo.jbi4cics.typemapping.cobol.HexDump;
import java.util.Map;
import org.apache.commons.beanutils.ConvertingWrapDynaBean;
import org.apache.commons.beanutils.WrapDynaBean;

public final class CommareaFormatter
implements MessageFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(CommareaFormatter.class);

    public void mapInputBeanToInputMessage(ServiceContext context) throws FormatException {
        MappingDescriptor desc = context.getInputMappingDescriptor();
        WrapDynaBean bean = new WrapDynaBean(context.getInputBean());
        int offset = 0;
        if (!(desc instanceof CommareaBeanMappingDescriptor)) {
            LOG.error("CIC001702_Expected_commarea_bean_mapping_descriptor", desc.getClass());
            throw new FormatException("CIC001702_Expected_commarea_bean_mapping_descriptor", new Object[]{desc.getClass()});
        }
        byte[] buffer = new byte[((CommareaBeanMappingDescriptor)desc).getBufferedLength()];
        for (Map.Entry<String, FieldDescriptor> entry : desc.getFieldMap().entrySet()) {
            CobolTypeDescriptor ctDesc = (CobolTypeDescriptor)entry.getValue();
            String propertyName = entry.getKey();
            Object value = bean.get(propertyName);
            CobolFieldFormatter.format(value, buffer, ctDesc, offset);
            offset += ctDesc.getBufferedLength();
        }
        context.setInputMessage(buffer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("formatted input bean: [" + context.getInputBean() + "]\nin input buffer: " + HexDump.toHex(buffer) + "\nformatted input bean: [" + context.getInputBean() + "]\nin input buffer: [" + HexDump.dump(buffer, 0L, 0) + "]");
        }
    }

    public void mapOutputMessageToOutputBean(ServiceContext context) throws FormatException {
        ConvertingWrapDynaBean bean;
        MappingDescriptor desc = context.getOutputMappingDescriptor();
        Object outputMessage = context.getOutputMessage();
        int offset = 0;
        if (!(desc instanceof CommareaBeanMappingDescriptor)) {
            LOG.error("CIC001702_Expected_commarea_bean_mapping_descriptor", desc.getClass());
            throw new FormatException("CIC001702_Expected_commarea_bean_mapping_descriptor", new Object[]{desc.getClass()});
        }
        if (!(outputMessage instanceof byte[])) {
            Object[] args = new Object[]{outputMessage.getClass()};
            LOG.error("CIC001703_Expected_byte_array", args);
            throw new FormatException("CIC001703_Expected_byte_array", args);
        }
        byte[] buffer = (byte[])outputMessage;
        try {
            Object instance = desc.getBeanClass().newInstance();
            bean = new ConvertingWrapDynaBean(instance);
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw new FormatException(e);
        }
        catch (InstantiationException e) {
            LOG.error(e.getLocalizedMessage(), e);
            throw new FormatException(e);
        }
        for (Map.Entry<String, FieldDescriptor> entry : desc.getFieldMap().entrySet()) {
            CobolTypeDescriptor ctDesc = (CobolTypeDescriptor)entry.getValue();
            String propertyName = entry.getKey();
            Object value = CobolFieldFormatter.unformat(buffer, ctDesc, offset);
            bean.set(propertyName, value);
            offset += ctDesc.getBufferedLength();
        }
        context.setOutputBean(bean.getInstance());
        if (LOG.isDebugEnabled()) {
            LOG.debug("formatted output buffer: [" + HexDump.toHex(buffer) + "]\nin output bean: " + context.getOutputBean() + "\nformatted output buffer: [" + HexDump.dump(buffer, 0L, 0) + "]\nin output bean: " + context.getOutputBean());
        }
    }
}

