/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.messageformat;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.messageformat.FieldDescriptor;
import it.imolinfo.jbi4cics.messageformat.MappingDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.WrapDynaClass;
import org.apache.commons.collections.map.ListOrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoOpMappingDescriptor
implements MappingDescriptor {
    private Class beanClass;
    private static final Logger LOG = LoggerFactory.getLogger(NoOpMappingDescriptor.class);
    private static final Messages MESSAGES = Messages.getMessages(NoOpMappingDescriptor.class);

    @Override
    public void addFieldMapping(String propertyName, String fieldName, FieldDescriptor fieldDescriptor) throws FormatException {
        throw new FormatException(MESSAGES.getString("CIC001600_Error_adding_field_mapping", new Object[0]));
    }

    @Override
    public void addFieldMapping(String propertyName, Integer fieldIndex, FieldDescriptor fieldDescriptor) throws FormatException {
        throw new FormatException(MESSAGES.getString("CIC001600_Error_adding_field_mapping", new Object[0]));
    }

    @Override
    public Map<String, FieldDescriptor> getFieldMap() throws FormatException {
        WrapDynaClass dynaClass = WrapDynaClass.createDynaClass((Class)this.beanClass);
        WrapDynaClass dynaSuperClass = WrapDynaClass.createDynaClass(this.beanClass.getSuperclass());
        Object[] superClassProperties = dynaSuperClass.getDynaProperties();
        Object[] properties = dynaClass.getDynaProperties();
        LOG.debug("class property: " + Arrays.toString(properties));
        LOG.debug("super class property: " + Arrays.toString(superClassProperties));
        List<Object> superClassPropertyList = Arrays.asList(superClassProperties);
        List<Object> classPropertyList = Arrays.asList(properties);
        ArrayList<DynaProperty> classPropertyListCopy = new ArrayList<DynaProperty>();
        for (DynaProperty dynaProperty : classPropertyList) {
            for (DynaProperty dynaProperty2 : superClassPropertyList) {
                if (dynaProperty.getName().equals(dynaProperty2.getName()) && dynaProperty.getType().equals(dynaProperty2.getType())) continue;
                classPropertyListCopy.add(dynaProperty);
            }
        }
        LOG.debug("remained properties: " + classPropertyListCopy);
        ListOrderedMap fieldMap = new ListOrderedMap();
        for (final DynaProperty property : classPropertyListCopy) {
            LOG.debug("adding property: " + property.getName());
            fieldMap.put(property.getName(), new FieldDescriptor(){

                public Class getPreferredJavaType() {
                    return property.getType();
                }
            });
        }
        return fieldMap;
    }

    @Override
    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    @Override
    public Class getBeanClass() {
        return this.beanClass;
    }

    @Override
    public void setCodePage(String codePage) {
    }
}

